<?php
/**
* @package asama
* @category include/parts
*/
global $HSTL;
$MD = $HSTL->theMode();
$EXNUM = ($HSTL->isExcerptNumber())?$HSTL->EXCERPT_NUMBER:55; ?>
<?php /* ARCHIVE TYPE */
if($MD==='HOME' || $MD==='ACHV' || $MD==='RSLT'): ?>
	<article id='post-<?php get_the_ID(); ?>' <?php post_class('column hustleFlex'); ?> name='ThumbColumn' role='column'>
	<header class='post'>
	<?php if(has_post_thumbnail()):
		//CONFIG
		$imgSz = 'large';
		$asIdx = 1.414;
		$rslt = $HSTL->UTL::getAsamaThumbImgPrp($asIdx, 'thmb', $imgSz);
		?>
		<figure class='hustleImageFlex'><a class='<?php echo $rslt['n']; ?>' href='<?php echo esc_url(get_permalink()) ?>' style='width:<?php echo $rslt['v']; ?>'><?php the_post_thumbnail($imgSz); ?></a></figure>
	<?php else: ?>
		<figure class='noThumbnail'></figure>
	<?php endif; ?>
	</header>
	<section class='post'>
	<div class='title'>
	<?php the_title(sprintf('<h1 class="post-title"><a href="%s">', esc_url(get_permalink())), '</a></h1>'); ?>
	</div>
	<div class='colophone'>
		<p class='post-date'><span class='title'><?php _e('Date').' : ' ?></span><time datetime='<?php the_time("Y-m-d"); ?>'><?php the_time('Y.n.j'); ?></time></p>
		<p class='post-author'><span class='title'><?php _e('Author').' : ' ?></span><?php the_author_posts_link(); ?></p>
		<?php
		$txnmys = get_post_taxonomies(get_the_ID());
		$cateString = '';
		foreach($txnmys as $txnm):
			//通常投稿とカムタム投稿タイプ共に、タクソノミーが階層を有するかによってカテゴリーを選別ができる。
			//通常投稿ではget_the_category()でカテゴリーリストを取得してから、
			//foreachで回して名前（$taget->name）とリンク（get_category_link($taget->id)）を取得していたが、同じソースで処理が可能となった。
			//$HSTL->echoo('POST_XAXSONOMY_>'.esc_html($txnm).'_HIERARCHICAL_>'.esc_html(get_taxonomy($txnm)->hierarchical));
			if($txnm!=='post_format' && get_taxonomy($txnm)->hierarchical):
				$cateString .= get_the_term_list(get_the_ID(), $txnm, $before='', $sep='', $after='');
			endif;
		endforeach;
		if(empty($cateString)) $cateString = '<span class="attention">... '.__('empty', 'asama').' .</span>';
		?>
		<p class='post-category'><span class='title'><?php _e('Categories').' : ' ?></span><?php echo $cateString; ?></p>
	</div>
	<div class='excerpt'>
	<?php
		$content = get_the_content();//投稿テキストを取得する
		$content = wp_strip_all_tags( $content );//HTMLタグをすべて取り除く
		$content = strip_shortcodes( $content );//ショートコードを取り除く
		//指定文字数に抜粋して後ろにリンクを付ける
		$content = wp_trim_words($content,  $EXNUM, sprintf('<a href="%s"><span class="webIcon-More"></span></a>', esc_url(get_permalink())));
		echo '<p>'.$content.'</p>';//出力する
	?>
	<div>
	</section>
	<!-- <footer class='post'></footer> -->
	</article>
<?php /* SNGLE TYPE */
elseif($MD==='SNGL'):
	$presentPost = $HSTL->isTheThemePost(get_the_time('Y-m-d H:i'))?'asama':'former';
	?>
	<article id='post-<?php echo get_the_ID(); ?>' <?php post_class('column'); ?> name='PostColumn' role='column-<?php echo $presentPost ?>'>
	<header class='post'>
	<?php if(has_post_thumbnail()):
		$rslt = $HSTL->UTL::getAsamaThumbImgPrp($HSTL->aspect_index, 'single-head');
		?>
		<figure class='hustleImageFlex' style='max-width:<?php echo $rslt['v']; ?>'><div class='<?php echo $rslt['n']; ?>'><?php the_post_thumbnail(); ?></div></figure>
	<?php endif; ?>
	<?php the_title('<h1 class="post">', '</h1>'); ?>
	</header>
	<section class='post'>
	<?php the_content(); ?>
	</section>
	<footer class='post'>
	<?php if(is_singular($HSTL->getHustlePostType()) || is_singular('post')): ?>
		<article class='colophone' name='Colophon'>
		<p class='post-date'><span class='title'><?php _e('Date').' : ' ?></span><time datetime='<?php the_time("Y-m-d"); ?>'><?php the_time('Y.n.j'); ?></time></p>
		<p class='post-author'><span class='title'><?php _e('Author').' : ' ?></span><?php the_author_posts_link(); ?></p>
		<?php
		//$HSTL->echoo('POST_ID_>'.esc_html(get_the_ID()).'_TYPE_>'.esc_html(get_post_type()));
		$txnmys = get_post_taxonomies(get_the_ID());
		$cateString = '';
		$tagString = '';
		foreach($txnmys as $txnm):
			if($txnm!=='post_format'):
				//通常投稿とカムタム投稿タイプ共に、タクソノミーが階層を有するかによってカテゴリーとタグを選別ができる。
				//通常投稿is_singular('post')の条件下では、それぞれget_the_category()とget_the_tags()でタクソノミーリスト取得してから、
				//foreachで回して、名前（$taget->name）とリンク（get_category_link($taget->id)とget_tag_link($taget->id)）を取得していたが、同じソースで処理が可能となった。
				//$HSTL->echoo('COLUMN_POST_XAXSONOMY_>'.esc_html($txnm).'_HIERARCHICAL_>'.esc_html(get_taxonomy($txnm)->hierarchical));
				if(get_taxonomy($txnm)->hierarchical):
					$cateString .= get_the_term_list(get_the_ID(), $txnm, $before='', $sep='', $after='');
				else:
					$tagString .= get_the_term_list(get_the_ID(), $txnm, $before='', $sep='', $after='');
				endif;
			endif;
		endforeach;
		if(empty($cateString)) $cateString = '<span class="attention">... '.__('empty', 'asama').' .</span>';
		if(empty($tagString)) $tagString = '<span class="attention">... '.__('empty', 'asama').' .</span>';
		?>
		<p class='post-category'><span class='title'><?php _e('Categories').' : ' ?></span><?php echo $cateString; ?></p>
		</article>
		<article class='tags' name='Tags'><span class='title'><?php _e('Tags').' : ' ?></span><?php echo $tagString; ?>
		</article>
	<?php endif; ?>
	<?php //ポストのコメント表示
	comments_template('/include/parts/column-comments.php');
	?>
	<?php //ページ分割への対応
	$link_pages_args = array(
		'before' => '<article class="links">',
		'next_or_number' => 'next',
	);
	wp_link_pages($link_pages_args); ?>
	</footer>
	</article>
<?php /* PAGE TYPE */
elseif($MD==='FRNT' || $MD==='PAGE'): ?>
	<article id='post-<?php get_the_ID(); ?>' <?php post_class('column'); ?> name='PageColumn' role='column'>
	<header class='post'>
	<?php if(has_post_thumbnail()):
		$rslt = $HSTL->UTL::getAsamaThumbImgPrp($HSTL->aspect_index);
		?>
		<figure class='hustleImageFlex' style='max-width:<?php echo $rslt['v']; ?>'><div class='<?php echo $rslt['n']; ?>'><?php the_post_thumbnail(); ?></div></figure>
	<?php endif; ?>
	<?php the_title('<h1 class="post">', '</h1>'); ?>
	</header>
	<section class='post'>
	<?php the_content(); ?>
	</section>
	<footer class='post'></footer>
	</article>
<?php endif;