<?php
/**
* @package asama
* @category include/shortcode
*/
// Short Code : [hustleShort file="include/shortcode/ExteriorPost" uri="hustlemousse.com/feed/" num="3" chrs="55" ttl="FEED"]
/**
* 属性パラメータはダブルクォテーションで記述する。
* file=""はテーマディレクトリからのソースファイルへのパス（拡張子は不要）
* uri=""は取得するRSSのURL。
* num=""は表示する投稿数、初期値を3とする。
* chrs=""は投稿の頭から切り出す文字数、初期値を55とする。
* ttl=""は任意のフィードブロックタイトルの文字列。
*/
$HSTL = get_query_var('HSTL');
$args = get_query_var('params');
//すごく長い可能性もあるので記事タイトルの文字数制限を設ける。
$hdChrs = 128;
extract(shortcode_atts(array(
	'uri' => '',
 	'num' => '3',
	'ttl' => 'FEED',
	'chrs' => '55',
), $args));
include_once(ABSPATH.WPINC.'/feed.php' );
$rss = fetch_feed($uri);
if (!is_wp_error($rss)) {
	$max = $rss->get_item_quantity($num);
	$items = $rss->get_items(0, $max);
	$r = '<h1 class="exteriorPosts">'.$ttl.'</h1><ul class="exteriorPosts">';
	//各記事を処理する。
	foreach($items as $itm):
		//記事へのリンク
		$link = $itm->get_permalink();
		//記事の最初画像
		$src = '';
		if($itm->get_description()!==null && preg_match('/<img.+?src=[\'"]([^\'"]+?)[\'"].*?>/msi', $itm->get_description(), $img)):
			$src = esc_attr($img[1]);
		endif;
		//記事のタイトル
		$psTtl = $itm->get_title();
		if($psTtl!==null && mb_strlen($psTtl)>$hdChrs):
			$psTtl = mb_substr($psTtl,0,$hdChrs).'<span class="webIcon-More"></span>';
		endif;
		//記事の冒頭抜粋
		$psExt = $itm->get_description();
		if($psExt!==null):
			$psExt = preg_replace('/<figure[^>]*>.*?<\/figure>|<img[^>]+>/msi', '', $psExt);
			if(mb_strlen($psExt)>$chrs):
				$psExt = mb_substr($psExt,0,$chrs).'<a href="'.$link.'" target="_blank"><span class="webIcon-More"></span></a>';
			else:
				$psExt = mb_substr($psExt,0,mb_strlen($psExt)-1).'<a href="'.$link.'" target="_blank"><span class="webIcon-More"></span></a>';
			endif;
		endif;
		//記事の投稿日
		$date = date('Y.m.d', strtotime($itm->get_date()));
		//記事をHTMLに成形
		if($src!==''):
			$r .= '<li rel="" class="ext-post"><figure class="hustleImageFlex"><img src="'.$src.'" alt="" ></figure><h2 class="ext-ttl"><a href="'.$link.'" target="_blank">'.$psTtl.'</a></h2><p class="ext-cnt">'.$psExt.'</p><p class="ext-meta">'.__('Post').' : '.$date.'</p></li>';
		else:
			$r .= '<li rel="" class="ext-post"><figure class="noThumbnail"></figure><h2 class="ext-ttl"><a href="'.$link.'" target="_blank">'.$psTtl.'</a></h2><p class="ext-cnt">'.$psExt.'</p><p class="ext-meta">'.__('Post').' : '.$date.'</p></li>';
		endif;
	endforeach;
	$r .= '</ul>';
	wp_reset_postdata();
	echo $r;
}