<?php
/**
* @package asama
* @category include/shortcode
*/
// Short Code : [hustleShort file="include/shortcode/ExtractPost" pst="post" cat="0" txnm="" num="5" chrs="55" ttl="NEWS"]
/**
* 属性パラメータはダブルクォテーションで記述する。
* file=""はテーマディレクトリからのソースファイルへのパス（拡張子は不要）
* pst=""はポストタイプ（英数小文字）で初期値は基本投稿タイプ'post'とする。
* cat=""はカテゴリーIDで、複数であれば'1,2'、除外するときは'-10'などと記述する。初期値は0なので初期値も0にする。
* num=""は取得して表示する投稿数、省略時は5なので初期値も5にする。
* chrs=""は投稿の頭から切り出す文字数、省略時は55なので初期値も55にする。
* slg=""はカテゴリー名（スラッグ）で当初は項目に入れていたが、英数小文字だけで運用されないケースがあるので仕様から排除する。
* txnm=""は投稿ポストに追加登録したカテゴリー機能のタクソノミーで、カテゴリーIDの指定はこれに対応する。
* ttl=""は任意の見出しで指定があれば優先される。
*/
$HSTL = get_query_var('HSTL');
$args = get_query_var('params');
extract(shortcode_atts(array(
	'pst' => 'post',
	'num' => '5',
	'cat' => '0',
	'chrs' => '55',
	'txnm' => '',
	'ttl' => '',
), $args));
global $post;
$evctPost = $post;//グローバルの$postを一時退避させる。
$params = array(
	'numberposts' => $num,
	'orderby' => 'post_date',
	'order' => 'DESC',
	'post_type' => $pst,
);
if(!empty($cat) || $cat!=='0') {
	$ids = str_replace(' ', '', $cat);
	$ids = explode(',', $ids);
	$ids = array_map('intval', $ids);
	//カテゴリー指定があった場合の処理
	if($pst==='post' && empty($txnm)) $params['category'] = $cat;
	else {
		//カテゴリー指定（タクソノミー）についてはここで下処理を済ませる。（カスタム投稿だけでなく'post'投稿への新規カテゴリー指定も含む。）
		//残念ながら、正常動作しない場合があってカテゴリー指定は推奨できない。切っておいた方が良いかも。
		/* $nms = array();
		$slgs = array();
		$tmp = array();
		$trms = get_terms($txnm);
		$i = 0;
		foreach($trms as $t):
			if(in_array($t->term_id, $ids)) {
				$nms[] = $t->name;
				$slgs[] = $t->slug;
				$tmp[] = $t->term_id;
			}
			$i++;
		endforeach;
		$tmp = array_diff($ids,$tmp);
		foreach($tmp as $t):
			$nms[] = 'Post_>'.$t.'_undefind';
		endforeach;
		$params['tax_query'] = array(
			array(
				'taxonomy' => $txnm,
				'field' => 'term_id',
				'terms' => $ids,
				//'field' => 'slug',
				//'terms' => $slgs,
			),
		); */
		$cat = 0;
	}
}
//投稿タイプが公開されているか確認する
if(get_post_type_object($pst)->public):
	//$paramsを投げ込むと指定のポスト配列が返って来る。'category'と'category_name'はどっちが優先されるのだろうか？本ショートコードではID運用とする。
	$ps = get_posts($params);
	if(empty($ttl) || $ttl==='') {
		if(empty($cat) || $cat==='0') {
			if($pst==='post') $ttl = __('lately posts','asama');
			else $ttl = get_post_type_labels(get_post_type_object($pst))->name;
		} else {
			$ttl = __('lately','asama').' : ';
			$i = 0;
			foreach($ids as $id):
				if($pst==='post') {
					$tmp = get_category($id)?get_category($id)->name:'Post_>'.$id.'_undefind';
				} else {
					$tmp = $nms[$i];
				}
				$ttl = $i===0?($ttl.$tmp):($ttl.' | '.$tmp);
				$i++;
			endforeach;
		}
	}
	$r = '<h1 class="extractPosts">'.$ttl.'</h1><ul class="extractPosts">';
	foreach($ps as $p):
		if($p->comment_count > 0) {
			$isCommentMsg = '<a href="'.get_permalink($p->ID).'#comments">'.__('Comments').' : '.$p->comment_count.'</a>';
		} else {
			$isCommentMsg = '<a href="'.get_permalink($p->ID).'#respond">'.__('Comments').' : 0</a>';
		}
		$thumb = '';
		$imgSz = 'medium';
		if(has_post_thumbnail($p->ID)):
			if(!empty($HSTL)) ://あさま以外でも動作する可能性を残す
				//SVGファイルはNULLが返ってくる
				$thumb_size = $HSTL->UTL::getThumbWH($p->ID, $imgSz);
				$aspect_ratio = 0;
				if($thumb_size !== null)://SVGファイルでないことを確認する
					$aspect_ratio = $thumb_size['h']/$thumb_size['w'];
				endif;
				$fiXY = $aspect_ratio>$HSTL->aspect_index?'fiy':'fix';
			else:
				$fiXY = 'fix';
			endif;
			$thumb = '<figure class="hustleImageFlex"><a class="'.$fiXY.'" href="'.esc_url(get_permalink($p->ID)).'" target="_self">'.get_the_post_thumbnail($p->ID, $imgSz).'</a></figure>';
		else:
			$thumb = '<figure class="noThumbnail"></figure>';
		endif;
		$content = $p->post_content;//投稿テキストを取得する
		$content = wp_strip_all_tags($content);//HTMLタグをすべて取り除く
		$content = strip_shortcodes($content);//ショートコードを取り除く
		$content = wp_trim_words($content, $chrs, '<a href="'.esc_url(get_permalink($p->ID)).'"><span class="webIcon-More"></span></a>');//抜粋する
		$cs = get_the_category($p->ID);
		$cate = '';
		$i = 0;
		foreach($cs as $c):
			if($i++ > 0) $cate.=',';
			$cate.=$c->name;
		endforeach;
		$r .= '<li rel="'.$cate.'" class="ext-post">'.$thumb.'<h2 class="ext-ttl"><a href="'.esc_url(get_permalink($p->ID)).'">'.$p->post_title.'</a></h2><p class="ext-cnt">'.$content.'</p><p class="ext-meta">'.__('Post').' : '.get_the_date('Y.n.j', $p->ID).' | '.$isCommentMsg.'</p></li>';
	endforeach;
	$r .= '</ul>';
	$post = $evctPost;
	echo $r;
endif;
