<?php
/**
* @package asama
* @category include/shortcode
*/
// Short Code : [hustleShort file="include/shortcode/TagCloud" smallest="1.0" largest="3.0" unit="rem" number="55" pst="0"]
/**
* 属性パラメータはダブルクォテーションで記述する。
* file=""はテーマディレクトリからのソースファイルへのパス（拡張子は不要）
* smallest=""は文字サイズの最小値
* largest=""は文字サイズの最大値
* unit=""は文字サイズの単位
* number=""は表示するタグ数
* pst=""は投稿名（例えば'post'）を入れる。省略するか"0"を入力すれば公開されている全タグが対象になる。
*/
$HSTL = get_query_var('HSTL');
$args = get_query_var('params');
extract(shortcode_atts(array(
	'smallest'=>'1.0',
	'largest'=>'3.0',
	'unit'=>'rem',
	'number'=>'55',
	'pst'=>'0',
), $args));
if(empty($pst)):
	$txnmys = get_taxonomies(array('public'=>true,'hierarchical'=>false), 'names');
else:
	$txnmys = get_taxonomies(array('public'=>true,'hierarchical'=>false,'object_type'=>[$pst]), 'names');
endif;
foreach($txnmys as $txnm):
	if($txnm!=='post_format'):
		$tagNames[] = $txnm;
	endif;
endforeach;
$tagObjs = [];
$tagCloud = '<ul class="hustleTagCloud" role="list">';
foreach($tagNames as $nm):
	$tagObjs = array_merge($tagObjs, get_tags(array('taxonomy'=>$nm,'hide_empty'=>true,)));
endforeach;
usort($tagObjs, function($a,$b){
	return (int)$b->count <=> (int)$a->count;
});
$tagObjs = array_slice($tagObjs, 0, (int)$number);
$ratio = 0;
$base = (int)$tagObjs[count($tagObjs)-1]->count;
if((int)$tagObjs[0]->count-(int)$tagObjs[count($tagObjs)-1]->count > 0):
	$ratio = ((float)$largest-(float)$smallest)/((int)$tagObjs[0]->count-$base);
endif;
shuffle($tagObjs);
foreach($tagObjs as $tag):
	$tagCloud .=  '<li><a href="'.esc_url(get_tag_link($tag->term_id)).'" style="font-size:'.esc_html(round((float)$smallest+((int)$tag->count-$base)*$ratio,3)).$unit.'">'.esc_html($tag->name).'</a></li>';
endforeach;
echo $tagCloud .= '</ul>';