<?php
/**
* @package asama
* @category include/stuff
*/
//--------------------------------------------------------------------------------
// studio hustlemouse
// PHP Code 'ActivationClass.php'
// Create : 2021.3.24
// Modify : 2023.11.25
// Author : maruhiro
// (c)maruhiro all rights reserved.
//--------------------------------------------------------------------------------
class ActivationClass {
	private $HSTL;
	//フィードの抜粋指定
	private $excerptNum = 0;
	private $excerptMor = 0;
	//--------------------------------------------------------------------------------
	// CONSTRUCTOR（戻り値は設定できない。）
	//--------------------------------------------------------------------------------
	public function __construct(object $obj) {$this->HSTL = $obj;}
	//自信のクラス名をマジックメソッドで返す。
	public static function who() {return __CLASS__;}
	//--------------------------------------------------------------------------------
	// INITIALIZE
	//--------------------------------------------------------------------------------
	public function init() {
		add_filter('upload_mimes', array($this, 'allowUploadMIMES'));
		add_filter('get_search_form', array($this, 'arrangeSearchForm'));
		add_filter('get_the_archive_title', array($this, 'arrangeArchivesTitle'));
		//カスタム投稿タイプのRSSも出力する。
		add_filter('request', array($this, 'feedCustomPostTypes'));
		//フィードの抜粋指定を取得
		add_filter('excerpt_length', array($this, 'getExcerptNum'));
		add_filter('excerpt_more', array($this, 'getExcerptMor'));
		//RSSにアイキャッチ画像（サムネールサイズ）を加えて出力する。
		add_filter('the_excerpt_rss', array($this, 'addThumbnailToFeed'));
		add_filter('the_content_feed', array($this, 'addThumbnailToFeed'));
		/*** ACTIVATE SHORT CODE ON WIDGET ***/
		//ウィジェットでショートコードを使えるようにする。
		add_filter('widget_text', 'do_shortcode');
		if(file_exists('wp-seo.php')) {
			/*** コメントの「返信」ボタンが正常に動作せずに階層運用ができない問題を解消する。 ***/
			if (is_plugin_active('wordpress-seo/wp-seo.php') || is_plugin_active('wordpress-seo-premium/wp-seo-premium.php') ) {
				//Yoast SEOプラグインの"wpseo_remove_reply_to_com"フィルターに対してfalseが返るようにする。
				add_filter('wpseo_remove_reply_to_com', '__return_false');
			}
		}
		add_shortcode('hustleShort', array($this, 'doHustleShortcode'));
	}
	//--------------------------------------------------------------------------------
	// FILTERS
	//--------------------------------------------------------------------------------
	//注意：MIMESの追加医登録にあたりwp-config.phpにまずは次行を挿入する。
	//define('ALLOW_UNFILTERED_UPLOADS', true);
	public function allowUploadMIMES($mimes) {
		//SVG画像のアップロードを許可する。
		$mimes['svg'] = 'image/svg-xml'; 
		return $mimes;
	}
	/* 検索フォームの出力カスタマイズ */
	public function arrangeSearchForm($form) {
		$form = '<form role="search" method="get" class="searchFrm hustleFlex" action="'.home_url('/').'" name="SearchForm">
		<fieldset><label>
		<input type="search" placeholder="'.esc_attr__('Search').'..." value="'.get_search_query().'" name="s" id="search" title="'.esc_attr__('Search'). '" class="searchFild"></label></fieldset>
		<fieldset><label><button type="submit" name="SearchSubmit" class="webIcon-Search"></button></label>
		</fieldset>
		</form>';
		return $form;
	}
	/* アーカイブズタイトルの取得カスタマイズ */
	public function arrangeArchivesTitle($title) {
		if(is_post_type_archive()):
			$title = esc_html(get_post_type_object(get_post_type(get_the_ID()))->label);
		else:
			if(is_category()):
				$title = single_cat_title( '', false );
			elseif(is_tag()):
				$title = single_tag_title( '', false );
			elseif(is_date()):
				if(is_year()):
					$title = get_the_time('Y');
				elseif(is_month()):
					$title = get_the_time('Y.n');
				else:
					$title = get_the_time('Y.n.d');
				endif;
			elseif(is_author()):
				$title = get_the_author();
			elseif(is_tax()):
				if(get_taxonomy(get_queried_object()->taxonomy)->hierarchical):
					$title = single_cat_title( '', false );
				else:
					$title = single_tag_title( '', false );
				endif;
			endif;
		endif;
		return '<span>'.__('Articles list', 'asama').' : '.$title.'</span>';
	}
	//カスタム投稿タイプのRSSも出力する。
	public function feedCustomPostTypes($vs) {
		if (!empty($this->HSTL->postTypes) && isset($vs['feed']) && !isset($vs['post_type'])) {
			$vs['post_type'] = array_merge(['post'],$this->HSTL->postTypes);
		}
		return $vs;
	}
	//フィードの抜粋入力の文字数を取得
	public function getExcerptNum($n){
		$this->excerptNum = $n;
		return $n;
	}
	//フィードの続き読む表現を取得
	public function getExcerptMor($s){
		$this->excerptMor = $s;
		return $s;
	}
	//RSSにアイキャッチ画像（サムネールサイズ）を加えて出力する。
	public function addThumbnailToFeed($cnt) {
		global $post;
		if(empty($cnt)) {
			$cnt = $post->post_content;//投稿テキストを取得する
			$cnt = wp_strip_all_tags($cnt);//HTMLタグをすべて取り除く
			$cnt = strip_shortcodes($cnt);//ショートコードを取り除く
			$cnt = wp_trim_words($cnt, $this->excerptNum, $this->excerptMor);//抜粋する
		}
		if($this->HSTL->isAddThumbnailForRss()) {
			if(has_post_thumbnail($post->ID)) {
				$cnt = get_the_post_thumbnail($post->ID).$cnt;
			}
			return $cnt;
		}
	}
	//--------------------------------------------------------------------------------
	// SHORT CODES
	//--------------------------------------------------------------------------------
	/*** LOAD SOME SHORT CODES ***/
	/*phpソースを動的にインクルードして動作させるための汎用関数を実装する。*/
	public function doHustleShortcode($params=array()) {
		//extractは、連想配列から変数を作成する
		extract(shortcode_atts(array('file'=>'default'), $params));
		ob_start();//バッファリング開始
		set_query_var('HSTL', $GLOBALS['HSTL']);//テーマのメインオブジェクトの参照を渡す。
		set_query_var('params', $params);//ショートコードのパラメータ配列の参照を渡す。
		get_template_part($file);//ロードしたソースをバッファする。
		return ob_get_clean();//バッファをクリアして出力
	}
}