<?php
/**
* @package asama
* @category include/stuff
*/
//--------------------------------------------------------------------------------
// studio hustlemouse
// PHP Code 'AdministrationClass.php'
// Create : 2021.3.24
// Modify : 2023.7.21
// Author : maruhiro
// (c)maruhiro all rights reserved.
//--------------------------------------------------------------------------------
class AdministrationClass {
	private $HSTL;
	//--------------------------------------------------------------------------------
	// CONSTRUCTOR（戻り値は設定できない。）
	//--------------------------------------------------------------------------------
	public function __construct(object $obj) {$this->HSTL = $obj;}
	//自信のクラス名をマジックメソッドで返す。
	public static function who() {return __CLASS__;}
	//--------------------------------------------------------------------------------
	// INITIALIZE
	//--------------------------------------------------------------------------------
	public function init() {
		global $pagenow;//このグローバル変数には表示画面のURL末尾が入っている
		if($pagenow==='post.php' || $pagenow==='post-new.php' || $pagenow==='edit.php') {
			add_action('admin_enqueue_scripts', array($this, 'tameEditorBlock'));
			add_action('admin_enqueue_scripts', array($this, 'jugEditorFonts'));
		}
	}
	//--------------------------------------------------------------------------------
	// TAME EDITOR BLOCK
	//--------------------------------------------------------------------------------
	public function tameEditorBlock() {
		//管理投稿ブロック用独自CSSの追加
		$this->HSTL->UTL::enqueueStyles($this->HSTL->tugEnqueueScripts('editorStyles'));
		add_theme_support('wp-block-styles');//ブロックエディター用基本CSSの読込
		add_theme_support('editor-styles');//管理画面ブロックエディター用CSSの読込
	}
	//--------------------------------------------------------------------------------
	// JUG EDITOR FONTS
	//--------------------------------------------------------------------------------
	public function jugEditorFonts() {
		$this->HSTL->UTL::enqueueStyles($this->HSTL->tugEnqueueScripts('editorFonts'));
	}
}