/****************************************************************
studio hustlemouse
JavaScript Code 'MainClass'
Author MARUHIRO
Create:2020.8.17
Modify:2022.9.25
(c)maruhiro all rights reserved.
****************************************************************/
//----------------------------------------------------------------
// OUTLINE
//----------------------------------------------------------------
// [FIELDS]
// *RG
// [METHODS]
// *constructor()
// *init()
// *setContent()
// *reset()
//----------------------------------------------------------------
class MainClass {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//Syntax:this.objectName = new MainClass();
	//Parameter:obj'はRegistrationClassオブジェクト
	//Return:なし
	constructor(obj) {
		this.value = 'MAIN CLASS';
		this.RG = obj;
		//----------------------------------------------------------------
		this.attributes = ['ID','CLASS','NAME','ROLE'];
		this.selector = 'body > .page, body > .sticky, body > .special';
		this.insert = 'before';
		this.tgglBtn;
		this.vizTggl;
		this.fnTgglShowBtn = e => this.toggleShowBtn(e);
	}
	init() {
		hustle.PU.VIZ({b:false, obj:hustle.PU.ID({id:'whiteBoard'})});
		this.setContent();
		this.reset();
		hustle.PU.VIZ({b:false, obj:hustle.PU.ID({id:'workingAnim'})});
		
	}
	setContent() {
		hustle.WFU.examElms({atrs:this.attributes,ins:this.insert,obj:hustle.PU.QSELECT({slc:'body'})});
		hustle.WFU.examElms({atrs:this.attributes,ins:this.insert,obj:hustle.PU.QSELECTS({slc:this.selector})});
		this.puInfoTgglBtn();
		this.tgglBtn = hustle.PU.BUTTON({nm:'ToggleBtn', obj:hustle.PU.FORM({nm:'ToggleBtnFrm'})});
		this.tgglBtn.addEventListener(this.RG.PEV.end, this.fnTgglShowBtn, false);
	}
	reset() {
		this.vizTggl = false;
		this.tgglBtn.innerText = 'SHOW';
		this.setVizInfo(this.vizTggl);
	}
	puInfoTgglBtn() {
		document.body.insertAdjacentHTML('afterbegin', '<div id="hustleAnalyzeBox">'+
		'<form name="ToggleBtnFrm"><fieldset name="ToggleBtnSet">'+
		'<legend><h1 dir name="ToggleBtnTtl">Markup Information</h1></legend>'+
		'<label><button type="button" class="tggleBtn" name="ToggleBtn">Show</button></label>'+
		'</fieldset></form></div>');
	}
	toggleShowBtn(e) {
		hustle.echo(`RECEIVED_A_EVENT_>${e.target}`, false);
		this.vizTggl = !this.vizTggl;
		if(this.vizTggl) e.target.innerText = 'HIDE';
		else e.target.innerText = 'SHOW';
		this.setVizInfo(this.vizTggl);
	}
	setVizInfo(b) {
		let prp = 'display';
		let vlu;
		//hustle.PU.testStyleWzList({slc:'p.elementInformation', obj:hustle.dsgnRules});
		let arr = hustle.PU.getMatchRules({slc:'p.elementInformation', obj:hustle.dsgnRules});
		vlu = b?'block':'none';
		arr.forEach((vl,id,ar) =>hustle.PU.setSTYLErule({prp, vlu, imp:'', obj:vl}));
		arr = hustle.PU.getMatchRules({slc:'span.elementInformation', obj:hustle.dsgnRules});
		vlu = b?'inline':'none';
		arr.forEach((vl,id,ar) =>hustle.PU.setSTYLErule({prp, vlu, imp:'', obj:vl}));
		arr = hustle.PU.getMatchRules({slc:'::placeholder', obj:hustle.dsgnRules});
		prp = 'visibility';
		vlu = b?'visible':'hidden';
		arr.forEach((vl,id,ar) =>hustle.PU.setSTYLErule({prp, vlu, imp:'', obj:vl}));
	}
}