/***************************************************************
studio hustlemouse
Javascript Code 'hustleConfig.js' for asama
Create : 2021.11.30
Modify : 2024.5.28
Author : maruhiro
(c)maruhiro all rights reserved.
***************************************************************/
//----------------------------------------------------------------
// OUTLINE
// [GLOVAL FIELDS]
// [HUSTLE FIELDS]
// [METHODS]
//----------------------------------------------------------------
// STRICT MODE（厳格モード）
'use strict';
//----------------------------------------------------------------
// CONFIGURATION
let hustle = new Object();
if(typeof asama === 'undefined') {
	//最初の環境設定として本スクリプトがロードされる場合の処理。
	console.log('BASE_OBJECT_"asama"_IS_NONE.');
	//WORKING ON SOME SERVICE
	//hustle.onService = false;
	//PROJECT DIRECTORY NAME
	//hustle.project = 'myProject';
	//SERVICE WORKER ACTIVATE
	//hustle.serviceWorker = false;
	//ELEMENTS VISUALIZE
	//hustle.elemantsVisualize = true;
} else {
	//Wordpressテーマ「あさま」の「header.php」ソース内のヘッダーで生成される「asama」オブジェクトが存在した場合の処理。
	console.log('BASE_OBJECT_"asama"_IS_HERE.');
	//WORKING ON SOME SERVICE
	hustle.onService = true;
	//THEME DIRECTORY URI
	hustle.dirUri = asama.dirUri;
	//WORDPRESS DIRECTORY NAME
	hustle.dirWP = asama.dirWP;
	//THEME DIRECTORY NAME
	hustle.project = asama.project;
}
hustle.PU;
hustle.BU;
hustle.MAIN;
//----------------------------------------------------------------
//----------------------------------------------------------------
//STYLE SHEET
//デザイン・アニメーションCSSファイル名の指定
hustle.dsgnCss = 'asama.css';
hustle.animCss = 'asama_anim.css';
//デザイン・アニメーションCSS指定項目配列
hustle.dsgnRules;
hustle.animRules;
//----------------------------------------------------------------
//COOKIE NAME
hustle.textSizeCookie = 'textSize';
//----------------------------------------------------------------
//----------------------------------------------------------------
//ウインドウ名（ページタイトルでなくウインドウオブジェクトの参照名）
hustle.windowName = hustle.project;
//参照基準となるディレクトリ名
hustle.baseDirName = hustle.project;
//----------------------------------------------------------------
//HREFからURLとURLパラメータに切り分ける。
hustle.re = new RegExp('\\?', 'g');
hustle.uri = '';
hustle.param = '';
hustle.tmp = location.href.search(hustle.re);
if(hustle.tmp === -1) {
	hustle.uri = location.href.slice(0);
} else {
	hustle.uri = location.href.slice(0, hustle.tmp);
	hustle.param = location.href.slice(hustle.tmp+1);
}
console.log(`HREF_>${location.href}_URI_>${hustle.uri}_PARAM_>${hustle.param}`);
//----------------------------------------------------------------
// REGIST CODEBASE
if(hustle.onService) {
	console.log(`DIRURI_>${hustle.dirUri}_DIRWP_>${hustle.dirWP}_PROJECT_>${hustle.project}`);
	hustle.CB = `${hustle.dirUri}/`;
} else {
	hustle.CB = '';
	hustle.re = new RegExp(`${hustle.baseDirName}/.*$`, 'g');
	try {
		hustle.tmp = hustle.uri.match(hustle.re)[0];
	} catch(e) {
		console.log(`CATCH_ERROR_>${e.message}_>>>'baseDirName' has wrong value, may be.`);
	}
	hustle.re = new RegExp('/', 'g');
	hustle.re.exec(hustle.tmp);
	while(hustle.re.exec(hustle.tmp) !== null) hustle.CB += '../';
}
//console.log(`CODEBASE_>'${hustle.CB.length>0?hustle.CB:'No adjustment for the code-base path.'}'`);
//----------------------------------------------------------------
// URL PARAMETER INDEX
if(hustle.param !== '') {
	hustle.tmp = new Object();
	hustle.param = hustle.param.split('&');
	hustle.param = hustle.param.map((cv, id, ar) => cv.split('='));
	hustle.param.forEach((cv, id, ar) => {hustle.tmp[cv[0]] = cv[1]});
	hustle.param = hustle.tmp;
	//for(let k of Object.keys(hustle.param)) console.log(`PARAM_KEY_>${k}_VALUE_>${hustle.param[k]}`);
}
//----------------------------------------------------------------
//----------------------------------------------------------------
// REGISTRATION SOURCES
hustle.registJS = [
	`${hustle.CB}js/RegistrationClass.js`,
	`${hustle.CB}js/MainClass.js`,
	`${hustle.CB}js/tool/hustleBrowserUtilityClass.js`,
	`${hustle.CB}js/tool/hustlePageUtilityClass.js`,
	`${hustle.CB}js/tool/hustleWireFrameUtilityClass.js`
];
//----------------------------------------------------------------
// LOAD JAVASCRIPT FILES
for(let ps of hustle.registJS) {
	hustle.tmp = document.createElement('script');
	hustle.tmp.type = 'text/javascript';
	hustle.tmp.src = ps;
	document.head.insertAdjacentElement('beforeend', hustle.tmp);
}
//----------------------------------------------------------------
// CREATE PROGRESS BORDS
hustle.WHITE_BORD = document.createElement('div');
hustle.WHITE_BORD.id = 'whiteBoard';
hustle.WORKING_ANIM = document.createElement('div');
hustle.WORKING_ANIM.id = 'workingAnim';
hustle.letScroll = function() {
	document.getElementById('whiteBoard').style['top'] = window.scrollY+'px';
	document.getElementById('workingAnim').style['top'] = window.scrollY+'px';
}
hustle.onWindowScroll = function(e) {hustle.letScroll();}
hustle.fn = e => hustle.onWindowScroll(e);
document.addEventListener('DOMContentLoaded', (e)=>{
	document.body.insertAdjacentElement('afterbegin', hustle.WORKING_ANIM);
	document.body.insertAdjacentElement('afterbegin', hustle.WHITE_BORD);
	window.addEventListener('scroll',hustle.fn, false);
	hustle.letScroll();
}, false);
//----------------------------------------------------------------
// GOOGLE MAPS CONFIG
try {
	hustle.GooglMapsKEY = GoogleParams.GooglMapsKEY;
	hustle.GooglMapsID = GoogleParams.GooglMapsID;
} catch(e) {
	console.log(`CATCH_ERROR_>${e.message}_>>>'Google Maps' are not in order, may be.`);
}
// REGIST GOOGLE MAPS
function registGoogleMaps() {hustle.MAIN.letGoogleMaps();}
//----------------------------------------------------------------
// hustleの初期化メソッド
//Syntax:objectName.init();
//Parameter:なし
//Return:なし
//Reference:hustleの初期化メソッド
hustle.init = function () {
	window.removeEventListener('scroll', hustle.fn, false);
	hustle.PU = hustlePageUtilityClass;
	hustle.WFU = hustleWireFrameUtilityClass;
	hustle.BU = hustleBrowserUtilityClass;
	hustle.RG = new RegistrationClass();
	hustle.RG.init();
	window.name = hustle.windowName;
	window.focus();
};
//----------------------------------------------------------------
// ログ出力
hustle.msgNum = 0;
//Syntax:objectName.echo(...arg);
//Parameter:'arg'は可変長変引数
//Parameter:'arg'内に文字列があればログとして出力
//Parameter:'arg'内に真偽値の真があればエラーとして出力（初期値は偽）
//Parameter:他の引数は配列に格納してconsole.dir()で出力
//Return:なし
//Reference:ログを出力するメソッド
hustle.echo = function(...arg) {
	let str = '';
	let isE = false;
	let arr = new Array();
	for(let v of arg) {
		switch(typeof(v)) {
		case 'string':
			str += v;
			break;
		case 'boolean':
			isE = v;
			break;
		default:
			arr.push(v);	
		}
	}
	if(arr.length>0) {
		str += `_>>DIR`;
		for(let v of arr) str+=`_TYPE_>'${typeof(v)}'`;
	}
	if(isE) console.error(`error_${hustle.msgNum}_${str}`);
	else console.log(`echo_${hustle.msgNum}_${str}`);
	if(arr.length>0) arr.forEach((vc,id,ar)=>console.dir(vc));
	hustle.msgNum++;
};
//----------------------------------------------------------------
// hustleの初期化実装メソッド
//Syntax:objectName.addLoadEvent(init);
//Parameter:"init"は初期化メソッド
//Return:なし
//Reference:ページのonloadイベントを損なうことなく、hustleオブジェクトの初期化メソッドを実装するためのメソッド
hustle.addLoadEvent = function(init) {
	if(typeof(window.onload) !== 'function') window.onload = init;
	else {
		const fn = window.onload;
		window.onload = function() {
			fn;
			hustle.init();
		};
	}
};
//----------------------------------------------------------------
// EVENT INCREMENT
//onloadイベントにhustleオブジェクトの初期化メソッドを実装する。
//なお、onloadの指定がない場合（あさま）のため、bodyより先に処理される以下の記述は生かしておく。
if(document.getElementById)hustle.addLoadEvent(hustle.init);
