<?php
/**
* @package asamito
*/
//--------------------------------------------------------------------------------
// studio hustlemouse
// PHP Code 'functions.php'
// Create : 2021.11.30
// Modify : 2024.5.22
// Author : maruhiro
// (c)maruhiro all rights reserved.
//--------------------------------------------------------------------------------
// ASAMITO CONFIGURATION
//--------------------------------------------------------------------------------
//子テーマは先に読み込まれるので親テーマに関する設定を記述して、親テーマが読み込まれた際に本関数が呼び出される。
function hustle_config(object $obj) {
	/*******************************
	フロントページ名前を指定、メインメニューとパンくずリストで利用する。
	*******************************/
	$FN = 'Home';
	/*******************************
	あさまテーマに必要なパラメータ群を連想配列にて登録する（変更不可変数名=>値）
	*******************************/
	$obj->setAsamaParams(array(
		/*******************************
		あさまテーマを運用して投稿を開始した日の値（'Y-m-d H:i:s'）にて登録する。
		各投稿ディビジョンのrole属性値が、開始日以前であれば'column-former'以後であれば'column-asama'となる。
		*******************************/
		'START_DATE'=>'2022-10-24 19:28:00',
		/*******************************
		サイトで利用するWebフォントを配列にて登録する。（任意変数名=>URLとパラメータ）
		*******************************/
		'CHILD_FONTS'=>array(
			'https://fonts.googleapis.com/icon?family=Material+Icons',
			'https://fonts.googleapis.com/css2?family=Source+Code+Pro:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap',
			'https://fonts.googleapis.com/css2?family=Noto+Sans:ital,wght@0,400;0,700;1,400;1,700&display=swap',
			'https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100;300;400;500;700;900&display=swap',
			'https://fonts.googleapis.com/css2?family=Quicksand:wght@300;400;500;600;700&display=swap',
			'https://fonts.googleapis.com/css2?family=Kiwi+Maru:wght@300;400;500&display=swap',
		),
		/*******************************
		サイトで利用するCSSファイルを配列にて登録する。（任意変数名=>テーマルートパス）
		注意）確実な動作のため、フォント→アニメーション→デザインの順番で読み込まれるように列記する。
		*******************************/
		'CHILDE_STYLE'=>array(
			//確実な動作のため、フォント→アニメーション→デザインの順番で読み込まれるように列記する。
			'/css/font.css',
			'/css/asamito_anim.css',
			'/css/asamito.css',
		),
		/*******************************
		著作権情報を登録する。内容はパラグラフタグ内に出力される。
		メインオブジェクト（HustleClass）に変数（COPYRIGHT）が生成され、ソースが格納される。
		変数（COPYRIGHT）が生成されていれば、include/parts/page-special.phpにて以下のエレメントが出力される。
		格納されたソースは<?php echo $HSTL->COPYRIGHT; ?>によって実装される。
		<article class='content' name='copyright' role='copyright'>
			<p><?php echo $HSTL->COPYRIGHT; ?></p>
		</article>
		表示をしない場合はコードをコメント化するか、「'COPYRIGHT'=>''」と空を渡します。
		*******************************/
		'COPYRIGHT'=>'COPY RIGHT',
		/*******************************
		緊急情報など一時的な情報を掲載するページの特別エレメントに掲示する情報を登録する。
		メインオブジェクト（HustleClass）に変数（PAGE_SPECIAL）が生成され、ソースが格納される。
		変数（PAGE_SPECIAL）が生成されていれば、include/parts/page-special.phpにて以下のエレメントが出力される。
		格納されたソースは<?php echo $HSTL->PAGE_SPECIAL; ?>によって実装される。
		<aside class='special' name='PageSpecial' role='<?php echo "special".$MD; ?>'>
			<article class='content' role='PageSpecial'>
				<?php echo $HSTL->PAGE_SPECIAL; ?>
			</article>
		</aside>
		表示をしない場合はコードをコメント化するか、「'PAGE_SPECIAL'=>''」と空を渡します。
		*******************************/
		'PAGE_SPECIAL'=>'<p class="message"><span class="attention">THE PAGE SPECIAL!</span></p>',
		/*******************************
		フロントページの名前（文字列）
		定数FRONTPAGE_NAMEが定義されていなければ、パラメータが渡らずに初期値が利用される。
		*******************************/
		'FRONTPAGE_NAME'=>isset($FN)?$FN:'',
		/*******************************
		ショートコードをパラメータとして、あさまテーマの独自パンくずリストの利用を登録する。
		シートコード内のパラメータについてはファイル「include/shortcode/BreadCrumb.php」内に説明がある。
		定数FRONTPAGE_NAMEが定義されていなければ、ショートコードのhome=""パラメータが渡らずに初期値が利用される。
		コメントアウトもしくはパラメータを「'HUSTLE_CRUMB'=>''」と空にすると'Yoast SEO'プラグインのパンくずリストが利用できる。'Yoast SEO'が有効化されていなければヘッダーメニュー領域として運用できる。
		ショートコードを差し替えることもできる。
		*******************************/
		'HUSTLE_CRUMB'=>'[hustleShort file="include/shortcode/BreadCrumb" name="husteCrumb" mode="category"'.(isset($FN)?(strlen($FN)>0?' home="'.$FN.'"':''):'').']',
		/*******************************
		ショートコードをパラメータとして、あさまテーマの独自タグクラウドの利用を登録する。
		シートコード内のパラメータについてはファイル「include/shortcode/TagCloud.php」内に説明がある。
		ショートコードを差し替えることもできる。
		表示をしない場合はコードをコメント化するか、「'HUSTLE_TAGCLOUD'=>''」と空を渡します。
		*******************************/
		'HUSTLE_TAGCLOUD'=>'[hustleShort file="include/shortcode/TagCloud" smallest="1.0" largest="3.0" unit="rem" number="55" pst="0"]',
		/*******************************
		Googleマップ利用に必要となる'KEY'と'ID'の連想配列にて登録する（変更不可変数名=>値）
		*******************************/
		'GOOGLE_MAPS'=>array(
			'KEY' => 'XXXXXXXXXXXXXXXX_XXXXXXXX-XXXX',
			'ID' => 'XXXXXXXXXXXXXXXX',
		),
		/*******************************
		一覧の抜粋文字数（必ず整数）
		*******************************/
		'EXCERPT_NUMBER'=>55,
		/*******************************
		RSSにアイキャッチ画像（サムネール）を加えて出力するかしないかの真偽を登録する。
		*******************************/
		'ADD_THUMBNAIL_FOR_RSS'=>false,
	));
	/*******************************
	あさまテーマでは独自にカスタム投稿タイプの運用に対応してます。
	１）投稿ページをホームページにした設定では、基本投稿とカスタム投稿が混在して表示される仕様になってます。
	２）投稿者一覧ページでも前項と同じ仕様になっています。
	３）以上の仕様は'Post Types Order'プラグインを有効化した際には機能しません。
	---------- カスタム投稿タイプの追加（基本） ----------
	//（注意）連想配列のキーワードを変更しない。'postHead'と'postType'、'postOptions'のキーワードが異なると登録されません。
	//（注意）エラーやトラブルを回避するためにWordpressの予約語を登録しない。
	array(
		//（あさま特別）'postHead'はカスタム投稿タイプ記事一覧のタイトルのアイコンキーワード。初期値は'Feature'。
		'postHead'=>'アイコンキーワード',
		//カスタム投稿タイプ名（半角英数字の小文字）//カスタム投稿記事のURL(https://ドメイン名/news/)
		'postType'=>'custom_post',
		//オプション（以下）
		'postOptions'=>array(
			'label' => 'カスタムポスト', //管理画面上の表示（日本語でもOK）
			'public' => true, //管理画面に表示するかどうかの指定（初期値:false）
			'has_archive' => true, //投稿した記事の一覧ページを作成する（初期値:falseだが、パーマリンク設定がデフォルトだと表示される）
			'show_in_rest' => true, //Gutenbergの有効化（初期値:false、trueでもエディタの有効化'supports'=>array('editor')が必要）
			'menu_position' => 5, //管理画面メニューの表示位置（投稿の下に追加:5）
			//サポートする機能（以下）
			'supports' => array(
				'title', //タイトルを使う設定
				'editor', //エディターを使う設定
				'thumbnail', //アイキャッチ画像を使う設定（add_theme_support('post-thumbnails')が処理されている必要あり）
				'revisions', //リビジョンの保存の設定、投稿に加えられた変更を自動的に保存してバックアップの役割を果たす。
				'author', //作成者の設定
				'excerpt', //抜粋の設定
				'custom-fields', //カスタムフィールドの設定
				'comments', //コメントの他、編集画面にコメント数のバルーンを表示する設定
				'page-attributes', //メニュー順序の設定。「親~」オプションを表示するためにhierarchicalがtrueであることが必要です。
				'post-formats', //投稿のフォーマットを追加の設定
			),
		)
	)
	---------- カスタムタクソノミー（カテゴリー or タグ）の追加（基本） ----------
	//（注意）連想配列のキーワードを変更しない。'txnmName'と'postType'、'txnmOptions'のキーワードが異なると登録されません。
	//（注意）エラーやトラブルを回避するためにWordpressの予約語を登録しない。
	array(
		//カテゴリーもしくはタグの名前（半角英数字小文字）
		'txnmName'=>'custom_cat'（or 'custom_tag'）,
		//タグを追加したいカスタム投稿タイプ
		'postType'=>'custom_post',
		'txnmOptions'=>array(
			'label' => 'カテゴリーかタグ', //管理画面表示名
			'hierarchical' => true, //階層を持たせるかどうかの指定（初期値:false）trueでカテゴリーのようにfalseでタグのように振る舞う。
			'public' => true, //このタクソノミーを管理画面に表示するかどうかの指定（初期値:false）
			'show_in_rest' => true, //Gutenberg（ブロックエディタ）の有効化（タクソノミーでも改めて指定する）
			'update_count_callback' => '_update_post_term_count', //タグのように使う場合は必ず記述する。カテゴリーでは必要ない。
		)
	),
	*******************************/
	//カスタム投稿タイプ（複数登録可）の利用を真偽値にて登録する。
	$obj->setCreatePostType(false);
	$obj->rgstCustomPostType(array(
	//次の連想配列の件数だけカスタム投稿タイプを登録できる。
	array(),
	));
	$obj->rgstCustomTaxonomy(array(
	//次の連想配列の件数だけカスタムタクソノミーを登録できる。
	array(),
	));
}