/****************************************************************
studio hustlemouse
JavaScript Code 'MainClass'
Author MARUHIRO
Create:2020.8.17
Modify:2024.7.17
(c)maruhiro all rights reserved.
****************************************************************/
//----------------------------------------------------------------
// OUTLINE
//----------------------------------------------------------------
// [FIELDS]
// *RG
// [METHODS]
// *constructor()
// *init()
// *setContent()
// *reset()
//----------------------------------------------------------------
class MainClass {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//Syntax:this.objectName = new MainClass();
	//Parameter:obj'はRegistrationClassオブジェクト
	//Return:なし
	constructor(obj) {
		this.value = 'MAIN CLASS';
		this.RG = obj;
		this.BODY;
		//本コンテンツ特有の描画処理を呼び出す間隔（1ms = 1/1000秒）
		this.DILAY = 40;//整数'40'であれば'40/1000秒'で25fps（フレームパーセコンド）になる。
		//"scrollA"は速度指定で、0から1までの数値を指定する。
		//"scrollA"を1にすると通常のジャンプと同じになる。
		this.scrollA = 0.25;//0.5*0.5
		//----------------------------------------------------------------
		this.opnMenu;
		this.umenu;
		this.lmenu;
		this.uMnuTgglBtn;
		this.uMnuTgglName
		this.menuTgglClass = ['webIcon-Close','webIcon-Menu'];
		this.fnTgglMnMnu = e => this.tgglMainMenu(e);
		this.fnEndTgglAnm = e => this.endToggleAnim(e);
		this.onOpnSmmAnim;
		this.onClsSmmAnim;
		this.fnOpnSubMM = e => this.openSubMM(e);
		this.fnClsSubMM = e => this.closeSubMM(e);
		this.fnEndOpnSmmAnm = e => this.endOpenSubMM(e);
		this.fnEndClsSmmAnm = e => this.endCloseSubMM(e);
		this.fnChkClsSubMnu = e => this.checkFoldSubMM(e);
		this.mps = {}
		this.opnSubMnus;
		this.wpHasChildren = 'menu-item-has-children';
		this.wpSubMenu = 'sub-menu';
		//----------------------------------------------------------------
		this.curX;
		this.curY;
		this.trgX;
		this.trgY;
		this.scrlInterval;
		this.fnScrlTop = e => this.letScrolltoPagetop(e);
		//----------------------------------------------------------------
		this.FGRs;
		this.TRGs;
		//----------------------------------------------------------------
		//GOOGLE MAPS CONFIG
		this.gMapIndexs;
		this.srcGoogleMaps;
	}
	init() {
		hustle.PU.VIZ({b:false, obj:hustle.PU.ID({id:'whiteBoard'})});
		this.BODY = hustle.PU.TAG({tag:'body'})[0];
		let obj = hustle.PU.QSELECT({slc:`section[name='MainMenuFlop']`});
		//for(let p in this.mps) {hustle.PU.setSTYLEprp({prp:`--${p}`, vlu:this.mps[p], obj});}
		this.initMenuToggle();
		this.initSubMenuOPNnCLS();
		this.initScrollToPageTop();
		this.initDoupImg();
		this.setContent();
		this.initGoogleMaps();
		this.reset();
		hustle.PU.VIZ({b:false, obj:hustle.PU.ID({id:'workingAnim'})});
	}
	setContent() {
		if(hustle.RG.IOS) {
			window.addEventListener('orientationchange', e => this.onWindowResize(e), false);
		} else {
			window.addEventListener('resize', e => this.onWindowResize(e), false);
			window.addEventListener('scroll', e => this.onWindowScroll(e), false);
		}
	}
	reset() {
		this.tgglMainMenu(this);
		this.letResize();
		this.letScroll();
	}
	//----------------------------------------------------------------
	// EVENT RECEIVER
	onWindowScroll(e) {this.letScroll();}
	onWindowResize(e) {this.letResize();}
	//----------------------------------------------------------------
	// RESIZE
	letResize() {this.letDoupImg();}
	//----------------------------------------------------------------
	// SCHLOOL
	letScroll() {
		hustle.PU.VIZ({b:(window.scrollY > 0), obj:hustle.PU.ID({id:'ArrowPageTop'})});
		if(this.opnMenu) this.tgglMainMenu(this);
		this.letDoupImg();
	}
//----------------------------------------------------------------
// MENU TOGGLE
	initMenuToggle() {
		this.opnMenu = true;
		this.umenu = hustle.PU.ID({id:'upperMenuBlock'});
		this.lmenu = hustle.PU.ID({id:'lowerMenuBlock'});
		this.uMnuTgglBtn = hustle.PU.ID({id:'mainMenuTgglBtn'});
		if(hustle.RG.VISA.TOUCHPAD) {
			this.uMnuTgglBtn.addEventListener(this.RG.PEV.end, this.fnTgglMnMnu, false);
		} else {
			this.uMnuTgglBtn.addEventListener(this.RG.PEV.start, this.fnTgglMnMnu, false);
		}
		hustle.PU.delClass({obj:this.umenu});
		if(this.lmenu) hustle.PU.delClass({obj:this.lmenu});
	}
	tgglMainMenu(e) {
		if(this.opnMenu) {
			this.closeAllSubMM();
			hustle.PU.setClass({vlu:'shrnkDwGpuAnm', obj:this.umenu});
			if(this.lmenu) hustle.PU.setClass({vlu:'shrnkGpuAnm', obj:this.lmenu});
		} else {
			hustle.PU.setClass({vlu:'xpndUpGpuAnm', obj:this.umenu});
			hustle.PU.VIZ({b:true, obj:this.umenu});
			if(this.lmenu) {
				hustle.PU.setClass({vlu:'xpndGpuAnm', obj:this.lmenu});
				hustle.PU.VIZ({b:true, obj:this.lmenu});
			}
		}
		hustle.PU.setAnimEndLstnr({fn:this.fnEndTgglAnm, obj:this.umenu});
		this.opnMenu = !this.opnMenu;
	}
	endToggleAnim(e) {
		hustle.PU.delClass({obj:this.umenu});
		if(this.lmenu) hustle.PU.delClass({obj:this.lmenu});
		if(!this.opnMenu) {
			hustle.PU.VIZ({b:false, obj:this.umenu});
			if(this.lmenu) hustle.PU.VIZ({b:false, obj:this.lmenu});
			hustle.PU.setClass({vlu:`${this.menuTgglClass[1]}`, obj:this.uMnuTgglBtn});
		} else {
			hustle.PU.setClass({vlu:`${this.menuTgglClass[0]}`, obj:this.uMnuTgglBtn});
		}
		hustle.PU.delAnimEndLstnr({fn:this.fnEndTgglAnm, obj:this.umenu});
	}
//----------------------------------------------------------------
// SUBMENU OPEN and CLOSE
	initSubMenuOPNnCLS(cls=this.wpHasChildren) {
		if(!this.lmenu) return;
		if(hustle.RG.VISA.TOUCHPAD) {
			hustle.PU.CLASS({cls:'menus', obj:this.lmenu})[0].addEventListener(this.RG.PEV.start, this.fnChkClsSubMnu, false);
		}
		let hasList = hustle.PU.CLASS({cls, obj:this.lmenu});
		for(let lie of hasList) {
			let dv = document.createElement('div');
			hustle.PU.setATBT({vlu:'hasSubMenu', atr:'class', obj:dv});
			lie.prepend(dv);
			let sp = document.createElement('span');
			hustle.PU.setATBT({vlu:'webIcon-ExpandMore', atr:'class', obj:sp});
			let ankr = hustle.PU.TAG({tag:'a', obj:lie})[0];
			dv.append(ankr);//アンカータグをDIVの中に移動
			dv.appendChild(sp);//その後ろにアイコンエレメントを追加
			if(hustle.RG.VISA.TOUCHPAD) {
				sp.addEventListener(this.RG.PEV.end, this.fnOpnSubMM, false);
			} else {
				sp.addEventListener(this.RG.PEV.enter, this.fnOpnSubMM, false);
				lie.addEventListener(this.RG.PEV.leave, this.fnClsSubMM, false);
			}
			let ule = hustle.PU.TAG({tag:'ul', obj:lie})[0];
			if(ule!==undefined) {
				this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), ule);
				hustle.PU.VIZ({b:false, obj:ule});
			}
		}
		this.onOpnSmmAnim = false;
		this.onClsSmmAnim = false;
		if(hustle.RG.VISA.TOUCHPAD) this.pickUnfoldSubMM();
	}
	pickUnfoldSubMM(cls=this.wpSubMenu) {
		let subMenus = hustle.PU.CLASS({cls, obj:this.lmenu});
		this.opnSubMnus = new Array();
		for(let ule of subMenus) {
			if(hustle.PU.VIZ({obj:ule})) this.opnSubMnus.unshift(ule);
		}
	}
	checkFoldSubMM(e) {
		//ベンチマークエレメント
		let BMEL = e.target;
		switch(e.target.tagName) {
			case 'A':
				if(hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode})) {
					if(BMEL.parentNode.tagName==='DIV' && hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf('hasSubMenu')!==-1) {
						BMEL = BMEL.parentNode.parentNode.parentNode;
					} else if(BMEL.parentNode.tagName==='LI' && hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf('menu-item')!==-1) {
						BMEL = BMEL.parentNode.parentNode;
					}
				}
				if(hustle.PU.ATBT({atr:'class', obj:BMEL})) {
					if(BMEL.tagName==='UL' && hustle.PU.ATBT({atr:'class', obj:BMEL}).indexOf('menus')!==-1) this.closeAllSubMM();
				}
				break;
			case 'LI':
				if(BMEL.id) {
					for(let ule of this.opnSubMnus) {
						if(ule.parentNode.id!==BMEL.id) {
							if(hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf(this.wpSubMenu)!==-1) {
								if(ule.parentNode.parentNode.parentNode.id===BMEL.parentNode.parentNode.id) {
									this.closeUnderSubMM(ule);
									this.closeOneSubMM(ule);
								}
							} else this.closeAllSubMM();
						}
					}
				} else this.closeAllSubMM();
				break;
			case 'UL':
				if(hustle.PU.ATBT({atr:'class', obj:BMEL})) {
					if(hustle.PU.ATBT({atr:'class', obj:BMEL}).indexOf('menus')!==-1) this.closeAllSubMM();
				}
				break;
			case 'DIV':
				if(hustle.PU.ATBT({atr:'class', obj:BMEL})) {
					if(hustle.PU.ATBT({atr:'class', obj:BMEL}).indexOf('hasSubMenu')!==-1) {
						for(let ule of this.opnSubMnus) {
							if(ule.parentNode.id===BMEL.parentNode.id) {
								this.closeUnderSubMM(ule);
								this.closeOneSubMM(ule);
							}
						}
					};
				}
				break;
			case 'SPAN':
				if(hustle.PU.ATBT({atr:'class', obj:BMEL})) {
					if(hustle.PU.ATBT({atr:'class', obj:BMEL}).indexOf('webIcon')!==-1) {
						BMEL.style['background-color']='var(--StkyOverClr)';
					 	if(this.checkUnfoldUnderSubMM(hustle.PU.TAG({tag:'ul', obj:BMEL.parentNode.parentNode})[0])) {
							this.closeUnderChildSubMM(hustle.PU.TAG({tag:'ul', obj:BMEL.parentNode.parentNode})[0]);
						} else if(hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode})) {
							if(BMEL.parentNode.tagName==='DIV' && hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf('hasSubMenu')!==-1) {
								BMEL = BMEL.parentNode.parentNode;
							}
							if(hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode})) {
								if(BMEL.parentNode.tagName==='UL' && hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf('menus')!==-1) {
									if(!this.checkUnfoldUnderSubMM(BMEL) && this.opnSubMnus.length>0) this.closeAllSubMM();
								}
							}
						}
						break;
					}
				}
			default:
		}
	}
	checkUnfoldUnderSubMM(obj, cls=this.wpSubMenu) {
		let subMenus = hustle.PU.CLASS({cls, obj});
		for(let ule of subMenus) {
			if(hustle.PU.VIZ({obj:ule})) return true;
		}
		return false;
	}
	closeUnderSubMM(obj, cls=this.wpHasChildren) {
		let hasList = hustle.PU.CLASS({cls, obj});
		if(Array.isArray(hasList)) hasList.reverse();
		for(let lie of hasList){
			ule = hustle.PU.TAG({tag:'ul', obj:lie})[0];
			if(hustle.PU.VIZ({obj:ule})) this.closeOneSubMM(ule);
		}
	}
	closeUnderChildSubMM(obj, cls=this.wpSubMenu) {
		let subMenus = hustle.PU.CLASS({cls, obj});
		if(Array.isArray(subMenus)) hasList.reverse();
		for(let ule of subMenus){
			if(hustle.PU.VIZ({obj:ule})) this.closeOneSubMM(ule);
		}
	}
	closeAllSubMM(cls=this.wpSubMenu) {
		if(!this.lmenu) return;
		let subMenus = hustle.PU.CLASS({cls, obj:this.lmenu});
		for(let ule of subMenus) {
			if(hustle.PU.VIZ({obj:ule})) this.closeOneSubMM(ule);
		}
	}
	openSubMM(e) {
		let ule = hustle.PU.TAG({tag:'ul', obj:e.target.parentNode.parentNode})[0];
		if(ule!==undefined) {
			if(!hustle.PU.VIZ({obj:ule})) {
				if(this.onClsSmmAnim) {
					hustle.PU.delAnimEndLstnr({fn:this.fnEndClsSmmAnm, obj:ule});
					this.onClsSmmAnim = false;
				}
				hustle.PU.VIZ({b:true, obj:ule});
				hustle.PU.replaceAnimKey({prp:`height:${ule.clientHeight}px`, key:'100%', anim:'xpndCpuAnm', srs:hustle.animRules, visa:hustle.RG.VISA});
				this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), ule);
				let cls = hustle.PU.getClass({obj:ule});
				hustle.PU.setClass({vlu:`${cls} xpndCpuAnm`, obj:ule});
				hustle.PU.setAnimEndLstnr({fn:this.fnEndOpnSmmAnm, obj:ule});
				this.onOpnSmmAnim = true;
			} else if(hustle.RG.VISA.TOUCHPAD) {
				e.target.style['background-color']='var(--StkyAnkrClr)';
			}
		}
	}
	endOpenSubMM(e) {
		let ule = (e.target.tagName==='A')? e.target.parentNode.parentNode : e.target;
		this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), ule);
		hustle.PU.delAnimEndLstnr({fn:this.fnEndOpnSmmAnm, obj:ule});
		this.onOpnSmmAnim = false;
		if(hustle.RG.VISA.TOUCHPAD) {
			this.pickUnfoldSubMM();
			e.target.parentNode.firstChild.lastChild.style['background-color']='var(--StkyAnkrClr)';
		}
	}
	closeSubMM(e) {
		let ule = hustle.PU.TAG({tag:'ul', obj:e.target})[0];
		if(this.onOpnSmmAnim) {
			hustle.PU.VIZ({b:true, obj:ule});
			hustle.PU.delAnimEndLstnr({fn:this.fnEndOpnSmmAnm, obj:ule});
			this.onOpnSmmAnim = false;
		}
		this.closeOneSubMM(ule);
	}
	closeOneSubMM(ule) {
		if(ule!==undefined) {
			hustle.PU.replaceAnimKey({prp:`height:${ule.clientHeight}px`, key:'0%', anim:'shrnkCpuAnm', srs:hustle.animRules, visa:hustle.RG.VISA});
			this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), ule);
			let cls = hustle.PU.getClass({obj:ule});
			hustle.PU.setClass({vlu:`${cls} shrnkCpuAnm`, obj:ule});
			hustle.PU.setAnimEndLstnr({fn:this.fnEndClsSmmAnm, obj:ule});
			this.onClsSmmAnim = true;
		}
	}
	endCloseSubMM(e) {
		let ule = (e.target.tagName==='A')? e.target.parentNode.parentNode : e.target;
		hustle.PU.VIZ({b:false, obj:ule});
		this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), ule);
		hustle.PU.delAnimEndLstnr({fn:this.fnEndClsSmmAnm, obj:ule});
		this.onClsSmmAnim = false;
		if(hustle.RG.VISA.TOUCHPAD) this.pickUnfoldSubMM();
	}
	//'re'の正規表現に該当するクラス指定を削除する。
	restoreClass(re, obj) {
		let str = hustle.PU.getClass({obj});
		str = hustle.PU.CV({str:hustle.PU.RegReplace({s:'', re, str})});
		hustle.PU.setClass({vlu:`${str}`, obj});
	}
//----------------------------------------------------------------
// SCROLL TO PAGETOP
	initScrollToPageTop() {
		let a = hustle.PU.ID({id:'ArrowPageTop'});
		a.addEventListener(this.RG.PEV.start, this.fnScrlTop, false);
	}
	letScrolltoPagetop(e) {
		this.stopScrolltoPagetop();
		this.curX = window.scrollX;
		this.curY = window.scrollY;
		this.trgX = 0;
		this.trgY = 0;
		this.scrlInterval = setInterval(()=>this.doScrolltoPagetop(1/this.scrollA), this.DILAY);
	}
	doScrolltoPagetop(spd) {
		if(this.trgX - this.curX > 1 || this.trgX - this.curX < -1) this.curX += (this.trgX - this.curX)/spd;
		else this.curX = this.trgX;
		if(this.trgY - this.curY > 1 || this.trgY - this.curY < -1) this.curY += (this.trgY - this.curY)/spd;
		else this.curY = this.trgY;
		if(this.curX === this.trgX && this.curY === this.trgY) this.stopScrolltoPagetop();
		scrollTo(this.curX, this.curY);
	}
	stopScrolltoPagetop() {clearInterval(this.scrlInterval);}
//----------------------------------------------------------------
// DO-UP IMAGES METHODS
	initDoupImg () {
		this.FGRs = hustle.PU.CLASS({cls:'wp-block-image'});
		this.TRGs = new Array();
		for(let obj of this.FGRs) {
			let dup = hustle.PU.CLASS({cls:'dup', obj})[0];
			if(dup instanceof Element) this.TRGs.push({dup, img:hustle.PU.TAG({tag:'img', obj})[0]});
		}
	}
	letDoupImg() {
		if(!this.TRGs.length) return;
		let inWH = hustle.BU.getInnerSize({obj:window});
		for(let obj of this.TRGs) {
			obj['img'].style['width'] = '100%';
			obj['img'].style['height'] = 'auto';
			let DR = hustle.PU.RECT({obj:obj['dup']});
			let IR = hustle.PU.RECT({obj:obj['img']});
			if(DR.h >= IR.h) {
				obj['img'].style['width'] = 'auto';
				obj['img'].style['height'] = `${DR.h}px`;
				IR = hustle.PU.RECT({obj:obj['img']});
				let l = (DR.w - IR.w) * DR.y / (inWH[1] - DR.h);
				if(l <= 0 && l >= DR.w - IR.w) {
					obj['img'].style['top'] = '0px';
					obj['img'].style['left'] = `${l}px`;
				}
			} else {
				obj['img'].style['top'] = `${(DR.h - IR.h) * DR.y / (inWH[1] - DR.h)}px`;
				obj['img'].style['left'] = '0px';
			}
		}
	}
//----------------------------------------------------------------
// GOOGLE MAPS
	initGoogleMaps() {
		let as = hustle.PU.NAME({nm:'GoogleMaps'});
		this.gMapIndexs = new Array();
		if(as.length > 0) {
			as.forEach((vl, id, ar)=>{
				if(vl instanceof Element) this.gMapIndexs.push(hustle.PU.getID({obj:vl}));
			});
		}
		//LOAD GOOGLE MAPS API
		if(this.gMapIndexs.length > 0 && hustle.GooglMapsKEY.length > 24) {//Google Maps KeyがなければAPIを読み込まない。
			let src = `https://maps.googleapis.com/maps/api/js?key=${hustle.GooglMapsKEY}&callback=registGoogleMaps&libraries=&v=weekly`;
			let js = document.createElement('script');
			hustle.PU.setATBT({vlu:'text/javascript', atr:'type', obj:js});
			hustle.PU.setATBT({vlu:src, atr:'src', obj:js});
			hustle.PU.setATBT({vlu:'', atr:'async', obj:js});
			this.BODY.appendChild(js);
		}
	}
	letGoogleMaps() {
		this.gMapIndexs.forEach((vl, id, ar)=>this.doGoogleMaps(vl));
	}
	doGoogleMaps(id) {
		hustle.echo(`GOOGLE_MAPS_ID_>${id}`, false);
		let obj = hustle.PU.ID({id});
		let lat = Number.parseFloat(hustle.PU.ATBT({atr:'data-lat', obj}));
		let lng = Number.parseFloat(hustle.PU.ATBT({atr:'data-lng', obj}));
		let zoom = Number.parseInt(hustle.PU.ATBT({atr:'data-zoom', obj}));
		let mapId = hustle.GooglMapsID;
		const uluru = {lat, lng};
		const map = new google.maps.Map(obj, {zoom:zoom, center:uluru, mapId:mapId,});
		const marker = new google.maps.Marker({position:uluru, map:map,});
	}
}