/***************************************************************
studio hustlemouse
JavaScript Code 'RegistrationClass'
Author MARUHIRO
Create:2015.11.1
Modify:2022.5.18
(c)maruhiro all rights reserved.
***************************************************************/
//----------------------------------------------------------------
// OUTLINE
// 基本的にinit()関数以外は不可侵となるように設計する。（2019.8.7 maruhiro）
// [FIELDS]
// *VISA.WIN
// *VISA.MAC
// *VISA.OSX
// *VISA.IPAD
// *VISA.IPOD
// *VISA.IPHONE
// *VISA.IOS
// *VISA.ANDROID
// *VISA.SAF
// *VISA.IE
// *VISA.CHR
// *VISA.FFX
// *VISA.OPR
// *VISA.EDG
// *POINTER
// *MSPOINTER
// *TOUCHPAD
// *PEV.PEVENT
// *PEV.TEVENT
// *PEV.MEVENT
// *PEV.start
// *PEV.move
// *PEV.end
// *PEV.enter
// *PEV.leave
// *PEV.out
// *PEV.over
// *PEV.cancel
// *PEV.hover
// *GESTURE
// *DEVICEMOTION
// *LANG
// [METHODS]
// *constructor()
// *init()
//----------------------------------------------------------------
class RegistrationClass {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//Syntax:this.objectName = new RegistrationClass();
	//Parameter:なし
	//Return:なし
	//Reference:コンストラクタメソッド
	constructor() {
		//hustle.echo(`RegistrationClass_>`, false);
		//----------------------------------------------------------------
		// REGIST PLATFORM
		// プラットホーム査証一式オブジェクト
		let NUA = navigator.userAgent;
		hustle.echo(`NAVIGATOR_AGENT_>${navigator.userAgent}_MAXTOUCHPOINTS_>${navigator.maxTouchPoints}`, false);
		let isSaf = NUA.lastIndexOf('Safari')!==-1;
		let isEdg = NUA.lastIndexOf('Edg')!==-1;
		let isChr = NUA.lastIndexOf('Chrome')!==-1;
		let isFfx = NUA.lastIndexOf('Firefox')!==-1;
		let isOpr = NUA.lastIndexOf('OPR')!==-1;
		let isCri = NUA.lastIndexOf('CriOS')!==-1;
		this.VISA = {
			// プラットホーム
			WIN : NUA.lastIndexOf('Windows')!==-1,
			MAC : (NUA.lastIndexOf('Macintosh')!==-1 && navigator.maxTouchPoints<=1),
			IPAD : (NUA.lastIndexOf('iPad')!==-1 || (NUA.lastIndexOf('Macintosh')!==-1 && navigator.maxTouchPoints>1)),
			IPOD : NUA.lastIndexOf('iPod')!==-1,
			IPHONE : NUA.lastIndexOf('iPhone')!==-1,
			ANDROID : NUA.lastIndexOf('Android')!==-1,
			OSX : (NUA.lastIndexOf('OS X')!==-1 && NUA.lastIndexOf('iPhone')===-1 && NUA.lastIndexOf('iPad')===-1 && navigator.maxTouchPoints<=1),
			IOS : null,
			// ウェブブラウザの検出
			SAF : (isSaf && !isChr && !isCri && NUA.lastIndexOf('EdgiOS')===-1),
			EDG : (isEdg && isSaf && isChr) || NUA.lastIndexOf('EdgiOS')!==-1,
			CHR : (isChr && !isCri && !isEdg && !isOpr) || (!isChr && isCri && !isEdg),
			FFX : isFfx || NUA.lastIndexOf('FxiOS')!==-1,
			OPR : (isOpr || NUA.lastIndexOf('OPT')!==-1) || (NUA.lastIndexOf('Mobile')!==-1 && !isCri && !isEdg && !isSaf && !isFfx),
			// タッチパネル環境の検出
			POINTER : window.navigator.pointerEnabled,
			MSPOINTER : window.navigator.msPointerEnabled,
			TOUCHPAD : ('ontouchstart' in window)
		}
		//hustle.echo(`IS THIS?_>${this.VISA.IOS}`, false);
		this.VISA.IOS = (this.VISA.IPAD || this.VISA.IPOD || this.VISA.IPHONE);
		let visa = 'REGISTED_PLATFORM';
		for(let k in this.VISA) {if(this.VISA[k]) visa += `_>${k}`;}
		hustle.echo(visa, false);
		//----------------------------------------------------------------
		// REGIST EVENT KEY FOR PLATFORM
		//イベントを確認するためのキーワードを作っておく
		//"pointer"のPは大文字小文字が混在するので"ointer"とする
		//this.PEVENT = 'ointer';//ES6の記述を解釈しないIE用なので必要がなくなる。
		this.TEVENT = 'touch';
		this.MEVENT = 'mouse';
		// ポインティングデバイスイベント名一式
		this.PEV = {
			//ポインティングデバイスイベント名の初期設定
			//新しいIEを除くパソコン上のウェブブラウザー用
			start : 'mousedown',
			move : 'mousemove',
			end : 'mouseup',
			enter : 'mouseenter',
			leave : 'mouseleave',
			out : 'mouseout',
			over : 'mouseover',
			cancel : '',
			hover : ''//タップの長押し
		}
		if(this.VISA.TOUCHPAD) {
			//Touch Panel display
			this.PEV.start = 'touchstart';
			this.PEV.move = 'touchmove';
			this.PEV.end = 'touchend';
			this.PEV.enter = 'touchenter';
			this.PEV.leave = 'touchleave';
			this.PEV.out = '';
			this.PEV.over = '';
			this.PEV.cancel = 'touchcancel';
			this.PEV.hover = '';
		}
		// ジェスチャーイベントの真偽
		this.GESTURE = false;
		// 加速度センサー環境の真偽
		this.DEVICEMOTION = false;
		if(this.VISA.IPAD || this.VISA.IPOD || this.VISA.IPHONE) {
			this.GESTURE = true;
			this.DEVICEMOTION = true;
		}
		// 環境言語の取得
		this.LANG = navigator.language;
		//hustle.echo(`NAVIGATOR\'S_LANGUAGE_>${this.LANG}`, false);
	}
	//----------------------------------------------------------------
	// INITIALISE
	//----------------------------------------------------------------
	//Syntax:objectName.init();
	//Parameter:なし
	//Return:なし
	//Reference:初期化する。
	init() {
		//hustle.echo(`Registration_INIT_>`, false);
		//----------------------------------------------------------------
		// STYLESSHEETS INITIALIZE
		//【再確認を必要とする。 20210611 maruhiro】styleSheetsでは最後のidに実際のCSSファイルにないnullのオブジェクトが付帯している。
		//FireFoxではそのnullオブジェクトにしかCSSの追加指定を差し込めないので、該当オブジェクトを明示的に取得しておく。
		//hustle.nullStyleSheet = document.styleSheets[document.styleSheets.length - 1];
		//hustle.echo('RG_INIT_nullStyleSheet_' + typeof(hustle.nullStyleSheet));
		//デザイン・アニメーションCSSファイルの指定項目を配列として取得する。
		hustle.dsgnRules = hustle.PU.getStyleRules({css:hustle.dsgnCss, visa:this.VISA});
		hustle.animRules = hustle.PU.getStyleRules({css:hustle.animCss, visa:this.VISA});
		//hustle.echo(`RG_INIT_dsgnRules_>${hustle.dsgnRules}`, false, hustle.dsgnRules);
		//hustle.echo(`RG_INIT_animRules_>${hustle.animRules}`, false, hustle.animRules);
		//----------------------------------------------------------------
		// メインオブジェクトを生成
		// MainClassオブジェクトは生成時にRegistrationClassオブジェクトを参照するのでここで生成を記述する
		hustle.MAIN = new MainClass(this);
		hustle.MAIN.init();
	}
}
