/****************************************************************
studio hustlemouse
JavaScript Code 'hustlePageUtilityClass'
Author MARUHIRO
Create:2015.12.22
Modify:2024.5.28
(c)maruhiro all rights reserved.
****************************************************************/
class hustlePageUtilityClass {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//----------------------------------------------------------------
	constructor() {}
//----------------------------------------------------------------
// PROPATYS
//----------------------------------------------------------------
	//Syntax:objectName.ESC2NCR();
	//Reference:数値文字参照(Numeric Character Reference)のリストオブジェクトを返す。
	static ESC2NCR() {return {'\t':'&#9;','\n':'&#10;','\r':'&#13;',' ':'&#32;','\"':'&#34;','\'':'&#39;',',':'&#44;','\r\n':'&#13;&#10;'}};
	//Syntax:objectName.ESC2HTML();
	//Reference:HTMLエンコードのリストオブジェクトを返す。
	static ESC2HTML() {return {'<':'&lt;','>':'&gt;','&':'&amp;','\"':'&quot;','\'':'&#39;',' ':'&nbsp;'}};
	//Syntax:objectName.BCK2TXT();
	//Reference:数値文字参照やHTMLエンコードと対になる通常テキストのリストオブジェクトを返す。
	static BCK2TXT() {return {'&lt;':'<','&gt;':'>','&amp;':'&','&quot;':'\"','&nbsp;':' ','&#9;':'\t','&#10;':'\n','&#13;':'\r','&#32;':' ','&#34;':'\"','&#39;':'\'','&#44;':','}};
//----------------------------------------------------------------
// REGULAR EXPRESSION
//----------------------------------------------------------------
	//Syntax:objectName.RegTest({re, str});
	//Parameter:'re'は正規表現オブジェクト
	//Parameter:'str'はターゲット文字列
	//Return:真偽値
	//Reference:検索してマッチした文字列が有るか無いかの真偽値を返す。
	static RegTest({re, str}) {
		return re.test(str);
	}
	//Syntax:objectName.RegSearch({re, str});
	//Parameter:'re'は正規表現オブジェクト
	//Parameter:'str'はターゲット文字列
	//Return:数値
	//Reference:検索してマッチした文字列の初頭のインデックスを返す。
	static RegSearch({re, str}) {
		return str.search(re);
	}
	//Syntax:objectName.RegMatch({re, str});
	//Parameter:'re'は正規表現オブジェクト
	//Parameter:'str'はターゲット文字列
	//Return:文字列もしくはnull
	//Reference:検索してマッチした文字列かマッチがなければnullを返す。
	static RegMatch({re, str}) {
		return str.match(re);
	}
	//Syntax:objectName.RegReplace({s, re, str});
	//Parameter:'s'は置き換える文字列
	//Parameter:'re'は正規表現オブジェクト
	//Parameter:'str'はターゲット文字列
	//Return:文字列
	//Reference:検索してマッチした文字列を's'置き換えて文字列を返す。
	static RegReplace({s, re, str}) {
		return str.replace(re, s);
	}
	//Syntax:objectName.RegExec({re, str});
	//Parameter:'re'は正規表現オブジェクト
	//Parameter:'str'はターゲット文字列
	//Return:文字列もしくはnull
	//Reference:'re.lastIndex'プロパティのインデックスから検索を開始してマッチした文字列かマッチがなければnullを返す。
	//Reference:正規表現オブジェクトの're.lastIndex'プロパティにマッチした文字列の末尾の次のインデックス（次の検索開始位置）が格納される
	static RegExec({re, str}) {
		return re.exec(str);
	}
	//Syntax:objectName.encodeHtml({str});
	//Parameter:'str'はターゲット文字列
	//Return:文字列
	//Reference:HTMLの特殊文字（Special Character）をHTMLエンコードしてエスケープ処理する。（速習ES6=339、本格JS=4.7.1）
	static encodeHtml({str}) {
		//hustle.echo('ENCODE_HTML_>'+str, false);
		//if(!str) return;
		if(!str || str==='' || str===null || str===undefined) return '';
		const re = new RegExp('[<>&\"\' ]', 'g');//最後に1バイトスペースあり
		return this.RegReplace({s:sm => this.ESC2HTML()[sm], re, str});
	}
	//Syntax:objectName.decodeHtml({str});
	//Parameter:'str'はターゲット文字列
	//Return:文字列
	//Reference:HTMLエンコードでエスケープ処理された特殊文字をデコードして通常テキストにする。
	static decodeHtml({str}) {
		//hustle.echo('DECODE_HTML_>'+str, false);
		if(!str) return;
		const re = new RegExp('&(lt|gt|amp|quot|#39|nbsp);', 'g');
		return this.RegReplace({s:sm => this.BCK2TXT()[sm], re, str});
	}
	//Syntax:objectName.encodeNCR({str});
	//Parameter:'str'はターゲット文字列
	//Return:文字列
	//Reference:テキスト化するとトラブルになる記号類を数値文字参照（Numeric Character References）にエンコードしてエスケープ処理する。
	static encodeNCR({str}) {
		//hustle.echo('ENCODE_CHARACTER_REFERENCR_>'+str, false);
		if(!str) return;
		const re = new RegExp('[\t\n\r\"\', ]', 'g');//最後に1バイトスペースあり
		return this.RegReplace({s:sm => this.ESC2NCR()[sm], re, str});
	}
	//Syntax:objectName.decodeNCR({str});
	//Parameter:'str'はターゲット文字列
	//Return:文字列
	//Reference:数値文字参照（Character References）にエンコードされた文字を通常テキストにデコードする。
	static decodeNCR({str}) {
		//hustle.echo('DECODE_CHARACTER_REFERENCR_>'+str, false);
		if(!str) return;
		const re = new RegExp('&#(9|10|13|32|34|39|44);', 'g');
		return this.RegReplace({s:sm => this.BCK2TXT()[sm], re, str});
	}
	//Syntax:objectName.CV({str});
	//Parameter:'str'は取得したフォーム内エレメントの'value'の値（文字列）を想定
	//Return:文字列
	//Reference:文字列の初端と末尾にある空白文字（スペースや改行）を削除して返す。CVはクリアバリューの略。
	//Reference:'.value'とパスによる取得値の末尾にスペースが付いてきて処理が進まないことがある。それを回避するために作成した。
	static CV({str}) {
		const re = new RegExp('^\\s*(.+?)\\s*$', 'g');
		return this.RegReplace({s:'$1', re, str});
	}
	//UNUSED 20210128
	//----------------------------------------------------------------
	//Syntax:objectName.RegParams(re);
	//Parameter:'re'は正規表現オブジェクト
	//Return:なし
	//Reference:正規表現オブジェクトの各プロパティをログ出力する
	static RegPropatys({re}) {
		hustle.echo('REGEXP_SOURCE_>' + re.source + '_GLOBAL_>' + re.global + '_IGNORECASE_>' + re.ignoreCase + '_MULTILINE($*)_>' + re.multiline, false);
		//Reference:'input'と'lastIndex'は'ecec()'を利用する。
		hustle.echo('REGEXP_INPUT_>' + re.input + '_LASTINDEX_>' + re.lastIndex, false);
		hustle.echo('REGEXP_$1_>' + re.$1 + '_$2_>' + re.$2 + '_$3_>' + re.$3 + '_$4_>' + re.$4 + '_$5_>' + re.$5 + '_$6_>' + re.$6 + '_$7_>' + re.$7 + '_$8_>' + re.$8 + '_$9_>' + re.$9, false);
		hustle.echo('REGEXP_LASTMATCH($&)_>' + re.lastMatch + '_LASTPAREN($+)_>' + re.lastParen + '_LEFTCONTEXT($`)_>' + re.leftContext + '_RIGHTCONTEXT($\')_>' + re.rightContext, false);
	}
//----------------------------------------------------------------
// TARGET GETTERS (GET DOCUMENTS OBJECT)
//----------------------------------------------------------------
	// CHECK A ELEMENT
	//----------------------------------------------------------------
	static CheckNode({obj}) {
		hustle.echo('CHECK_TAG_>' + obj.tagName + '_NODE_>' + obj.nodeName + '_TYPE_>' + obj.nodeType + '_VALUE_>' + obj.nodeValue);
		//'tagName'はソースの大小文字が保持される。
		//'nodeName'はHTMLでは大文字で返される。
		//'nodeValue'だけ書込み可。
		hustle.echo('CHECK_TEXTCONTENT_>' + obj.textContent);
		hustle.echo('CHECK_INNERTEXT_>' + obj.innerText);
		hustle.echo('CHECK_INNERHTML_>' + obj.innerHTML);
	}
	// REFERENCE A ELEMENT or ELEMENTS WITH GETELEMENTXXXX
	//----------------------------------------------------------------
	//Syntax:objectName.ID({id, obj});
	//Parameter:'id'はid指定値
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:オブジェクト内で指定id値のオブジェクトもしくはnullを返す。
	//Reference:HTMLElementにgetElementByIdメソッドは実装されていないので、documentにしか利用できない。
	static ID({id, obj=document}) {
		return obj.getElementById(id);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.TAG({tag, obj});
	//Parameter:'tag'はタグ名
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:オブジェクト内で同じタグ名のオブジェクのHTMLCollection[]を返す。
	static TAG({tag, obj=document}) {
		//名前空間を参照する場合、getElementsByTagName('prefix:tagname')と記述しないと'tagname'があってもlengthを0で返す。
		return obj.getElementsByTagName(tag);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.NAME({nm, obj});
	//Parameter:'nm'はname属性値
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:オブジェクト内で同じname属性値のオブジェクトのNodeList[]を返す。
	//Reference:HTMLElementにgetElementsByNameメソッドは実装されていないので、documentにしか利用できない。
	static NAME({nm, obj=document}) {
		return obj.getElementsByName(nm);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.CLASS({cls, obj});
	//Parameter:'cls'はclass属性値
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:オブジェクト内で同じclass属性値のオブジェクトのHTMLCollection[]を返す。
	static CLASS({cls, obj=document}) {
		return obj.getElementsByClassName(cls);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.FORM({nm});
	//Parameter:'nm'はformタグのname属性値
	//Reference:ページ内で同じname属性値のついたformタグエレメントを返す。
	static FORM({nm}) {return document[nm];}
	//----------------------------------------------------------------
	//Syntax:objectName.INPUTS({nm, obj});
	//Parameter:'nm'はinputタグのname属性値
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:ページ内で同じname属性値のついたinputタグエレメントの配列を返す。
	static INPUTS({nm, obj}) {
		//getElementsByTagName,getElementsByNameに差し替える。
		//return this.SELECTS({slc:`input[name='${nm}']`});
		//return this.NAME({nm, obj:this.TAG({tag:'input'})});
		const ts = this.TAG({tag:'input', obj});
		let r = new Array();
		for(let t of ts) {
			if(t.name === nm) r.push(t);
		}
		return r;
	}
	//Syntax:objectName.SELECT({nm, obj});
	//Parameter:'nm'はselectタグのname属性値
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:ページ内で同じname属性値のついた最初のselectタグエレメントを返す。
	static SELECT({nm, obj}) {
		const ts = this.TAG({tag:'select', obj});
		for(let t of ts) {
			if(t.name === nm) return t;
		}
		return null;
	}
	//Syntax:objectName.FIELDSET({nm, obj});
	//Parameter:'nm'はfieldsetタグのname属性値
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:ページ内で同じname属性値のついた最初のfieldsetタグエレメントを返す。
	static FIELDSET({nm, obj}) {
		const ts = this.TAG({tag:'fieldset', obj});
		for(let t of ts) {
			if(t.name === nm) return t;
		}
		return null;
	}
	//Syntax:objectName.BUTTON({nm, obj});
	//Parameter:'nm'はbuttonタグのname属性値
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:ページ内で同じname属性値のついた最初のbuttonタグエレメントを返す。
	static BUTTON({nm, obj}) {
		const ts = this.TAG({tag:'button', obj});
		for(let t of ts) {
			if(t.name === nm) return t;
		}
		return null;
	}
	//----------------------------------------------------------------
	//Syntax:objectName.TARGETS({vlu, atr, tag, obj});
	//Parameter:'vlu'は属性値
	//Parameter:'atr'は属性名
	//Parameter:'tag'はタグ名
	//Parameter:'obj'はターゲットオブジェクト
	//Return:配列
	//Reference:タグ名と属性名とその値からエレメントオブジェクトの配列を返す。
	static TARGETS({vlu, atr, tag, obj}) {
		const t = this.TAG({tag, obj});
		let r = new Array();
		for (let i = 0; i < t.length; i++) {
			if ((t[i][atr] === vlu)) r.push(t[i]);
		}
		return r;
	}
	// REFERENCE A ELEMENT or ELEMENTS WITH QUERY SELECTOR
	//----------------------------------------------------------------
	//Syntax:objectName.QSELECT({slc, obj});
	//Parameter:'slc'はCSS表記のセレクタ文字列
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:オブジェクト内で最初のセレクタ名のエレメントを返す。ない場合はnullでしょうか？
	static QSELECT({slc, obj=document}) {
		return obj.querySelector(slc);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.QSELECTS({slc, obj});
	//Parameter:'slc'はCSS表記のセレクタ文字列
	//Parameter:'obj'はターゲットオブジェクト
	//Reference:オブジェクト内の同じセレクタ名のエレメントのNodeList[]を返す。ない場合はlengthを0で返す。
	static QSELECTS({slc, obj=document}) {
		//querySelectorAll()はプレフィックスを記述すると参照しない。
		return obj.querySelectorAll(slc);
	}
	//----------------------------------------------------------------
	// GET OTHRE ELEMENT
	//----------------------------------------------------------------
	//Syntax:objectName.ParentTagNode({nm, obj});
	//Parameter:'nm'はタグ名
	//Parameter:'obj'は捜索元オブジェクト
	//Reference:捜索元オブジェクトから上位に親を参照してタグ名の合致するエレメントを返す。BODYまで探してない場合は-1を返す。
	static ParentTagNode({nm, obj}) {
		let r = obj;
		while(r.parentNode.tagName !== 'BODY') {
			if(r.parentNode.tagName === nm) return r.parentNode;
			else r = r.parentNode;
		}
		//hustle.echo(`ELEMENT_>${trg.tagName}_NAME_>${trg.name}_HAS_NO_FROM_ON_CLASSES_GENERATION_>`, true);
		return -1;
	}
//----------------------------------------------------------------
// GET INFORMATIONS OF LOADED STYLE SHEETS
//----------------------------------------------------------------
	//Syntax:objectName.getStyleRules({css, visa});
	//Parameter:'css'はCSSファイル名
	//Parameter:'visa'はプラットフォーム査証真偽値一式
	//Return:なし
	//Reference:CSSファイルの指定項目オブジェクト群を配列として返す
	static getStyleRules({css, visa}) {
		let r = null;
		if(typeof(css)==='string' && css.length===0) css = null;
		//hustle.echo(`PU_styleSheets_length_${document.styleSheets.length}_ファイルは読み込まれますが、ローカルファイルサービスではスタイルシートオブジェクトにはアクセスできないので気をつけましょう。今現在2017.12.26`, false);
		for(let s of document.styleSheets) {
			//hustle.echo(`PU_CSS_>${css}_>HREF_>${s.href}`, false);
			if(s.href !== null && s.href.lastIndexOf(css) !== -1) {
				r = s.cssRules;
				break;
			}
		}
		return r;
	}
	//----------------------------------------------------------------
	//Syntax:objectName.getCssUrl({css});
	//Parameter:'css'はCSSファイル名
	//Return:なし
	//Reference:CSSファイルの絶対パスを返す
	static getCssUrl({css}) {
		let r = null;
		if(typeof(css)==='string' && css.length===0) css = null;
		for(let s of document.styleSheets) {
			if(s.href.lastIndexOf(css) !== -1) {
				r = s.href;
				break;
			}
		}
		return r;
	}
	// GET STYLE PARAM LIST（調査用メソッド）
	//----------------------------------------------------------------
	//Syntax:objectName.testStyleWzList({slc, obj});
	//Parameter:'slc'はCSSのセレクター文字列の最後のキーワード（idなら「#hoge」、classなら「.hoge」）
	//Parameter:'obj'は任意のCSSファイルの指定項目オブジェクト群の配列
	//Return:なし
	//Reference:任意のCSS指定項目オブジェクト群から任意セレクタのプロパティーを含む項目の配列を参照するメソッド
	static testStyleWzList({slc, obj}) {
		//正規表現オブジェクトを生成
		const re = new RegExp(slc + '$');
		let i = 0;
		for(let rl of obj) {
			if(rl.selectorText !== undefined) {
				//hustle.echo('RULES['+i+']_>'+rl+'_SELECTOR_>'+rl.selectorText+'_TYPE_>'+rl.type+'_STYLE_>'+rl.style, false);
				//hustle.echo('SLCTR_>'+rl.selectorText, false);
				let a = rl.selectorText.split(',');
				a = a.map((vc,id,ar)=>this.CV({str:vc}));
				//hustle.echo('CLEAR_>'+a.toString(), false);
				if(a.some((vc, id, ar)=>this.RegTest({re, str:vc}))) {
					hustle.echo('MACH__>'+a.map((vc, id, ar)=>this.RegMatch({re, str:vc})), false);
				}
				i++;
			}
		}
	}
	// GET STYLE PARAM LIST
	//----------------------------------------------------------------
	//Syntax:objectName.getMatchRules({slc, obj});
	//Parameter:'slc'はCSSのセレクター文字列の最後のキーワード（idなら「#hoge」、classなら「.hoge」）
	//Parameter:'obj'は任意のCSSファイルの指定項目オブジェクト群の配列
	//Return:配列
	//Reference:任意のCSS指定項目オブジェクト群から任意セレクタのプロパティーを含む項目の配列を取得するメソッド
	static getMatchRules({slc, obj}) {
		let r = new Array();
		const re = new RegExp(slc + '$');
		for(let rl of obj) {
			if(rl.selectorText !== undefined) {
				let a = rl.selectorText.split(',');
				a = a.map((vc,id,ar)=>this.CV({str:vc}));
				if(a.some((vc, id, ar)=>this.RegTest({re, str:vc}))) {
					r.push(rl);
				}
			}
		}
		return r;
	}
	// SET STYLE PROPERTY FOR A ELEMENT OBJECT
	//----------------------------------------------------------------
	//Reference:まるっとsetSTYLEprp({prp, vlu, imp, obj})を参照する。
	static setSTYLErule({prp, vlu, imp, obj}) {
		this.setSTYLEprp({prp, vlu, imp, obj});
	}
	//----------------------------------------------------------------
	// GET STYLE PROPERTY WITH A ELEMENT OBJECT
	//----------------------------------------------------------------
	//Syntax:objectName.STYLEprp({prp, obj});
	//Parameter:'prp'はCSSのプロパティ文字列（'margin-top'などラクダでない表記）（一括指定プロパティ名は不可）
	//Parameter:'obj'はターゲットエレメント
	//Return:文字列
	//Reference:getComputedStyle()を利用して解決値（現況の値）を取得する。
	static STYLEprp({prp, obj}) {
		return window.getComputedStyle(obj).getPropertyValue(prp);
	}
	// SET STYLE PROPERTY FOR A ELEMENT OBJECT
	//----------------------------------------------------------------
	//Syntax:objectName.setSTYLEprp({prp, vlu, imp, obj});
	//Parameter:'prp'はCSSのプロパティ文字列（'margin-top'などラクダでない表記）（一括指定プロパティ名は不可）
	//Parameter:'vlu'はプロパティーの値
	//Parameter:'imp'はプライオリティーで'important'指定の有無だけ
	//Parameter:'obj'はターゲットエレメント
	//Reference:setProperty()を利用して対象エレメントにスタイル指定をする。
	static setSTYLEprp({prp, vlu, imp, obj}) {
		if(imp !== undefined) imp = imp==='important'? imp:'';
		obj.style.setProperty(prp, vlu, imp);
	}
	//----------------------------------------------------------------
	// GET ELEMENT RECTANGLE
	//----------------------------------------------------------------
	//Syntax:objectName.RECT({obj});
	//Parameter:'obj'はページに配置されたエレメントオブジェクト
	//Return:オブジェクト
	//Reference:エレメントのレクトアングル情報をオブジェクトにまとめて返す。
	static RECT({obj}) {
		const r = obj.getBoundingClientRect();
		return {x:r.x,y:r.y,t:r.top,r:r.right,b:r.bottom,l:r.left,w:r.width,h:r.height};
	}
//----------------------------------------------------------------
// CREATE DOCUMENTS OBJECT
//----------------------------------------------------------------
	// CREATE A ELEMENT
	//----------------------------------------------------------------
	//Syntax:objectName.CREATE({id, tag});
	//Parameter:'id'はid指定名
	//Parameter:'tag'はタグ名
	//Reference:タグ名と属性、属性名から特定の複数エレメントオブジェクトの配列を返す
	//static CREATE({id, tag}) {
	static CREATE({id, clss, name, role, src, href, type, dir, tag}) {
		const r = document.createElement(tag);
		if(id !== undefined) r.setAttribute('id', id);
		if(clss !== undefined) r.setAttribute('class', clss);
		if(name !== undefined) r.setAttribute('name', name);
		if(role !== undefined) r.setAttribute('role', role);
		if(src !== undefined) r.setAttribute('src', src);
		if(href !== undefined) r.setAttribute('href', href);
		if(type !== undefined) r.setAttribute('type', type);
		if(dir !== undefined) r.setAttribute('dir', dir);
		return r;
	}//[候補]cloneNode()
	//Parameter:'elm'は任意エレメントオブジェクト
	//Parameter:'obj'は挿入先エレメントオブジェクト
	static PUSH({elm, obj}) {
		obj.appendChild(elm);
	}//[候補]insertBefore()
	//Parameter:'elm'は任意エレメントオブジェクト
	//Parameter:'obj'は削除元エレメントオブジェクト
	static DEL({elm, obj}) {
		obj.removeChild(elm);
	}//[候補]replaceChild()
//----------------------------------------------------------------
// TARGET CONTROL
//----------------------------------------------------------------
	// SET VISIBLE OF TARGET ELEMENT
	//----------------------------------------------------------------
	//Syntax:objectName.VIZ({b, obj});
	//Parameter:'b'は表示の真偽値
	//Parameter:'obj'は対象オブジェクト
	//Return:真偽値
	//Reference:調査と設定の重複機能メソッド
	//Reference:（１）引数'b'が空もしくは無い場合は対象オブジェクトの表示真偽値を返す
	//Reference:（２）対象オブジェクトの表示非表示をCSS設定でコントロールする
	static VIZ({b, obj}) {
		if(b===undefined || b===null || b==='') {
			return obj.style['display']==='block';
		} else {
			obj.style.display = (b) ?'block':'none';
			return b;
		}
	}
	//----------------------------------------------------------------
	// ORGANIZE ATTRIBUTE OF TARGET ELEMENT
	//----------------------------------------------------------------
	//Syntax:objectName.setATBT({vlu, atr, obj});
	//Syntax:objectName.ATBT({atr, obj});
	//Syntax:objectName.delATBT({atr, obj});
	//Parameter:'vlu'は属性値文字列
	//Parameter:'atr'は属性名文字列
	//Parameter:'obj'は対象オブジェクト
	//Reference:取得エレメントの指定属性の内容変更、参照、削除を行う
	//Reference:class属性は利用が多いので続けて操作メソッドを別途用意する
	static setATBT({vlu, atr, obj}) {
		obj.setAttribute(atr, vlu);
	}
	static ATBT({atr, obj}) {
		return obj.getAttribute(atr);
	}
	static delATBT({atr, obj}) {
		obj.removeAttribute(atr);
	}
	//----------------------------------------------------------------
	// classに関してはclassNameやclassListの利用も検討できるが、基本はxxxAttribute()で運用する。
	//----------------------------------------------------------------
	static setClass({vlu, obj}) {
		this.setATBT({vlu, atr:'class', obj});
	}
	//----------------------------------------------------------------
	static getClass({obj}) {
		return this.ATBT({atr:'class', obj});
	}
	//----------------------------------------------------------------
	static delClass({obj}) {
		this.delATBT({atr:'class', obj});
	}
	//----------------------------------------------------------------
	static getID({obj}) {
		return this.ATBT({atr:'id', obj});
	}
	//----------------------------------------------------------------
	// SET LOCATION AND SIZE, ZINDEX OF TARGET ELEMENT
	//----------------------------------------------------------------
	//Syntax:objectName.locate({skl, pt, obj});
	//Parameter:'skl'は表示縮尺率
	//Parameter:'pt'は表示位置情報の配列（pt[0]がx、pt[1]がyの値）
	//Parameter:'obj'は対象エレメント（設定対象の任意セレクタのオブジェクトかもしれない）
	//Reference:対象エレメントの絶対位置を指定する
	//Reference:スタイルのposition指定がabsoluteの場合に動作する
	static locate({skl, pt, obj}) {
		if (typeof (skl) !== 'number' || skl <= 0) skl = 1;
		obj.style.left = pt[0] * skl + 'px';
		obj.style.top = pt[1] * skl + 'px';
		//return false;
	}
	//----------------------------------------------------------------
	//Syntax:objectName.resize({skl, wh, obj});
	//Parameter:'skl'は表示縮尺率
	//Parameter:'wh'は表示サイズ情報の配列（wh[0]がwidth、wh[1]がheightの値）
	//Parameter:'obj'は対象エレメント（設定対象の任意セレクタのオブジェクトかもしれない）
	//Reference:対象エレメントの表示サイズを指定する
	static resize({skl, wh, obj}) {
		if (typeof (skl) !== 'number' || skl <= 0) skl = 1;
		obj.style.width = wh[0] * skl + 'px';
		obj.style.height = wh[1] * skl + 'px';
		//return false;
	}
	//----------------------------------------------------------------
	static adjustELMT({skl, pt, wh, obj}) {
		this.locate({skl, pt, obj});
		this.resize({skl, wh, obj});
	}
	//----------------------------------------------------------------
	//Syntax:objectName.zindex({z, obj});
	//Parameter:'z'はzindex数値
	//Parameter:'obj'は設定対象の任意エレメントオブジェクト
	//Reference:対象エレメントオブジェクトのzindexを指定する
	static zindex({z, obj}) {
		obj.style.zIndex = z;
		//return false;
	}
	//----------------------------------------------------------------
	//Syntax:objectName.trickEvent({evt, obj});
	//Parameter:'evt'は'click'や'mousedown'などのイベント名
	//Parameter:'obj'は対象エレメント
	//Reference:
	static trickEvent({evt, obj}) {
		const e = new Event(evt,{bubbles:true, cancelable:false, composed:false} );
		obj.dispatchEvent(e);
	}
//----------------------------------------------------------------
// ORGANIZE ANIMATION EVENT FOR TARGET
//----------------------------------------------------------------
	// SET ANIMATION END LISTENER
	//----------------------------------------------------------------
	//Syntax:objectName.setAnimEndLstnr({fn, obj});
	//Syntax:objectName.delAnimEndLstnr({fn, obj});
	//Parameter:'fn'はイベントを受け取るメソッド
	//Parameter:'obj'は設定対象の任意エレメントオブジェクト
	//Reference:対象エレメントにアニメーション終了のイベントリスナー仕込み、イベントを返すメソッドを指定する
	static setAnimEndLstnr({fn, obj}) {
		obj.addEventListener('webkitAnimationEnd', fn, false);
		obj.addEventListener('MSAnimationEnd', fn, false);
		obj.addEventListener('oanimationend', fn, false);
		obj.addEventListener('animationend', fn, false);
	}
	//----------------------------------------------------------------
	//Reference:対象エレメントからアニメーション終了のイベントリスナーを削除する
	static delAnimEndLstnr({fn, obj}) {
		obj.removeEventListener('webkitAnimationEnd', fn, false);
		obj.removeEventListener('MSAnimationEnd', fn, false);
		obj.removeEventListener('oanimationend', fn, false);
		obj.removeEventListener('animationend', fn, false);
	}
	// SET ANIMATION INTERATION LISTENER
	//----------------------------------------------------------------
	//Syntax:objectName.setAnimIterationLstnr({fn, obj});
	//Syntax:objectName.delAnimIterationLstnr({fn, obj});
	//Parameter:'fn'はイベントを受け取るメソッド
	//Parameter:'obj'は設定対象の任意エレメントオブジェクト
	//Reference:対象エレメントにアニメーション繰返しのイベントリスナー仕込み、イベントを返すメソッドを指定する
	static setAnimIterationLstnr({fn, obj}) {
		obj.addEventListener("webkitAnimationIteration", fn, false);
		obj.addEventListener("MSAnimationIteration", fn, false);
		obj.addEventListener("oanimationiteration", fn, false);
		obj.addEventListener("animationiteration", fn, false);
	}
	//----------------------------------------------------------------
	//Reference:対象エレメントからアニメーション繰返しのイベントリスナーを削除する
	static delAnimIterationLstnr({fn, obj}) {
		obj.removeEventListener('webkitAnimationIteration', fn, false);
		obj.removeEventListener('MSAnimationIteration', fn, false);
		obj.removeEventListener('oanimationiteration', fn, false);
		obj.removeEventListener('animationiteration', fn, false);
	}
	// REPLACE STYLE ANIMATION KEYFRAME
	//----------------------------------------------------------------
	//Syntax:objectName.replaceAnimKey({prp, key, anim, srs, visa});
	//Parameter:'prp'は書き込むプロパティ:値セットの文字列
	//Parameter:'key'はアニメーションの進行度合表記
	//Parameter:'anim'はキーフレームアニメーションの名前
	//Parameter:'srs'は任意のCSSファイルの指定ルール配列
	//Parameter:'visa'はプラットフォーム査証真偽値一式
	//Reference:アニメーションCSS該当キーフレームに指定を上書きするメソッド（IE未確認）
	static replaceAnimKey({prp, key, anim, srs, visa}) {
		//hustle.echo(`REPLACE_ANIM_KEY_>_SELECTOR_>${anim}_KEY_>${key}_APPENDRULE_>${prp}`, false);
		for (let i = 0; i < srs.length; i++) {
			//hustle.echo(`CSS_TEXT_${srs[i].cssText}`, false);
			if(srs[i].name === anim) {
				//nameプロパティを参照できるのはCSSKeyframesRuleオブジェクトだけ？
				//hustle.echo(`KEYFRAME_CSSRULES_${srs[i].cssRules}`, false);
				switch (srs[i].type) {
					//CSSRuleインターフェイスの型定数で振り分ける
					case window.CSSRule.WEBKIT_KEYFRAMES_RULE:
						//hustle.echo(`KEYTEXT_>${srs[i].keyText}_REPLACE_WITH_>${key}{${prp}}`, false);
						srs[i].deleteRule(key);
						srs[i].appendRule(`${key}{${prp}}`);
						break;
					case window.CSSRule.KEYFRAMES_RULE:
						//hustle.echo(`KEYTEXT_>${srs[i].keyText}_REPLACE_WITH_>${key}{${prp}}`, false);
						srs[i].deleteRule(key);
						srs[i].appendRule(`${key}{${prp}}`);
						break;
					default:
						hustle.echo(`TARGET_NAME_>${srs[i].name}`, true);
				}
				//hustle.echo(`CSS_TEXT_>${srs[i].cssText}`, false);
			}
		}
	}
}
