<?php
/**
* @package asama
* @category include
*/
//--------------------------------------------------------------------------------
// studio hustlemouse
// PHP Code 'HustleClass.php'
// Create : 2021.12.16
// Modify : 2025.1.24
// Author : maruhiro
// (c)maruhiro all rights reserved.
//--------------------------------------------------------------------------------
// CORE CLASS
//--------------------------------------------------------------------------------
class HustleClass {
	//--------------------------------------------------------------------------------
	// CONSFIGURATION
	//--------------------------------------------------------------------------------
	private const INCLUDE_PATH = '/include/';
	//const CLASS_FILE_PREFIX = 'hustle';
	//const CLASS_FILE_SUFFIX = 'Class';
	//const PACKAGE_PREFIX = '';
	private const HOOK_CLASSES = ['RegistrationClass', 'AdministrationClass', 'ActivationClass'];
	//const ADMIN_PROCESSOR_PREFIX = 'Admin_Processor_';
	//const ADMIN_PROCS = array( 'setting', 'management' );
	//const CONTROLLER_SUFFIX = '_Controller';
	public $UTL;
	public $aspect_index = 0.707;
	//カスタム投稿タイプ名を格納する配列（空でもここでpublic宣言しないといかんかった）
	public $postHeads;
	public $postTypes;
	public $postTypeName = 'Feature';
	//配列型汎用プライベートプロパティ
	private $prps = array();
	/*** 以下のプロパティーはゲッターとセッターで運用する。ゲッターで運用するのでpublic扱いになる。***/
	//public $pageMode = '';//ページタイプ
	//public $achvType = '';//アーカイブズタイプ
	//public $pageSlg = '';//スラッグ
	//public $customPost = false;
	/*** 以下のプロパティーは名前で参照して運用する。***/
	//確実な動作のためにスタイルシートはフォント→アニメーション→デザインの順番で読み込まれるように列記する。
	//ブログページ
	private $currentFonts = array(
	'https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200',
	'https://fonts.googleapis.com/css2?family=Source+Code+Pro:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap',
	'https://fonts.googleapis.com/css2?family=Noto+Sans:ital,wght@0,400;0,700;1,400;1,700&display=swap',
	'https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100;300;400;500;700;900&display=swap',
	);
	private $parentStyles = array(
	'/css/font.css',
	);
	private $currentStyles = array(
	'/css/asama.css',
	);
	private $currentScripts = array(
	'/js/hustleConfig.js',
	);
	//投稿編集ページ
	private $editorFonts = array(
	'https://fonts.googleapis.com/css2?family=Source+Code+Pro:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap',
	'https://fonts.googleapis.com/css2?family=Noto+Sans:ital,wght@0,400;0,700;1,400;1,700&display=swap',
	'https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100;300;400;500;700;900&display=swap',
	'https://fonts.googleapis.com/css2?family=Quicksand:wght@300;400;500;600;700&display=swap',
	'https://fonts.googleapis.com/css2?family=Kiwi+Maru:wght@300;400;500&display=swap',
	);
	private $editorStyles = array(
	'/css/postEdit.css',
	);
	//--------------------------------------------------------------------------------
	// CONSTRUCTOR（戻り値は設定できない。）
	//--------------------------------------------------------------------------------
	public function __construct() {}
	//自信のクラス名をマジックメソッドで返す。
	public static function who() {return __CLASS__;}
	//--------------------------------------------------------------------------------
	// INITIALIZE
	//--------------------------------------------------------------------------------
	public function init() {
		//タイムゾーンセット（不安な設定）
		//date_default_timezone_set( 'Asia/Tokyo' );
		//Built-Inプラグインのロード
		//include_once( TEMPLATEPATH.'/lib/acf/acf.php' );
		//include_once( TEMPLATEPATH.'/lib/acf-repeater/acf-repeater.php' );
		require_once(TEMPLATEPATH.self::INCLUDE_PATH.'tool/UtilityClass.php');
		//初期化の始まる前に'UtilityClass'の参照を容易にしておく。ログ出力の'echo'も使えるようになる。
		$this->UTL = 'UtilityClass';
		$this->echoo('I_AM_HUSTLECLASS_AND_THIS_THEME_IS_>'.get_template());
		foreach(self::HOOK_CLASSES as $nm) {
			require_once(TEMPLATEPATH.self::INCLUDE_PATH.'stuff/'.$nm.'.php');
		}
		//クラスファイルのAutoLoad（テスト中）
		//spl_autoload_register(array($this, 'autoload'));
		$this->orderEnqueueScripts('parentStyles');
		//asamaテーマが有効化された場合
		if(get_template() === get_stylesheet()) {
			$this->orderEnqueueScripts('currentFonts');
			$this->orderEnqueueScripts('currentStyles');
			$this->PAGE_SPECIAL = '<p class="message"><span class="attention">THE PAGE SPECIAL!</span></p>';
			//the copyright for 'asama'
			$this->COPYRIGHT = '2021.11.15〜 developed by hustlemouse, asama & asamit themes are open source code. <br>Author : maruhiro (Coded with HTML5 + ES6 + PHP8)±';
		}
		$this->orderEnqueueScripts('currentScripts');
		$this->orderEnqueueScripts('editorFonts');
		$this->orderEnqueueScripts('editorStyles');
		//各種フックの登録（読み込んだクラスファイルの初期化）
		$this->bindHook(self::HOOK_CLASSES);
		//管理画面の処理
		//$this->admin_process(self::ADMIN_PROCS);
		//コントローラーのルーティング
		//$this->route_controller();
		$this->echoo('TYPE_>'.(is_home()?'IS_HOME':'NOT_HOME'));//早すぎて条件が拾えない
	}
	//--------------------------------------------------------------------------------
	// ECHO
	//--------------------------------------------------------------------------------
	//public function echo($str) {$this->UTL::echoo($str);}
	public function echoo($str) {
		$this->UTL::echoo($str);
		//グローバルメソッドを参照すればいいかと思ったらダメだった。（20230823）
		/* if(!is_admin() && self::isBlogPage()) {
			echoo('echo_PHP_>'.$str);
		} */
	}
	//--------------------------------------------------------------------------------
	// GETTER AND SETTER
	//--------------------------------------------------------------------------------
	//マジックメソッド
	public function __get($key){return $this->get($key);}
	public function __set($key,$vlu){$this->set($key,$vlu);}
	//配列型汎用プロパティのゲッター
	//public function get(string $key):mixed {//なんか返り値がmixedという型じゃないと苦情が出るぞ？
	public function get(string $key) {
		if(array_key_exists($key, $this->prps)) {
			return $this->prps[$key];
		} else {
			$this->echoo("PROPERTY_>{$key}_UNDEFINDE");
			return 'UNDEFINDE';
		}
	}
	//配列型汎用プロパティのセッター
	//public function set(string $key, mixed $vlu):void {//なんかmixedという型じゃないと苦情が出るぞ？
	public function set(string $key, $vlu) {
		if(!array_key_exists($key, $this->prps)) {
			$this->echoo("PROPERTY_>{$key}_HAS_BEEN_MADE");
		}
		$this->prps[$key] = $vlu;
	}
	//--------------------------------------------------------------------------------
	// AUTO LOAD
	//--------------------------------------------------------------------------------
	// オートロード（spl_autoload_registerのコールバック）
	public function autoload($class) {
		$this->echoo("IS_A_CLASS_>{$class}");
		/* $directories = array( 
			TEMPLATEPATH.self::INCLUDE_PATH.'tool/',
			TEMPLATEPATH.self::INCLUDE_PATH.'stuff/',
		);
		foreach ($directories as $dir) {
			$class_path = $dir.$this->getClassFileName($class);
			if (is_file($class_path)) {
				$this->echoo("{$class_path}を要請しました。");
				require($class_path);
				return;
			}
		} */
	}
	// クラス名からクラスファイル名を取得
	/* private function getClassFileName($class) {
		//$nm = self::CLASS_FILE_PREFIX.str_replace('_', '-', $class).'.php';
		//$nm = self::CLASS_FILE_PREFIX.str_replace('_', '-', $class).self::CLASS_FILE_SUFFIX.'.php';
		//保険まで'_'を'-'に置き換える仕組みは入れておく。
		$nm = str_replace('_', '-', $class).'.php';
		return $nm;
	} */
	//--------------------------------------------------------------------------------
	// HOOKS
	//--------------------------------------------------------------------------------
	// フッククラス群の生成と初期化をして、その後はアクセスしない。
	public function bindHook($hooks) {
		foreach($hooks as $class) {
			if (class_exists($class)) {
				$instance = new $class($this);
				if (method_exists($instance, 'init')) {
					$instance->init();
				}
			}
		}
	}
	//--------------------------------------------------------------------------------
	// ORDERING $ HANDOUT SCRIPTS
	//--------------------------------------------------------------------------------
	public function orderEnqueueScripts($key) {
		$tmp = array();
		foreach($this->$key as $k=>$v) {
			$uri = '';
			switch($key) {
				case 'parentStyles':
				case 'editorStyles':
					//親テーマのディレクトリ取得はget_template_directory_uri()で取得する。
					$uri = get_template_directory_uri();
					break;
				case 'currentStyles':
				case 'currentScripts':
					//カレントテーマ（親テーマもしくは子テーマ）のディレクトリ取得はget_stylesheet_directory_uri()で取得する。
					$uri = get_stylesheet_directory_uri();
					break;
				case 'currentFonts':
				case 'editorFonts':
				default:
			}
			if(is_int($k)) $k = $key.'_'.$k;
			$tmp[$k] = $uri.$v;
			//$this->echoo("KEYWORD_>{$key}_PATH_>{$this->$key[$k]}");
		}
		$this->$key = $tmp;
	}
	public function tugEnqueueScripts($key):array {
		if(property_exists($this, $key)) return $this->$key;
		else return [];
	}
	//--------------------------------------------------------------------------------
	// ASAMA_PARAMETERS
	//--------------------------------------------------------------------------------
	public function setAsamaParams($arr) {
		foreach($arr as $k=>$v) {
			switch($k) {
				case 'EXCERPT_NUMBER':
					if(is_int($v)) $this->$k = $v;
					break;
				case 'GOOGLE_MAPS':
				case 'LOARD_ANY_SCRIPT':
					if(is_array($v)) $this->$k = $v;
					break;
				case 'CHILD_FONTS':
					if(is_array($v)) {
						$this->currentFonts = $v;
						$this->orderEnqueueScripts('currentFonts');
					}
					break;
				case 'CHILDE_STYLE':
					if(is_array($v)) {
						$this->currentStyles = $v;
						$this->orderEnqueueScripts('currentStyles');
					}
					break;
				case 'ADD_THUMBNAIL_FOR_RSS':
					if(is_bool($v)) $this->$k = $v;
					break;
				default:
					if(strlen($v)>0) $this->$k = $v;
			}
		}
	}
	//--------------------------------------------------------------------------------
	// START DATE OF THIS THEME
	//--------------------------------------------------------------------------------
	//当該テーマの運用開始日時を設定する。
	//投稿日と当該テーマの運用開始日時（$startDate）のUTCフォーマット数値の比較で真偽を返す。
	//当該テーマの運用開始日時以降であれば真、以前であれば偽となる。
	public function isTheThemePost($postTime) {
		if($this->START_DATE!=='UNDEFINDE' && !is_null($this->START_DATE)) $this->START_DATE='1970-01-01 00:00:00';
		$at = new DateTime($this->START_DATE, new DateTimeZone(wp_timezone_string()));
		//$this->echoo('PHP_TE_THEME_TIME_FORMAT_>'.$at->format('Y-m-d H:i:sP'));
		$at = $at->format('U');
		$pt = new DateTime($postTime, new DateTimeZone(wp_timezone_string()));
		//$this->echoo('PHP_POST_TIME_FORMAT_>'.$pt->format('Y-m-d H:i:sP'));
		$pt = $pt->format('U');
		//$this->echoo('PHP_POST_TIME_LOCAL_>'.$pt.'_WP_DATE_>'.wp_date('Y-m-d H:i:sP', $pt, wp_timezone()).'_><_THE_THEME_TIME_>'.$at.'_WP_DATE_>'.wp_date('Y-m-d H:i:sP', $at, wp_timezone()).'_RESULT_>'.$pt>=$at);
		return $pt>=$at;
	}
	//--------------------------------------------------------------------------------
	// HUSTLE_FRONTPAGE_NAME
	//--------------------------------------------------------------------------------
	public function isFrontpageName() {return ($this->FRONTPAGE_NAME!=='UNDEFINDE')?true:false;}
	//--------------------------------------------------------------------------------
	// HUSTLE_EXCERPT_NUMBER
	//--------------------------------------------------------------------------------
	public function isExcerptNumber() {return ($this->EXCERPT_NUMBER!=='UNDEFINDE')?true:false;}
	//--------------------------------------------------------------------------------
	// HUSTLE_TAG_CLOUD
	//--------------------------------------------------------------------------------
	public function isHustleTagCloud() {return ($this->HUSTLE_TAGCLOUD!=='UNDEFINDE')?true:false;}
	//--------------------------------------------------------------------------------
	// HUSTLE_BREAD_CRUMB
	//--------------------------------------------------------------------------------
	public function isHustleCrumb() {return ($this->HUSTLE_CRUMB!=='UNDEFINDE')?true:false;}
	//--------------------------------------------------------------------------------
	// GOOGLE_MAPS
	//--------------------------------------------------------------------------------
	public function putGoogleParams() {
		if($this->GOOGLE_MAPS!=='UNDEFINDE') {
			if(is_string($this->GOOGLE_MAPS['KEY']) && is_string($this->GOOGLE_MAPS['ID'])) {
				$this->GOOGLE_MAPS = array(
					'GooglMapsKEY'=>$this->GOOGLE_MAPS['KEY'],
					'GooglMapsID'=>$this->GOOGLE_MAPS['ID'],
				);
				echo '<script>GoogleParams = '.json_encode($this->GOOGLE_MAPS).'</script>';
			}
		}
	}
	//--------------------------------------------------------------------------------
	// LOARD_ANY_SCRIPT
	//--------------------------------------------------------------------------------
	public function loardAnyScripts() {
		if($this->LOARD_ANY_SCRIPT!=='UNDEFINDE') {
			foreach($this->LOARD_ANY_SCRIPT as $arr):
				$s = '<script';
				foreach($arr as $key=>$vlu):
					$key = strtolower($key);
					switch($key) {
						case 'src':
						case 'attributionsrc':
							$s .= ' '.$key.'="'.esc_url($vlu).'"';
							break;
						case '':
							$s .= ' '.$key;
							break;
						default:
							$s .= ' '.$key.'="'.esc_attr($vlu).'"';
					}
				endforeach;
				echo $s.'></script>';
			endforeach;
		}
	}
	//--------------------------------------------------------------------------------
	// SET_CHILD_THEME_CONTENTS
	//--------------------------------------------------------------------------------
	public function isThePageSpecial() {return ($this->PAGE_SPECIAL!=='UNDEFINDE')?true:false;}
	public function isTheCopyrigh() {return ($this->COPYRIGHT!=='UNDEFINDE')?true:false;}
	//--------------------------------------------------------------------------------
	// REGISTER_PAGE_MODE_&_ARCHIVES_TYPE
	//--------------------------------------------------------------------------------
	public function rgstPageAspects($pm, $at) {
		$this->pageMode = $pm;
		$this->achvType = $at;
	}
	public function theMode() {return $this->pageMode;}
	public function theAchvType() {return $this->achvType;}
	//--------------------------------------------------------------------------------
	// REGISTER_CUSTOME_POST_TYPE
	//--------------------------------------------------------------------------------
	public function setCreatePostType($b) {
		$this->customPost = $b;
		//セッターを使って配列の生成ができると思っていたが、なぜか？この空宣言ケースではPublicにできなかった。よって事前に宣言している。
		if($b) {
			$this->postHeads = [];
			$this->postTypes = [];
		}
	}
	public function isHustlePostType() {
		if($this->customPost!=='UNDEFINDE') return $this->customPost;
		else return false;
	}
	public function getHustlePostType() {
		return $this->postTypes;
	}
	public function rgstCustomPostType($arr) {
		if($this->customPost) $this->rgstPostType = $arr;
	}
	public function rgstCustomTaxonomy($arr) {
		if($this->customPost) $this->rgstTaxonomy = $arr;
	}
	//--------------------------------------------------------------------------------
	// ADD EYECATCH IMAGE ROR RSS
	//--------------------------------------------------------------------------------
	public function isAddThumbnailForRss() {
		if($this->ADD_THUMBNAIL_FOR_RSS!=='UNDEFINDE') return $this->ADD_THUMBNAIL_FOR_RSS;
		else return false;
	}
	//--------------------------------------------------------------------------------
	// SET PAGE SCROLL ARROW TYPE
	//--------------------------------------------------------------------------------
	public function isPageScrollArrowType() {
		if($this->PAGE_SCHROLL_ARROW_TYPE!=='UNDEFINDE') return $this->PAGE_SCHROLL_ARROW_TYPE;
		return 'UPnDOWN';
	}
	//--------------------------------------------------------------------------------
	// REGISTER_CUSTOM_FIELD
	//--------------------------------------------------------------------------------
	public function rgstCustomFieldSet($arr) {
		$this->echoo('REGIST_CUSTOMER_FIELD_SET_>'.implode(',', $arr[0]));
		$this->customFieldSet = $arr;
	}
}