<?php
/**
* @package asama
* @category include/shortcode
*/
// Short Code : [hustleShort file="include/shortcode/BreadCrumb" name="husteCrumb" mode="category" home="home."]
/**
* 属性パラメータはダブルクォテーションで記述する。
* file=""はテーマディレクトリからのソースファイルへのパス（拡張子は不要）
* name=""はnavタグname属性の値
* mode=""はシングルページ閲覧時にカテゴリー階層表記モードの値で、"category"もしくは"simple"（初期値）を渡す必要がある。初期値では階層表記をしなくなる。
* home=""はホームページの表記（初期値は"Home"で、Wordpressの翻訳にて訳される。日本語では「ホーム」になる。）
*/
$HSTL = get_query_var('HSTL');//テーマのメインオブジェクトの参照を受け取る。
$args = get_query_var('params');//ショートコードのパラメータ配列の参照を受け取る。
extract(shortcode_atts(array(
	'name' => 'husteCrumb',
	'mode' => 'simple',
	'home' => __('Home'),
	'type' => 'BreadCrumbList',
), $args));
$r =  '<nav class="content" name="'.$name.'" role="navigation"><ul>';
if(is_front_page()):
	//フロントページの処理
	if(is_home() && get_query_var('paged')>0):
		//複数ページがある場合にページ番号を表示する。
		$r .= '<li name="home"><a href="'.esc_url(home_url()).'"><span>'.$home.'</span></a></li>';
		$r .= '<li><span>'.__('Page', 'asama').' '.get_query_var('paged').'</span></li>';
	else:
		$r .= '<li name="home"><span>'.$home.'</span></li>';
	endif;
else:
	//フロントページ以外の処理
	//カレントページのWPオブジェクトを取得
	$que = get_queried_object();
	//JSON-LD（構造化データを記述するフォーマット）データを格納する変数
	$jsonArr = array();
	$r .= '<li name="home"><a href="'.esc_url(home_url()).'"><span>'.$home.'</span></a></li>';
	if(is_attachment()):
		//添付ファイルページ (get_queried_object()はWP_Post)
		//これって変更されている可能性を払拭するためにフックを使ってタイトル取得を初期化してるってこと、だよね？
		$pstTtl = apply_filters('the_title',$que->post_title);
		$r .= '<li><span>'.esc_html($pstTtl).'</span></li>';
	elseif(is_single()):
		//投稿ページ (get_queried_object()はWP_Post)
		$pstID = $que->ID;
		$pstTyp = $que->post_type;
		$pstTtl = apply_filters('the_title',$que->post_title);
		$theTxnm = 'category';
		//ポストタイプ処理
		if($pstTyp !== 'post'):
			//カスタム投稿タイプの処理
			$txnmys = get_object_taxonomies($pstTyp,'names');
			foreach($txnmys as $txnm):
				//最初のカテゴリーにあたるタクソノミー名を取得し代入する。 (投稿フォーマットは除く)
				if($txnm!=='post_format' && get_taxonomy($txnm)->hierarchical):
					$theTxnm = $txnm;
					break;
				endif;
			endforeach;
			if(get_post_type_object($pstTyp)->has_archive):
				$pstTypLink = esc_url(get_post_type_archive_link($pstTyp));
				$pstTypLabel = esc_html(get_post_type_object($pstTyp)->label);
				//カスタム投稿タイプ名（ラベル）の表示
				$r .= '<li><a href="'.$pstTypLink.'"><span>'.$pstTypLabel.'</span></a></li>';
				$jsonArr[] = array('id'=>$pstTypLink,'name'=>$pstTypLabel);
			endif;
		else:
			//通常投稿'post'の処理
			if(get_option('show_on_front')==='page'):
				$frntID = get_option('page_for_posts');
				if($frntID!==0) {
					$frntLink = esc_url(get_permalink($frntID));
					$frntName = esc_html(get_the_title($frntID));
					$r .= '<li><a href="'.$frntLink.'"><span>'.$frntName.'</span></a></li>';
					$jsonArr[] = array('id'=>$frntLink,'name'=>$frntName);
				}
			endif;
		endif;
		//モード処理
		switch($mode):
			case 'category':
				//カテゴリー階層を表示するモードの処理
				// 投稿に紐づくタームを全て取得
				$trms = get_the_terms($pstID, $theTxnm);
				// タクソノミーが紐づいていれば表示
				if ($trms !== false):
					//まずは投稿タイプにおける全てのアクティブタクソノミーを取得する
					if(is_plugin_active('taxonomy-terms-order/taxonomy-terms-order.php')):
						//プラグイン'Category Order and Taxonomy Terms Order'が有効化であれば、その設定した順番上位を優先して表示する。
						$prmArr = array(
							'orderby'=>'term_order',//プラグイン設定順番指定
							'hide_empty'=>true,
							'order'=>'ASC',
						);
					else:
						//通常はカテゴリーの指定件数を優先して表示する。
						$prmArr = array(
							'orderby'=>'count',
							'hide_empty'=>true,
							'order'=>'DESC',
						);
					endif;
					$txnmyTrms = get_terms($theTxnm, $prmArr);
					$topIDs = array();
					foreach($txnmyTrms as $key=>$trm):
						if($trm->parent === 0):
							$topIDs[] = $trm->term_id;
							unset($txnmyTrms[$key]);
						endif;
					endforeach;
					$prmyList = array();
					foreach($topIDs as $id):
						$arr = array($id);
						$blnk = false;
						while(!$blnk):
							$blnk = true;
							foreach($txnmyTrms as $key=>$trm):
								if(in_array($trm->parent, $arr)):
									$arr[] = $trm->term_id;
									$blnk = false;
									unset($txnmyTrms[$key]);
								endif;
							endforeach;
						endwhile;
						$prmyList[] = $arr;
					endforeach;
					//投稿タイプにおける全てのアクティブタクソノミーのリストを取得したので、本タクソノミーを調査する。
					//ここからが本番！
					$prntsList = array();//子を持つタームだけを集める配列
					$chldTerms = array();//子を持たないタームだけを集める配列
					//全タームの親IDを取得
					foreach($trms as $trm):
						if ($trm->parent !== 0 && !in_array($trm->parent, $prntsList)):
							$prntsList[] = $trm->parent;
						endif;
					endforeach;
					//親リストに含まれないタームのみ取得
					foreach($trms as $trm):
						if(!in_array($trm->term_id, $prntsList)):
							$chldTerms[] = $trm;
						endif;
					endforeach;
					//最優先リストに対して最初に適合したタクソノミーをパン屑リスト項目として利用する。
					foreach($chldTerms as $ct):
						if(in_array($ct->term_id, $prmyList[0])):
							$trm = $ct;
							break;
						endif;
					endforeach;
					if($trm->parent !== 0):
						//多階層タームの処理
						//親タームのIDリストを取得
						$prntArr = array_reverse(get_ancestors($trm->term_id, $theTxnm));
						foreach($prntArr as $prntID):
							$prntTerm = get_term($prntID,$theTxnm);
							$prntLink = esc_url(get_term_link($prntID,$theTxnm));
							$prntName = esc_html($prntTerm->name);
							$r .= '<li><a href="'.$prntLink.'"><span>'.$prntName.'</span></a></li>';
							$jsonArr[] = array('id'=>$prntLink,'name'=>$prntName);
						endforeach;
					endif;
					//($trm->parent===0)も含めた最下層タームの表示
					$trmLink = esc_url(get_term_link($trm->term_id,$theTxnm));
					$trmName = esc_html($trm->name);
					$r .= '<li><a href="'.$trmLink.'"><span>'.$trmName.'</span></a></li>';
					$jsonArr[] = array('id'=>$trmLink,'name'=>$trmName);
				endif;
			break;
			case 'simple':
			//カテゴリー階層を表記しないモードの処理
			default:
		endswitch;
		//投稿自身の表示
		$r .= '<li><span>'.esc_html(strip_tags($pstTtl)).'</span></li>';
	elseif(is_page() || is_home()):
		//固定ページ (get_queried_object()はWP_Post)
		$pstID = $que->ID;
		$pstTtl = apply_filters('the_title',$que->post_title);
		//親ページがあれば順番に表示（'post_parent'で直上親のIDが取得できる。）
		if($que->post_parent !== 0):
			$prntArr = array_reverse(get_post_ancestors($pstID));
			foreach($prntArr as $prntID):
				$prntLink = esc_url(get_permalink($prntID));
				$prntName = esc_html(get_the_title($prntID));
				$r .= '<li><a href="'.$prntLink.'"><span>'.$prntName.'</span></a></li>';
				$jsonArr[] = array('id'=>$prntLink,'name'=>$prntName);
			endforeach;
		endif;
		//ページ自身の表示
		if(is_home() && get_query_var('paged')>0):
			//複数ページがある場合にページ番号を表示する。
			$r .= '<li><a href="'.esc_url(get_permalink($pstID)).'"><span>'.esc_html(strip_tags($pstTtl)).'</span></a></li>';
			$r .= '<li><span>'.__('Page', 'asama').' '.get_query_var('paged').'</span></li>';
		else:
			$r .= '<li><span>'.esc_html(strip_tags($pstTtl)).'</span></li>';
		endif;
	elseif(is_archive()):
		if(is_post_type_archive()):
			//カスタム投稿タイプ一覧 (get_queried_object()はWP_Post_Type)
			$trmName = $que->label;
			$trmLink = esc_url(get_post_type_archive_link($que->name));
		elseif(is_date()):
			//日付による一覧 (get_queried_object()はnull)
			$Y = get_query_var('year');
			$M = get_query_var('monthnum');
			$D = get_query_var('day');
			if(is_year()):
				$trmName = $Y;
				$trmLink = esc_url(get_year_link($Y));
			elseif(is_month()):
				$trmName = $Y.'.'.$M;
				$trmLink = esc_url(get_month_link($Y,$M));
			else:
				$trmName = $Y.'.'.$M.'.'.$D;
				$trmLink = esc_url(get_day_link($Y,$M,$D));
			endif;
		elseif(is_author()):
			//投稿者による一覧 (get_queried_object()はWP_User)
			$trmName = $que->data->display_name;
			$trmLink = esc_url(get_author_posts_url($que->data->ID, $que->data->user_nicename));
		else:
			//タームによる一覧（(is_category()||is_tag()||is_tax())===true）（get_queried_object()はWP_Term)
			$trmID = $que->term_id;
			$trmName = $que->name;
			$txnmName = $que->taxonomy;
			//（注意）get_term_link()の第一パラメータを文字列'$trmName'とすると時により処理停止する。
			$trmLink = esc_url(get_term_link($trmID, $txnmName));
			//親ページがあれば順番に表示（'post_parent'で直上親のIDを取得）
			if($que->parent !== 0):
				//多階層タームの処理
				$prntArr = array_reverse(get_ancestors($trmID,$txnmName));
				foreach($prntArr as $prntID):
					$prntTerm = get_term($prntID,$txnmName);
					$prntLink = esc_url(get_term_link($prntID,$txnmName));
					$prntName = esc_html($prntTerm->name);
					if($txnmName !== 'category'):
						//'category'でないということはカスタム投稿タイプ
						$pstTyp = get_taxonomy($txnmName)->object_type[0];
						if(get_post_type_object($pstTyp)->has_archive):
							//カスタム投稿タイプの記事一覧がONの処理
							$pstTypLink = esc_url(get_post_type_archive_link($pstTyp));
							$pstTypLabel = esc_html(get_post_type_object($pstTyp)->label);
							//カスタム投稿タイプ名（ラベル）の表示
							$r .= '<li><a href="'.$pstTypLink.'"><span>'.$pstTypLabel.'</span></a></li>';
							$jsonArr[] = array('id'=>$pstTypLink,'name'=>$pstTypLabel);
						endif;
					endif;
					$r .= '<li><a href="'.$prntLink.'"><span>'.$prntName.'</span></a></li>';
					$jsonArr[] = array('id'=>$prntLink,'name'=>$prntName);
				endforeach;
			else:
				//単階層タームの処理
				$pstTyp = get_taxonomy($txnmName)->object_type[0];
				if(get_post_type_object($pstTyp)->has_archive):
					//カスタム投稿タイプの記事一覧がONの処理
					$pstTypLink = esc_url(get_post_type_archive_link($pstTyp));
					$pstTypLabel = esc_html(get_post_type_object($pstTyp)->label);
					//カスタム投稿タイプ名の表示
					$r .= '<li><a href="'.$pstTypLink.'"><span>'.$pstTypLabel.'</span></a></li>';
					$jsonArr[] = array('id'=>$pstTypLink,'name'=>$pstTypLabel);
				endif;
			endif;
		endif;
		//ターム自身の表示
		if(get_query_var('paged')>0):
			//複数ページがある場合にページ番号を表示する。
			$r .= '<li><a href="'.$trmLink.'"><span>'.esc_html($trmName).'</span></a></li>';
			$r .= '<li><span>'.__('Page', 'asama').' '.get_query_var('paged').'</span></li>';
		else:
			$r .= '<li><span>'.esc_html($trmName).'</span></li>';
		endif;
	elseif(is_search()):
		$r .= '<li><span>'.__('Search results','asama').' : '.esc_html(get_search_query()).'</span></li>';
		$r .= '<li><span>'.__('Page not found').'</span></li>';
	else:
		//その他のページ（「検索結果」と「404」の条件ではget_the_title()に返り値はない。）
		$r .= '<li><span>'.esc_html(get_the_title()).'</span></li>';
	endif;
endif;
$r .= '</ul>';
//二階層以上であれば、JSON-LDの出力する。
if(!empty($jsonArr)):
	$pos = 1;
	$json = '';
	foreach($jsonArr as $data):
	$json .= '{
		"@type":"ListItem",
		"position":'.$pos++.',
		"item":{
			"@id":"'.$data['id'].'",
			"name":"'.$data['name'].'"
		}
	},';
	endforeach;
	$r .= '<script type="application/ld+json">{
		"@context":"http://schema.org",
		"@type":"'.$type.'",
		"name":"'.$title.'",
		"url":esc_url(home_url()),
		"itemListElement":['.rtrim($json,',').']
	}</script>';
endif;
echo $r .= '</nav>';
