<?php
/**
* @package asama
* @category include/stuff
*/
//--------------------------------------------------------------------------------
// studio hustlemouse
// PHP Code 'RegistrationClass.php'
// Create : 2021.3.24
// Modify : 2025.1.24
// Author : maruhiro
// (c)maruhiro all rights reserved.
//--------------------------------------------------------------------------------
class RegistrationClass {
	private $HSTL;
	//--------------------------------------------------------------------------------
	// CONSTRUCTOR（戻り値は設定できない。）
	//--------------------------------------------------------------------------------
	public function __construct(object $obj) {$this->HSTL = $obj;}
	//自信のクラス名をマジックメソッドで返す。
	public static function who() {return __CLASS__;}
	//--------------------------------------------------------------------------------
	// INITIALIZE
	//--------------------------------------------------------------------------------
	public function init() {
		//先に読み込まれている子テーマの設定用関数を有無を確認してから参照する。
		if(function_exists('hustle_config')):
			hustle_config($this->HSTL);
		else:
			$this->HSTL->START_DATE = '2021-11-15 00:00:00';
			$this->HSTL->HUSTLE_TAGCLOUD = true;
		endif;
		add_action('after_setup_theme', array($this, 'tameTheme'));
		add_action('init', array($this, 'tameHead'));
		add_action('init', array($this, 'createPostType'));
		add_action('widgets_init', array($this, 'tameWidgets'));
		//ページ条件を拾える最初のフックは'wp'と思われる。
		add_action('wp', array($this, 'rgstPageAspects'));
		add_action('wp_enqueue_scripts', array($this, 'jugScripts'));
		//通常投稿とカスタム投稿タイプを混成する。
		add_action('pre_get_posts', array($this, 'mergePostTypes'));
		//is_plugin_activeメソッドが利用できないようであれば、有効化する。
		if(!function_exists('is_plugin_active')):
			require_once(ABSPATH.'wp-admin/includes/plugin.php');
		endif;
	}
	//--------------------------------------------------------------------------------
	// REGISTER_PAGE_MODE_&_ARCHIVES_TYPE
	//--------------------------------------------------------------------------------
	public function rgstPageAspects() {
		$this->HSTL->rgstPageAspects($this->rgstPageMode(), $this->rgstArchiveType());
	}
	public function rgstPageMode() {
		$mode = 'NONE';
		if(is_404()):
			$mode = 'E404';
		else:
			if(is_front_page() || is_home()):
				if(is_home()):
					$mode = 'HOME';
				else:
					$mode = 'FRNT';
				endif;
			elseif(is_archive()):
				$mode = 'ACHV';
			elseif(is_search()):
				$mode = 'RSLT';
			elseif(is_single()):
				$mode = 'SNGL';
			elseif(is_page()):
				$mode = 'PAGE';
			else:
				$mode = 'INDX';
			endif;
		endif;
		return $mode;
	}
	public function rgstArchiveType() {
		$atyp = 'NONE';
		if(is_archive()):
			if(is_post_type_archive()):
				//カスタム投稿タイプの一覧ページ
				$atyp = $this->HSTL->postTypeName;
			else:
				if(is_category()):
					$atyp = 'Category';
				elseif(is_tag()):
					$atyp = 'Tag';
				elseif(is_tax()):
					//'Taxonomy'という表現は分かりにくいのでカテゴリーとタグにする。
					if(get_taxonomy(get_queried_object()->taxonomy)->hierarchical):
						$atyp = 'Category';
					else:
						$atyp = 'Tag';
					endif;
					//$atyp = 'Taxonomy';
				elseif(is_date()):
					$atyp = 'Date';
				elseif(is_author()):
					$atyp = 'Author';
				elseif(is_multi_author()):
					$atyp = 'Authors';
				else:
					$atyp = 'Other';
				endif;
			endif;
		elseif(is_search()):
			$atyp = 'Searched';
		endif;
		return $atyp;
	}
	//--------------------------------------------------------------------------------
	// TAME HEAD
	//--------------------------------------------------------------------------------
	// head内のクリーニング
	public function tameHead() {
		//DNSプリフェッチ設定を出力しない。
		//add_filter('emoji_svg_url', '__return_false');
		//RSSフィードのURLリンクタグを出力しない。
		//ブログ色の強いサイトでは出力しましょう。
		//remove_action('wp_head', 'feed_links', 2);
		//(1)サイトフィードと(2)サイト全体のコメントフィード以降のフィード
		//(3)記事単位のコメントフィード(4)カテゴリーフィード(5)タグフィード(6)作成者フィード(7)検索結果
		//を出力しない。
		//remove_action('wp_head', 'feed_links_extra', 3);
		//WordPressバージョンの情報メタタグを出力しない。
		remove_action('wp_head', 'wp_generator');
		//ローカルアプリのブログ投稿ツールから更新する場合に必要なコードを出力しない。
		//Really Simple Discoveryへのリンクタグを出力しない。
		remove_action('wp_head', 'rsd_link');
		//ローカルアプリのブログ投稿ツールから更新する場合に必要なコードを出力しない。
		//Windows Live Writerへのリンクタグを出力しない。
		remove_action('wp_head', 'wlwmanifest_link');
		//現在の文書に対する「索引」であることを示す
		//indexページへのリンクタグを出力しない。
		remove_action('wp_head', 'index_rel_link' );
		//「link rel=next」等のタグ
		//複数にわたるページの分割されたページへのリンクタグを出力しない。
		//remove_action('wp_head', 'parent_post_rel_link', 10, 0);
		//remove_action('wp_head', 'start_post_rel_link', 10, 0);
		//「link rel=next」等のタグ
		//前後ページへのリンクタグを出力しない。
		//SEO的にはあってもよいかと。
		//remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
		//絵文字に対応するためのJavaScriptとCSSを読み込ませない。
		remove_action('wp_head', 'print_emoji_detection_script', 7 );
		remove_action('admin_print_scripts', 'print_emoji_detection_script' );
		remove_action('wp_print_styles', 'print_emoji_styles' );
		remove_action('admin_print_styles', 'print_emoji_styles' );
		remove_filter('the_content_feed', 'wp_staticize_emoji' );
		remove_filter('comment_text_rss', 'wp_staticize_emoji' );
		remove_filter('wp_mail', 'wp_staticize_emoji_for_email' );
		//WP5.x.xのブロックエディタ用スタイルの排除
		// wp_deregister_style('wp-block-library');
		// wp_deregister_style('wp-block-library-theme');
		//WordPressのEmbed機能を有効化するタグを出力しない。（wp-json削除）
		//remove_action('wp_head','rest_output_link_wp_head', 10);
		//URLの正規化を行なうリンクタグを出力しない。
		//SEO関連プラグインに同様の機能が備わる場合に必要かもしれない。
		//remove_action('wp_head', 'rel_canonical');
		//短縮URL「?p=投稿ID」形式のデフォルトパーマリンクタグを出力しない。
		remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0 );
		//通称ブログカード
		//外部サイトの情報をカード型で自サイトへ埋め込む事ができる機能の読込を出力しない。
		//同時に、自サイト記事を外部サイトに埋め込むことできなくなる。
		//Gutenbergの挙動が不安定になるそう。
		//remove_filter('pre_oembed_result', 'wp_filter_pre_oembed_result');
		//add_filter('embed_oembed_discover', '__return_false');
		//（wp-json削除）
		//remove_action('wp_head','wp_oembed_add_discovery_links', 10);
		//remove_action('wp_head','wp_oembed_add_host_js');
		//remove_action('template_redirect', 'rest_output_link_header', 11, 0 );
		//--------------------------------------------------------------------------------
		// SESSION START ???
		//--------------------------------------------------------------------------------
		//session_start()は、PHPが標準出力する前に実行する必要があります。
		//header.phpに記述しても良いですが、汎用を考えるとfunction.phpに書いておいた方が良いでしょう。
		/* add_action('init', function(){session_start();}); */
		//session_start();
	}
	//--------------------------------------------------------------------------------
	// JUG SCRIPT
	//--------------------------------------------------------------------------------
	public function jugScripts() {
		//--------------------------------------------------------------------------------
		// LOAD CSS
		// CSSオブジェクトをコントロールするためには、PHPにて読み込みをコントロールする必要がある。
		// 読み込みは、フォント→アニメーション→デザインの順番が好ましい。
		//--------------------------------------------------------------------------------
		$this->HSTL->UTL::enqueueStyles($this->HSTL->tugEnqueueScripts('parentStyles'));
		$this->HSTL->UTL::enqueueStyles($this->HSTL->tugEnqueueScripts('currentFonts'));
		$this->HSTL->UTL::enqueueStyles($this->HSTL->tugEnqueueScripts('currentStyles'));
		//--------------------------------------------------------------------------------
		// LOAD CONGIGURATION JAVASCRIPT
		//カレントテーマ（親テーマもしくは子テーマ）のJavaScriptを読み込む。
		//--------------------------------------------------------------------------------
		$this->HSTL->UTL::enqueueScripts($this->HSTL->tugEnqueueScripts('currentScripts'));
	}
	//--------------------------------------------------------------------------------
	// TAME THEME
	//--------------------------------------------------------------------------------
	//「add_theme_support('title-tag');」が推奨されるとのこと
	public function tameTheme() {
		add_theme_support('title-tag');//タイトルタグの出力
		add_theme_support('post-thumbnails');//アイキャッチの利用
		//add_theme_support('wp-block-styles');//ブロックエディター用基本CSSの読込	
		add_theme_support('align-wide');//全幅と幅広への利用
		add_theme_support('automatic-feed-links');//RSSフィードのURLを出力
		//--------------------------------------------------------------------------------
		// CUSTOM MENU
		register_nav_menus(array(
		'pennant_nav'=>'ペナントナビゲーション',
		'header_nav'=>'ヘッダーナビゲーション',
		'main_nav'=>'メインナビゲーション',
		'sub_nav'=>'サブナビゲーション',
		'footer_nav'=>'フッターナビゲーション',
		));
		//--------------------------------------------------------------------------------
		// LOGO MARK
		add_theme_support(
			'custom-logo',
			array(
			'width'=>300,
			'height'=>100,
			'flex-width'=>true,
			'flex-height'=>true,
			'unlink-homepage-logo'=>true,
			)
		);
		//--------------------------------------------------------------------------------
		// CUSTOM HEADER
		add_theme_support(
			'custom-header',
			array(
			'default-image'=>get_stylesheet_directory_uri().'/assets/svg/theme_header.svg',
			'random-default'=>false,
			'width'=>640,
			'height'=>320,
			'flex-height'=>true,
			'flex-width'=>true,
			'default-text-color'=>'',
			'header-text'=>true,
			'uploads'=>true,
			'wp-head-callback'=>'',
			'admin-head-callback'=>'',
			'admin-preview-callback'=>'',
			)
		);
		//デバッグモード時の「wp_enqueue_script() が誤って呼び出されました。云々…。」エラーを回避
		//【参考】https://www.geek.sc/archives/3372
		//ブロックテーマにするまでコメントアウトできないと思われる。
		remove_theme_support('widgets-block-editor');
	}
	//--------------------------------------------------------------------------------
	// TAME WIDGETS
	//--------------------------------------------------------------------------------
	public function tameWidgets() {
		register_sidebar(array(
		'name'=>'ヘッダーウィジェットカラム',
		'id'=>'widget-column-header',
		'description'=>'メインヘッダーブロッック内ウィジェットカラムで表示する内容をウィジェットで指定します。',
		'before_widget'=>'<article id="%1$s" class="widget %2$s">',
		'after_widget'=>'</article>',
		'before_title'=>'<h2 class="widget-title">',
		'after_title'=>'</h2>',
		));
		register_sidebar(array(
		'name'=>'メインウィジェットカラム',
		'id'=>'widget-column-main',
		'description'=>'メインコンテンツ内ウィジェットカラムで表示する内容をウィジェットで指定します。',
		'before_widget'=>'<article id="%1$s" class="widget %2$s">',
		'after_widget'=>'</article>',
		'before_title'=>'<h2 class="widget-title">',
		'after_title'=>'</h2>',
		));
		register_sidebar(array(
		'name'=>'フッターウィジェットカラム',
		'id'=>'widget-column-footer',
		'description'=>'メインフッターブロッック内ウィジェットカラムで表示する内容をウィジェットで指定します。',
		'before_widget'=>'<article id="%1$s" class="widget %2$s">',
		'after_widget'=>'</article>',
		'before_title'=>'<h2 class="widget-title">',
		'after_title'=>'</h2>',
		));
	}
	//--------------------------------------------------------------------------------
	// CREATE CUSTOME POST TYPE
	//--------------------------------------------------------------------------------
	public function createPostType() {
		if($this->HSTL->isHustlePostType()) {
			foreach($this->HSTL->rgstPostType as $v) {
				if(!empty($v['postHead'])) $this->HSTL->postHeads[$v['postType']] = $v['postHead'];
				else $this->HSTL->postHeads[$v['postType']] = null;
				$this->HSTL->postTypes[] = $v['postType'];
				register_post_type(
					$v['postType'],
					$v['postOptions'],
				);
			}
			foreach($this->HSTL->rgstTaxonomy as $v) {
				register_taxonomy(
					$v['txnmName'],
					$v['postType'],
					$v['txnmOptions'],
				);
			}
		}
	}
	//--------------------------------------------------------------------------------
	// MERGE POST TYPES
	//--------------------------------------------------------------------------------
	public function mergePostTypes($query) {
		//'Post Types Order'プラグインが有効化されている場合は、並べ替えを対象を'menu_order'としても複合的に指定しても掲示順に不整合があるためマージから刎ねる条件とした。
		//よって、'Post Types Order'プラグイン有効化下においてアーカイブを表示する場合は各々カスタム投稿タイプから表示する必要がある。
		if(is_admin() || !$query->is_main_query() || empty($this->HSTL->postTypes) || !$this->HSTL->isHustlePostType() || is_plugin_active('post-types-order/post-types-order.php')) return;
		if(!$query->is_search()) {
			//通常投稿とカスタム投稿タイプを混成する。
			if($query->is_front_page() && $query->is_home()) {
				//ホームページが「投稿ページ」に設定されている場合
				$query->set('post_type', array_merge(['post'],$this->HSTL->postTypes));
			} elseif($query->is_author() || $query->is_date()) {
				//投稿者と日付のアーカイブの場合
				$query->set('post_type', array_merge(['post'],$this->HSTL->postTypes));
			}
		}
	}
}