<?php
/**
* @package asama
* @category include/tool
*/
//--------------------------------------------------------------------------------
// studio hustlemouse
// PHP Code 'UtilityClass.php'
// Create : 2021.11.26
// Modify : 2023.8.24
// Author : maruhiro
// (c)maruhiro all rights reserved.
//--------------------------------------------------------------------------------
class UtilityClass {
	//自信のクラス名をマジックメソッドで返す。
	public static function who() {return __CLASS__;}
	//--------------------------------------------------------------------------------
	// CHECK CURRENT PAGE
	//--------------------------------------------------------------------------------
	//Syntax:objectName.isBlogPage();
	//Parameter:なし
	//Return:真偽値
	//Reference:ブログページを開いていることを判定する。
	public static function isBlogPage() {
		//return in_array($GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php'), true);
		return in_array($GLOBALS['pagenow'], array('index.php'), true);
	}
	//--------------------------------------------------------------------------------
	// ECHO
	//--------------------------------------------------------------------------------
	//Syntax:objectName.echoo($str);
	//Parameter:'$str'は文字列
	//Return:なし
	//Reference:ログをブラウザコンソールに出力する。PHPのechoと表現が被って気持ち悪いので2023年8月24日に'o'をひとつ増やした。
	//public static function echo($str) {self::echoo($str);}
	public static function echoo($str) {
		//ログインページや管理画面では動作しないようにする。
		if(!is_admin() && self::isBlogPage()) {
			$str = 'echo_PHP_>'.$str;
			//【コメントアウトをしておく】必要に応じて利用すること！
			//【回避不可その１】投稿編集画面でタグ、カテゴリー、アイキャッチ画像の設定項目が消える。
			//【回避不可その２】投稿編集画面のHTMLソースの<!DOCTYPE html>が出力されない。
			//echo '<script>console.log('.json_encode($str).')</script>';
		}
	}
	//--------------------------------------------------------------------------------
	// ENQUEUE SCRIPTS
	//--------------------------------------------------------------------------------
	//Syntax:objectName.enqueueStyles($arr);
	//Parameter:'$arr'は連想配列
	//Return:なし
	//Reference:連想配列のタイトルとURLのリストからスタイルファイルを’を読み込む。
	public static function enqueueStyles($arr) {
		foreach($arr as $k=>$v) {
			wp_enqueue_style($k, $v, array(), false, 'all');
		}
	}
	//Syntax:objectName.addEditorStyles($arr);
	//Parameter:'$arr'は連想配列
	//Return:なし
	//Reference:連想配列のタイトルとURLのリストから投稿画面用スタイルファイルを読み込む。
	//Reference:'admin_init'をフックにした場合はadd_editor_style()で読み込む必要がある。
	/* public static function addEditorStyles($arr) {
		foreach($arr as $k=>$v) {
			add_editor_style($v);
			self::echoo("ADD_EDITOR_STYLE_>{$v}");
		}
	} */
	//Syntax:objectName.enqueueScripts($arr);
	//Parameter:'$arr'は連想配列
	//Return:なし
	//Reference:連想配列のタイトルとURLのリストからスクリプトファイルを読み込む。
	public static function enqueueScripts($arr) {
		foreach($arr as $k=>$v) {
			wp_enqueue_script($k, $v, array(), false, true);
		}
	}
	//--------------------------------------------------------------------------------
	// STRING ENCODE TO HTML
	//--------------------------------------------------------------------------------
	//Syntax:objectName.str2html($str);
	//Parameter:'$str'は文字列
	//Return:文字列
	//Reference:HTMLタグ(例：&、"、'、<、>)などに使われるHTML特殊文字をエンティティ(例：＆amp;、＆quot;、&apos;、&lt;、＆gt;）に変換する。
	public static function str2html(string $str):string {
		return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
	}
	//--------------------------------------------------------------------------------
	// IMAGE SIZE
	//--------------------------------------------------------------------------------
	//Syntax:objectName.pickImgSize($id, $size);
	//Parameter:'$id'はメディアに登録された画像のID
	//Parameter:'$size'は画像の取扱サイズ（'thumbnail','medium','large','full'など）で初期値は'full'
	//Return:文字列
	//Reference:指定サイズに対してURLが返ってこない場合は準備のある近似の大きい方の画像サイズ指定の文字列に変更して返す。
	public static function pickImgSize($id, $size='full'){
		//添付ファイルのメタデータを取得
		$meta = wp_get_attachment_metadata($id);
		//メタデータが存在するか確認
		if($meta) {
			$r = $size;
			//生成されたサイズのリストを取得
			$szs = array_keys($meta['sizes']);
			if(!in_array($size,$szs)) {
				switch($size) {
					case 'thumbnail':
						$r = 'medium';
						if(in_array($r,$szs)) break;
					case 'medium':
						$r = 'large';
						if(in_array($r,$szs)) break;
					case 'large':
						$r = 'full';
						if(in_array($r,$szs)) break;
					case 'full':
					default:
						$r = 'full';
				}
			}
		}
		return $r;
	}
	//Syntax:objectName.getThumbWH($id, $size='full');
	//Parameter:'$id'はメディアに登録された画像のID
	//Parameter:'$size'は画像の取扱サイズ（'thumbnail','medium','large','full'など）で初期値は'full'
	//Return:配列
	//Reference:当該画像のサイズを配列[w=>Width, h=>Height]にて返す。
	public static function getThumbWH($id, $size='full'){
		return self::getImageWH(get_the_post_thumbnail_url($id, $size));
	}
	//Syntax:objectName.getImageWH($img_url);
	//Parameter:'$img_url'は当該画像のURL
	//Return:配列
	//Reference:当該画像のサイズを配列[w=>Width, h=>Height]にて返す。
	public static function getImageWH($img_url){
		//wp-contentディレクトリのパス：/var/www/html/example/wp-content
		$wp_content_dir = WP_CONTENT_DIR;
		//wp-contentディレクトリのURL：http://www.example.com/wp-content
		$wp_content_url = content_url();
		//URLをローカルパスに置換
		$img_path = str_replace($wp_content_url, $wp_content_dir, $img_url);
		//画像サイズを取得
		/* Array(
			[0]=>(int),
			[1]=>(int),
			[2]=>(int),
			[3]=>(string : width="XXX" height="XXX"),
			[bits]=>(int),
			[mime]=>(string : MIME),
			[channel]=>(int : RGB=3, CMYK=4),
		) */
		$img_size = getimagesize($img_path);
		if($img_size) {
			return array('w'=>$img_size[0],'h'=>$img_size[1],);
		} else {
			//$img_sizeがオブジェクトでなければ対象外（SVGなど）なのでnullを返す。
			return null;
		}
	}
	//Syntax:objectName.getAsamaThumbImgPrp($index, $type='');
	//Parameter:'$index'はクラス指定の判定に利用する画像縦横比の指数
	//Parameter:'$type'は画像の利用形態のキーワード
	//Parameter:'$imgSz'は画像サイズのキーワード
	//Parameter:'$ar'はアスペクト比（aspect_ratio）
	//Return:配列
	//Reference:処理結果を[n=>指定クラス名, v=>CSSプロパティーの値]にて返す。
	public static function getAsamaThumbImgPrp($index, $type='', $imgSz='full', $ar=0) {
		$id = $index;
		$ar = 0;//aspect_ratio
		$nm = 'fix';
		$vlu = 100;
		switch($type) {
			//case 'icon':
			case 'thmb':
				$size = self::getThumbWH(get_the_ID(), $imgSz);
				if($size !== null) {
					$ar = $size['h']/$size['w'];
					$nm = $ar>$id?'fiy':'fix';
					$vlu = $ar>$id?((($ar>1?(1-$id):((1-$ar)/(1-$id)*(1-$id)/$id+(1-$id)))/$id)*100):100;
				}
				break;
			case 'single-head':
				$size = self::getThumbWH(get_the_ID(), $imgSz);
				if($size !== null) {
					$ar = $size['h']/$size['w'];
					$nm = $ar>$id?'fiy':'fix';
					$vlu = $ar>$id?($ar>($id*2)?50:($id*100)):100;
				}
				break;
			default:
				$size = self::getThumbWH(get_the_ID(), $imgSz);
				if($size !== null) {
					$ar = $size['h']/$size['w'];
					$nm = $ar>$id?'fiy':'fix';
					$vlu = $ar>$id?(($ar>1?(1-$id):((1-$ar)/(1-$id)*$id+(1-$id)))*100):100;
				}
		}
		return ['n'=>$nm,'v'=>$vlu.'%',];
	}
}