/****************************************************************
studio hustlemouse
JavaScript Code 'hustleBrowserUtilityModule'
Author MARUHIRO
Create:2021.1.30
Modify:2023.12.26
(c)maruhiro. All rights reserved.
Special Thanks
Sato Yutaro, Miguel Sanchez
****************************************************************/
//----------------------------------------------------------------
// OUTLINE
//----------------------------------------------------------------
// [CONSTRACTOR]
// *constructor()

// [STATIC MTHODS]
// *getInnerSize({})

// ORGANIZE COOKIE（未検証）
//----------------------------------------------------------------
// *putCookie({})
// *getCookie({})

// ORGANIZE WEB STORAGE
//----------------------------------------------------------------
// *createWS({})
// *setDataWS({})
// *getValueWS({})
// *delValueWS({})
// *clearWS({})
// *getListWS({})

// LOAD XML UNSYNCRONIZATION
//----------------------------------------------------------------
// *letLoadXML({})
// *createHTTP({})
// *openGetHTTP({})

// FILE API
//----------------------------------------------------------------
// *availableFileApi({})
// *letLoadFile({})
// *doLoadFile({})

// EXEC COPY
//----------------------------------------------------------------
// *execCPY({})

// CREATE EMAIL
//----------------------------------------------------------------
// *createEMAIL({})
//----------------------------------------------------------------
export default class hustleBrowserUtilityModule {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//----------------------------------------------------------------
	constructor() {}
//----------------------------------------------------------------
// GET WINDOW INFORMATION
//----------------------------------------------------------------
	// GET INNER SIZE
	//----------------------------------------------------------------
	//Syntax:objectName.getInnerSize({obj});
	//Parameter:'obj'はウインドウオブジェクト
	//Return:配列
	//Reference:ウインドウオブジェクトの内側のサイズ情報を配列にまとめて返す。
	static getInnerSize({obj}) {
		let r = new Array();
		//iPhoneでもiPadでも縦正位置だとwindow.orientationの値が0になりfalseになるので条件とした。
		if ('orientation' in obj) {
			//if(obj.orientation || hustle.RG.IOS) {
			if (Math.abs(obj.orientation / 90) !== 1) {
				//hustle.echo('BROWSER_UTL', 'WINDOW_ROTATED_VERTICAL_'+obj.orientation+'_'+obj.innerWidth+'_'+obj.innerHeight);
				if (obj.innerWidth > obj.innerHeight) {
					r = [obj.innerHeight, obj.innerWidth];
				} else {
					r = [obj.innerWidth, obj.innerHeight];
				}
			} else {
				//hustle.echo('BROWSER_UTL', 'WINDOW_ROTATED_HORIZONTAL_'+obj.orientation+'_'+obj.innerWidth+'_'+obj.innerHeight);
				if (obj.innerWidth > obj.innerHeight) {
					r = [obj.innerWidth, obj.innerHeight];
				} else {
					r = [obj.innerHeight, obj.innerWidth];
				}
			}
		} else {
			//hustle.echo('BROWSER_UTL', 'WINDOW_SIZE_'+obj.innerWidth+'_'+obj.innerHeight);
			r = [obj.innerWidth, obj.innerHeight];
		}
		return r;
	}
//----------------------------------------------------------------
// ORGANIZE COOKIE（未検証）
//----------------------------------------------------------------
	//Syntax:objectName.putCookie({vlu, dys, n});
	//Parameter:'vlu'はCookieに格納する値
	//Parameter:'dys'はCookieの保管期限日数
	//Parameter:'n'はCookieの名前
	//Reference:Cookieに情報を格納する
	static putCookie({vlu, dys, n}) {
		let exp = '';
		if (dys) {
			const date = new Date();
			date.setTime(date.getTime() + (dys * 24 * 60 * 60 * 1000));
			exp = ';expires=' + date.toGMTString();
		}
		document.cookie = n + '=' + vlu + exp + ';path=/';
	}
	//----------------------------------------------------------------
	//Syntax:objectName.getCookie({n});
	//Parameter:'n'はCookieの名前
	//Reference:Cookieの情報を取得する
	static getCookie({n}) {
		//window.alert('COOKIE_'+document.cookie);
		n = n + '=';
		const cookieList = document.cookie.split(';');
		if (cookieList[0].length > 0) {
			for (let i = 0; i < cookieList.length; i++) {
				if (cookieList[i].lastIndexOf(n) > -1) {
					return cookieList[i].substring(cookieList[i].lastIndexOf(n) + n.length, cookieList[i].length);
				}
			}
		}
		return null;
	}
//----------------------------------------------------------------
// ORGANIZE WEB STORAGE
//----------------------------------------------------------------
	// CREATE STORAGE
	//----------------------------------------------------------------
	//static createWS({typ}) {
	static createWS() {
		let ws = null;
		//hustle.echo('BROWSER_UTL', `ORDERED_STRAGE_TYPE_>${typ}`);
		if('localStorage' in window) {
			ws = window.localStorage;
		} else if ('sessionStorage' in window) {
			ws = window.sessionStorage;
		}
		/*if(ws !== null) {
			//IEのみ対応
			window.addEventListener('storage', this.eventWS, false);
		}*/
		return ws;
	}
	// EVENT OF STORAGE（IEのみ対応）
	//----------------------------------------------------------------
	/*this.eventWS = function(e) {
		hustle.echo('BROWSER_UTL', 'WebStorage event ocued.');
		e.key;
		e.oldValue;
		e.newValue;
		e.url;
		e.storageArea;
	}*/
	// SET DATA
	//----------------------------------------------------------------
	static setDataWS({key, vlu, ws}) {ws.setItem(key, vlu);}
	// GET VALUE
	//----------------------------------------------------------------
	static getValueWS({key, ws}) {return ws.getItem(key);}
	// REMOVE VALUE
	//----------------------------------------------------------------
	static delValueWS({key, ws}) {ws.removeItem(key);}
	// CLEAR STORAGE
	//----------------------------------------------------------------
	static clearWS({ws}) {ws.clear();}
	// GET DATA ARRAY
	//----------------------------------------------------------------
	static getListWS({ws}) {
		const r = new Array();
		for (let i = 0; i < ws.length; i++) {
			r[i] = [ws.key(i), ws.getItem(ws.key(i))];
		}
		return r;
	}
//----------------------------------------------------------------
// LOAD XML UNSYNCRONIZATION
//----------------------------------------------------------------
	// LET LOADING XML
	//----------------------------------------------------------------
	//Syntax:objectName.letLoadXML({fn, url});
	//Parameter:"fn"はオーダー元が指定の返答先メソッド
	//Parameter:"url"はXMLファイルの参照先
	//Return:なし
	//Reference:XMLファイルを読み込みを開始する。直接の返り値がないのでthenで受ける必要はない。
	static async letLoadXML({fn, url}) {
		let req = null;
		const typ = 'text/xml';//'text/plain'
		try {
			req = await this.createHTTP();
			this.openGetHTTP({fn, url, typ, req});
		} catch(e) {
			hustle.echo('ERROR', `CATCH_>${e.message}`);
		}
	}
	// CREATTE XML HTTP REQUEST
	//----------------------------------------------------------------
	//Syntax:objectName.createHTTP();
	//Parameter:なし
	//Return:XMLHttpRequestオブジェクト
	//Reference:XMLHttpRequestオブジェクトを生成して返す。
	static createHTTP() {
		if (window.XMLHttpRequest) {
			return new XMLHttpRequest();//IE以外
		} else if (window.ActiveXObject) {
			//IE(バージョンにより異なる)
			try {
				return new ActiveXObject("Msxml2.XMLHTTP");
			} catch (e) {
				try {
					return new ActiveXObject("Microsoft.XMLHTTP");
				} catch (e) {
					throw new Error(`XML_REQUEST_HAS_NOT_CREATED.`);
				}
			}
		} else {
			throw new Error(`XML_REQUEST_HAS_NOT_CREATED.`);
		}
	}
	// OPEN HTTP REQUEST
	//----------------------------------------------------------------
	//Syntax:objectName.openGetHTTP({fn, url, req});
	//Parameter:"fn"はオーダー元が指定の返答先メソッド
	//Parameter:"url"はXMLファイルの参照先
	//Parameter:"typ"はファイルのタイプ
	//Parameter:"req"はXMLHttpRequestオブジェクト
	//Return:なし
	//Reference:XMLHttpRequestオブジェクトに非同期でXMLを読み込みを開始する。
	//static openHTTP({fn, url, req}) {
	static openGetHTTP({fn, url, typ, req}) {
		if (req) {
			//指定URLに非同期'GET'で接続
			req.open('GET', url, true);
			req.overrideMimeType(typ);
			//onreadystatechangeは、呼び込み状況毎に呼び出される。
			req.onreadystatechange = () => {
				//readyStateで読み込み終了を確認したらXMLHttpRequestオブジェクトを返す。
				if(req.readyState===4) return fn(req);
			}
			//準備後にHTTPリクエストを送信
			req.send(null);
		} else {
			throw new Error(`XML_REQUEST_HAS_NOT_OPENED.`);
		}
	}
	// PARSE DOM
	//----------------------------------------------------------------
	//Syntax:objectName.parseDOM({src}});
	//Parameter:'src'はXMLのテキストソース
	//Return:Documentオブジェクト
	//Reference:XMLやHTMLソースコードを文字列からDOMのDocumentに解釈する。
	//static parseXML(src) {
	static parseDOM({src}) {
		try {
			//hustle.echo('ERROR', `ERROR_TARGET_>${src}`);
			const p = new window.DOMParser();
			const r = p.parseFromString(src , 'text/xml');
			if(r.getElementsByTagName('parsererror').length > 0) {
				//hustle.echo('ERROR', `ERROR_>${r}_TEST_>${r.getElementsByTagName('parsererror').length}`);
				throw new Error(`It is not a XML TEXT file._>${r}`);
				//r instanceof XMLDocument
			}
			return r;
		} catch(e) {
			hustle.echo('ERROR', `CATCH_>${e.message}`);
		}
	}
//----------------------------------------------------------------
// FETCH API
//----------------------------------------------------------------
static fetGetXML({fn, url}) {
	const typ = 'text/xml';
	const heds = new Headers();
	heds.append('Content-Type', typ);
	heds.append('Accept', 'application/xml, text/xml, */*; q=0.01');
	const req = new Request(url, {
		method:'GET',//リクエストのメソッド (既定:GET)
		//body:body,//リクエストに関連付けられたボディ（GETやHEADでは本体を持てない。）
		headers:heds,//リクエストに関連付けられたHeadersオブジェクト
		mode:'cors',//リクエストのモード (既定:cors, no-cors, same-origin, navigate など) 
		cache:'default'//リクエストのキャッシュモード (default, reload, no-cache など) 
	});
	this.fetch({fn, req, typ});
}
static async fetch({fn, req, typ}) {
	/* fetch(req).then(rsp=>{
		return rsp.json();
	}).then(r=>{
		const txt = JSON.stringify(r, null, '');
		hustle.echo('FETCH', `SUCCESS_>${txt}`);
	}).catch(e=>{
		hustle.echo('ERROR', `FETCH_>${e}`);
	}) */
	try {
		const rsp = await fetch(req);
		if(!rsp.ok) {
			throw new Error(`HTTP_ERROR_>${rsp.status}`);
		} else {
			//hustle.echo('FETCH', `RESPONCE_URL_>'${rsp.url}'_STATUS_>'${rsp.status}'_OK_>'${rsp.ok}'_STATUSTEXT_>'${rsp.statusText}'`);
			//hustle.echo('DIR', `FETCH_FETCHRESPONCE_HEADERS_&_BODY`, rsp.headers, rsp.body);
			let r = null;
			switch(typ) {
				case 'text/xml':
				case 'text/plain':
				case 'text/csv':
				case 'text/tab-separated-values':
					r = await rsp.text();
					break;
				case 'application/vnd.ms-excel':
					break;
				case 'application/json':
					r = await rsp.json();
					//JSONはそのまま返していいんでないか？
					r = JSON.stringify(r, null, '');
					break;
				default:
					break;
				//他のインスタンスメソッド
				//rsp.arrayBuffer()
				//rsp.blob()
				//rsp.bytes()
				//rsp.clone()
				//rsp.formData()
			}
			if(fn===null) {
				hustle.echo('FETCH', `SUCCESS_>${r}`);
			} else {
				switch(typ) {
					case 'text/xml':
						//XMLはテキストとして取得されるのでパースして返す。
						fn(this.parseDOM({src:r}));
						break;
					case 'text/plain':
					case 'text/csv':
					case 'text/tab-separated-values':
						fn(r);
						break;
					case 'application/vnd.ms-excel':
						break;
					case 'application/json':
						fn(r);
						break;
					default:
						break;
				}
			}
		}
	} catch(e) {
		hustle.echo('ERROR', `FETCH_CATCH_>${e.message}`);
	}
}
//----------------------------------------------------------------
// FILE API
//----------------------------------------------------------------
	// CHECK FILE API
	//----------------------------------------------------------------
	static availableFileApi() {
		// ブラウザが File API に完全に対応しているかを返す
		return (window.File && window.FileReader && window.FileList && window.Blob);
	}
	// FILE OPTIONS
	//----------------------------------------------------------------
	static fileOptions({h, t, es}) {
		//const opts = {types:[{description:'Text files',accept:{'text/plain':['.txt']},}],};
		return {types:[{description:h,accept:{t:es},}],};
	}
	// READ FILE（未完成）
	//----------------------------------------------------------------
	//Syntax:objectName.letLoadFile({fn, f, code});
	//Parameter:'fn'はオーダー元が指定の返答先メソッド
	//Parameter:'f'はFileの単一オブジェクト（Blobオブジェクトでも良い？）
	//Parameter:'code'は読み込みテキストの文字コード
	//Return:なし
	//Reference:FileReaderオブジェクトに非同期？でFileを読み込むメソッド。
	//Reference:１ファイルの読み込みを行う。
	static letLoadFile({fn, f, code}) {
		let rdr = null;
		try {
			rdr = new FileReader();
			//maruhiro 20210105 (Special Thanks for 'Sato Yutaro')
			hustle.echo('BROWSER_UTL', `BU_FILES_TYPE_>${f.type}_CODE_>${code}`);
			switch (f.type) {
				/*case 'application/json':
					break;*/
				case 'text/plain'://'.txt'
				case 'text/csv'://'.csv'
				case 'text/tab-separated-values'://'.txtと.tsv'
				case 'application/vnd.ms-excel'://'.csv'
				default://'.tsv'のファイルはtypが空で帰ってくる環境（Win/FireFox）があるので注意（20210106）
					rdr.readAsText(f, code);
			}
			if(rdr === null) throw new Error(`FAILED LOAD A FILE.`);
		} catch(e) {
			hustle.echo('ERROR', `CATCH_>${e.message}`);
		}
		//maruhiro 20210106 (Special Thanks for 'Miguel Sanchez')
		//非同期なのでFileReaderオブジェクトにテキスト情報指定前だと先にイベントが発生する可能性がある思ったのでイベントリスナーを一番最後に持ってきた。当たり前っちゃあたりまえ。
		//rdr.addEventListener('load', e=>fn(e), false);
		rdr.addEventListener('load', fn, false);
	}
	//Syntax:objectName.doLoadFile({fn, f, code});
	//Parameter:"fn"はオーダー元が指定の返答先メソッド
	//Parameter:"f"はFileの単一オブジェクト（Blobオブジェクトでも良い？）
	//Parameter:"code"は読み込みテキストの文字コード
	//Return:なし
	//Reference:FileReaderオブジェクトに非同期？でFileを読み込むメソッド。
	//Reference:１ファイルの読み込みを行う。
	/* static doLoadFile({fn, f, code}) {
		let rdr = new FileReader();
		//maruhiro 20210105 (Special Thanks for 'Sato Yutaro')
		hustle.echo('BROWSER_UTL', `BU_FILES_TYPE_>${f.type}_CODE_>${code}`);
		switch (f.type) {
			case 'text/plain'://'.txt'
			case 'text/csv'://'.csv'
			case 'text/tab-separated-values'://'.txtと.tsv'
			case 'application/vnd.ms-excel'://'.csv'
			default://'.tsv'のファイルはtypが空で帰ってくる環境（Win/FireFox）があるので注意（20210106）
				rdr.readAsText(f, code);
		}
		//maruhiro 20210106 (Special Thanks for 'Miguel Sanchez')
		//非同期なのでFileReaderオブジェクトにテキスト情報指定前だと先にイベントが発生する可能性がある思ったのでイベントリスナーを一番最後に持ってきた。当たり前っちゃあたりまえ。
		rdr.addEventListener('load', e => fn(e), false);
	} */
	// SAVE FILE これはまだ使えないよ。（20210503）
	// https://qiita.com/pentamania/items/ada07c45d4e5cc139c03
	//----------------------------------------------------------------
	static letSaveFile({src}) {
		//const opt = {h:'Text files', t:'text/plain', es:['.txt']};
		//let h = await window.showSaveFilePicker(this.fileOptions({h:opt.h, t:opt.t, es:opt.es}));//FileSystemFileHandleオブジェクト
		this.doSaveFile({h, src});
	}
	static async doSaveFile({h, src}) {
		const w = await h.createWritable();
		await w.write(src);
		await w.close();
	}
//----------------------------------------------------------------
// DOWNLOAD FILE
// https://qiita.com/wadahiro/items/eb50ac6bbe2e18cf8813
//----------------------------------------------------------------
	//Syntax:objectName.letDownload({src, ps, obj});
	//Parameter:'src'はダウンロードするコンテンツソース
	//Parameter:'ps'はパラメータを格納したオブジェクト
	//Parameter:'ps.bom'はBOM付きにするかの真偽値
	//Parameter:'ps.type'はファイルタイプ指定の文字列
	//Parameter:'ps.name'はダウンロードファイル名
	//Parameter:'obj'はアンカータグエレメントオブジェクト
	//Return:なし
	//Reference:ファイルのダウンロードを開始する。直接の返り値がないのでthenで受ける必要はない。
	static async letDownload({src, ps, obj}) {
		const bom = ps.bom? new Uint8Array([0xEF, 0xBB, 0xBF]) : [];
		const blob = new Blob([bom, src], {'type':ps.type});
		obj.href = window.URL.createObjectURL(blob);
		hustle.PU.setATBT({vlu:ps.name, atr:'download', obj});
		await obj.click();
		window.URL.revokeObjectURL(obj.href);//オブジェクトURLを解放
	}
//----------------------------------------------------------------
// EXEC COPY
// https://qiita.com/simiraaaa/items/2e7478d72f365aa48356
//----------------------------------------------------------------
	static execCOPY({src}) {
		const elm = document.createElement('div');
		elm.appendChild(document.createElement('pre')).innerText = src;//textContentも可
		elm.style.position = 'fixed';
		elm.style.left = '-200%';
		document.body.appendChild(elm);
		document.getSelection().selectAllChildren(elm);
		//const r = document.execCommand('copy');
		const r = navigator.clipboard.writeText('copy');
		document.body.removeChild(elm);
		// trueなら実行できている、falseなら失敗か対応していないか。
		return r;
	}
//----------------------------------------------------------------
// CREATE EMAIL
// https://qiita.com/tnakagawa/items/b4a4160f13fcbcf66f83
//----------------------------------------------------------------
	static createEMAIL({src, sub, to}) {
		window.location.href = 'mailto:?to=' + encodeURIComponent(to) + '&subject=' + encodeURIComponent(sub) + '&body=' + encodeURIComponent(src);
	}
}
