/*************************************************************
studio hustlemouse
Javascript Code 'hustleWireFrameUtilityModule'
Create : 2022.5.15
Modify : 2023.12.26
Author : maruhiro
(c)maruhiro. All rights reserved.
*************************************************************/
export default class hustleWireFrameUtilityModule {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//----------------------------------------------------------------
	constructor() {}
//----------------------------------------------------------------
// PUT ELEMENT INFORMETION FOR 'asama'
//----------------------------------------------------------------
	static examElms({atrs,ins,obj}) {
		if(obj instanceof Element) this.instCntToOneElm({str:this.getElementInfo({atrs,obj}),ins,obj});
		else {
			if(obj.length > 0) this.examAndDigNodes({atrs,ins,obj});
		}
	}
	static examAndDigNodes({atrs,ins,obj}) {
		obj.forEach((vl, id, ar)=>{
			if(vl instanceof Element) {
				switch(vl.tagName) {
					case 'STYLE':
					case 'SCRIPT':
					case 'SVG':
					case 'LINK':
					case 'IMG':
					case 'BR':
					case 'INS':
					case 'SELECT':
					case 'METER':
					case 'PROGRESS':
						break;
					case 'INPUT':
					case 'TEXTAREA':
						vl.setAttribute('placeholder', this.getElementInfo({atrs,obj:vl}),ins,vl);
						break;
					case 'DIV':
						const s = hustle.PU.ATBT({atr:'id', obj:vl});
						if(s !== null) {
							if(s.indexOf('hustleAnalyzeBox') !== -1 || s.indexOf('wpadminbar') !== -1 || s.indexOf('fancybox-') !== -1 || s.indexOf('whiteBoard') !== -1 || s.indexOf('workingAnim') !== -1) break;
						}
					default:
						this.instCntToOneElm({str:this.getElementInfo({atrs,obj:vl}),ins,obj:vl});
						let b = false;
						switch(vl.tagName) {
							case 'IFRAME':
							case 'TABLE':
								break;
							case 'DIV':
								const s = hustle.PU.ATBT({atr:'id', obj:vl});
								if(!(s !== null && s.indexOf('sb_instagram') !== -1)) b = true;
								break;
							default:
								b = true;
						}
						if(b) {
							const cnl = this.refineNL({obj:vl.childNodes});
							if(cnl.length > 0) this.examAndDigNodes({atrs,ins,obj:cnl});
						}
				}
			}
		});
	}
	static refineNL({obj}) {
		const r = new Array();
		obj.forEach((vl,id,ar)=>(vl instanceof Element)?r.push(vl):null);
		return r;
	}
	//Parameter:'ins'は'before'=>要素内先頭、'after'=>要素内末尾
	static instCntToOneElm({str, ins, obj}) {
		const s = hustle.PU.ATBT({atr:'class', obj});
		if(!(s !== null && s.indexOf('elementInformation') !== -1)) {
			let el;
			if(obj.tagName === 'SPAN' || obj.tagName === 'A' || obj.tagName === 'P') {
				el = hustle.PU.CREATE({clss:'elementInformation',tag:'span'})
			} else {
				el = hustle.PU.CREATE({clss:'elementInformation',tag:'p'})
			}
			el.innerText = str;
			switch(ins) {
				case 'before':
					obj.prepend(el);
					break;
				case 'after':
					obj.append(el);
					break;
				default:
					obj.appendChild(el);
			}
		}
	}
	static getElementInfo({atrs, obj}) {
		let r = 'TAG="' + obj.tagName + '"';
		atrs.forEach((vl,id,ar)=>{
			const s = hustle.PU.ATBT({atr:vl, obj});
			if(s !== null) r += '_' + vl + '="' + s + '"';
		});
		return r;
	}
}