/****************************************************************
studio hustlemouse
JavaScript Code 'MainClass'
Author MARUHIRO
Create:2020.8.17
Modify:2025.1.13
(c)maruhiro all rights reserved.
****************************************************************/
//----------------------------------------------------------------
// OUTLINE
//----------------------------------------------------------------
// [FIELDS]
// *RG
// *BODY
// *DILAY
// *scrollA
// *scrlInterval
// *RszMng
// *MnMnMng
// *ScrlArwMng
// *FGRs
// *TRGs
// *gMapIndexs
// *srcGoogleMaps
// [METHODS]
// *constructor()
// *init()
// *setContent()
// *reset()
// *onWindowScroll()
// *onWindowResize()
// *initDoupImg()
// *letDoupImg()
// *initGoogleMaps()
// *letGoogleMaps()
// *doGoogleMaps()
//----------------------------------------------------------------
class MainClass {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//Syntax:this.objectName = new MainClass();
	//Parameter:obj'はRegistrationClassオブジェクト
	//Return:なし
	constructor(obj) {
		this.RG = obj;
		this.BODY;
		//本コンテンツ特有の描画処理を呼び出す間隔（1ms = 1/1000秒）
		this.DILAY = 40;//整数'40'であれば'40/1000秒'で25fps（フレームパーセコンド）になる。
		//"scrollA"は速度指定で、0から1までの数値を指定する。
		//"scrollA"を1にすると通常のジャンプと同じになる。
		this.scrollA = 0.25;//0.5*0.5
		//----------------------------------------------------------------
		this.scrlInterval;
		this.RszMng;
		this.MnMnMng;
		this.ScrlArwMng;
		//----------------------------------------------------------------
		this.FGRs;
		this.TRGs;
		//----------------------------------------------------------------
		//GOOGLE MAPS CONFIG
		this.gMapIndexs;
		this.srcGoogleMaps;
	}
	init() {
		hustle.PU.VIZ({b:false, obj:hustle.PU.ID({id:'whiteBoard'})});
		this.BODY = hustle.PU.TAG({tag:'body'})[0];
		const obj = hustle.PU.QSELECT({slc:`section[name='MainMenuFlop']`});
		this.RszMng = new ResizeManagerClass(this);
		this.MnMnMng = new MainMenuManagerClass(this);
		this.ScrlArwMng = new ScrollArrowManagerClass(this);
		this.RszMng.init();
		this.MnMnMng.init();
		this.ScrlArwMng.init();
		this.initDoupImg();
		this.setContent();
		this.initGoogleMaps();
		this.reset();
		hustle.PU.VIZ({b:false, obj:hustle.PU.ID({id:'workingAnim'})});
	}
	setContent() {
		this.MnMnMng.setContent();
		this.ScrlArwMng.setContent();
		if(hustle.RG.IOS) {
			window.addEventListener('orientationchange', e => this.onWindowResize(e), false);
		} else {
			window.addEventListener('resize', e => this.onWindowResize(e), false);
			window.addEventListener('scroll', e => this.onWindowScroll(e), false);
		}
	}
	reset() {
		this.RszMng.letResize(null);
		this.RszMng.letScroll(null);
	}
	//----------------------------------------------------------------
	// EVENT RECEIVER
	onWindowScroll(e) {
		this.RszMng.letScroll(e);
	}
	onWindowResize(e) {
		this.RszMng.letResize(e);
		this.ScrlArwMng.resetScrollto();
	}
//----------------------------------------------------------------
// DO-UP IMAGES METHODS
	initDoupImg() {
		this.FGRs = hustle.PU.CLASS({cls:'wp-block-image'});
		this.TRGs = new Array();
		for(let obj of this.FGRs) {
			const dup = hustle.PU.CLASS({cls:'dup', obj})[0];
			if(dup instanceof Element) this.TRGs.push({dup, img:hustle.PU.TAG({tag:'img', obj})[0]});
		}
	}
	letDoupImg() {
		if(!this.TRGs.length) return;
		const inWH = hustle.BU.getInnerSize({obj:window});
		for(let obj of this.TRGs) {
			obj['img'].style['width'] = '100%';
			obj['img'].style['height'] = 'auto';
			const DR = hustle.PU.RECT({obj:obj['dup']});
			const IR = hustle.PU.RECT({obj:obj['img']});
			if(DR.h >= IR.h) {
				obj['img'].style['width'] = 'auto';
				obj['img'].style['height'] = `${DR.h}px`;
				IR = hustle.PU.RECT({obj:obj['img']});
				const l = (DR.w - IR.w) * DR.y / (inWH[1] - DR.h);
				if(l <= 0 && l >= DR.w - IR.w) {
					obj['img'].style['top'] = '0px';
					obj['img'].style['left'] = `${l}px`;
				}
			} else {
				obj['img'].style['top'] = `${(DR.h - IR.h) * DR.y / (inWH[1] - DR.h)}px`;
				obj['img'].style['left'] = '0px';
			}
		}
	}
//----------------------------------------------------------------
// GOOGLE MAPS
	initGoogleMaps() {
		const as = hustle.PU.NAME({nm:'GoogleMaps'});
		this.gMapIndexs = new Array();
		if(as.length > 0) {
			as.forEach((vl, id, ar)=>{
				if(vl instanceof Element) this.gMapIndexs.push(hustle.PU.getID({obj:vl}));
			});
		}
		//LOAD GOOGLE MAPS API
		if(this.gMapIndexs.length > 0 && hustle.GooglMapsKEY.length > 24) {//Google Maps KeyがなければAPIを読み込まない。
			const src = `https://maps.googleapis.com/maps/api/js?key=${hustle.GooglMapsKEY}&callback=registGoogleMaps&libraries=&v=weekly`;
			const js = document.createElement('script');
			hustle.PU.setATBT({vlu:'text/javascript', atr:'type', obj:js});
			hustle.PU.setATBT({vlu:src, atr:'src', obj:js});
			hustle.PU.setATBT({vlu:'', atr:'async', obj:js});
			this.BODY.appendChild(js);
		}
	}
	letGoogleMaps() {
		this.gMapIndexs.forEach((vl, id, ar)=>this.doGoogleMaps(vl));
	}
	doGoogleMaps(id) {
		const obj = hustle.PU.ID({id});
		const lat = Number.parseFloat(hustle.PU.ATBT({atr:'data-lat', obj}));
		const lng = Number.parseFloat(hustle.PU.ATBT({atr:'data-lng', obj}));
		const zoom = Number.parseInt(hustle.PU.ATBT({atr:'data-zoom', obj}));
		const mapId = hustle.GooglMapsID;
		const uluru = {lat, lng};
		const map = new google.maps.Map(obj, {zoom:zoom, center:uluru, mapId:mapId,});
		const marker = new google.maps.Marker({position:uluru, map:map,});
	}
}