/***************************************************************
studio hustlemouse
Javascript Code 'hustleConfig.js' for asama
Create : 2021.11.30
Modify : 2025.5.15
Author : maruhiro
(c)maruhiro all rights reserved.
***************************************************************/
//----------------------------------------------------------------
// OUTLINE
// [GLOVAL FIELDS]
// *hustle
// [GLOVAL METHODS]
// *registGoogleMaps()
// [HUSTLE FIELDS]
// *onService
// *aboveUri
// *dirUri
// *dirWP
// *project
// *PU
// *SU
// *BU
// *MAIN
// *CB
// *RG
// *mainCss
// *animCss
// *mainRules
// *animRules
// *textSizeCookie
// *windowName
// *baseDirName
// *re
// *uri
// *param
// *tmp
// *registJS
// *moduleJS
// *WHITE_BORD
// *WORKING_ANIM
// *fn
// *GooglMapsKEY
// *GooglMapsID
// *msgNum
// [METHODS]
// *letScroll()
// *onWindowScroll()
// *init()
// *echo()
// *echoReset()
// *typeof()
// *addLoadEvent()
//----------------------------------------------------------------
// STRICT MODE（厳格モード）
'use strict';
//----------------------------------------------------------------
// CONFIGURATION
const hustle = new Object();
if(typeof asama === 'undefined') {
	//WORKING ON SOME SERVICE
	//hustle.onService = false;
	//PROJECT DIRECTORY NAME
	//hustle.aboveUri = '';
	//hustle.dirUri = '';
	//プロジェクト名はメインCSSの名前に使われる。
	//hustle.project = 'myProject';
	//SERVICE WORKER ACTIVATE
	//hustle.serviceWorker = false;
	//ELEMENTS VISUALIZE
	//hustle.elemantsVisualize = true;
} else {
	//WORKING ON SOME SERVICE
	hustle.onService = true;
	//THEME DIRECTORY URI
	hustle.aboveUri = asama.aboveUri;
	hustle.dirUri = asama.dirUri;
	//WORDPRESS DIRECTORY NAME
	hustle.dirWP = asama.dirWP;
	//THEME DIRECTORY NAME
	hustle.project = asama.project;
}
hustle.PU;
hustle.SU;
hustle.BU;
hustle.MAIN;
hustle.CB;
hustle.RG;
//----------------------------------------------------------------
//STYLE SHEET
//デザイン・アニメーションCSSファイル名の指定
hustle.mainCss = 'asamito.css';
hustle.animCss = 'asamito_anim.css';
//デザイン・アニメーションCSS指定項目配列
hustle.mainRules;
hustle.animRules;
//----------------------------------------------------------------
//COOKIE NAME
hustle.textSizeCookie = 'textSize';
//----------------------------------------------------------------
//ウインドウ名（ページタイトルでなくウインドウオブジェクトの参照名）
hustle.windowName = hustle.project;
//参照基準となるディレクトリ名
hustle.baseDirName = hustle.project;
//----------------------------------------------------------------
//HREFからURLとURLパラメータに切り分ける。
hustle.re = new RegExp('\\?', 'g');
hustle.uri = '';
hustle.param = '';
hustle.tmp = location.href.search(hustle.re);
if(hustle.tmp === -1) {
	hustle.uri = location.href.slice(0);
} else {
	hustle.uri = location.href.slice(0, hustle.tmp);
	hustle.param = location.href.slice(hustle.tmp+1);
}
//----------------------------------------------------------------
// REGIST CODEBASE
if(hustle.onService) {
	hustle.CB = `${hustle.dirUri}/`;
} else {
	hustle.CB = '';
	hustle.re = new RegExp(`${hustle.baseDirName}/.*$`, 'g');
	hustle.tmp = hustle.uri.search(hustle.re);
	if(hustle.tmp === -1) {
		console.error(`CATCH_ERROR_>'${hustle.baseDirName}' is not in the URI.`);
	} else {
		hustle.aboveUri = hustle.uri.slice(0, hustle.tmp);
		hustle.dirUri = `${hustle.aboveUri}/${hustle.baseDirName}/`;
		hustle.tmp = hustle.uri.match(hustle.re)[0];
		hustle.re = new RegExp('/', 'g');
		hustle.re.exec(hustle.tmp);//1個目を検索しておく
		while(hustle.re.exec(hustle.tmp) !== null) hustle.CB += '../';
	}
}
//----------------------------------------------------------------
// URL PARAMETER INDEX
if(hustle.param !== '') {
	hustle.tmp = new Object();
	hustle.param = hustle.param.split('&');
	hustle.param = hustle.param.map((cv, id, ar) => cv.split('='));
	hustle.param.forEach((cv, id, ar) => {hustle.tmp[cv[0]] = cv[1]});
	hustle.param = hustle.tmp;
	//for(let k of Object.keys(hustle.param)) console.log(`PARAM_KEY_>${k}_VALUE_>${hustle.param[k]}`);
}
//----------------------------------------------------------------
// REGISTRATION SOURCES
hustle.registJS = [
	`${hustle.CB}js/RegistrationClass.js`,
	`${hustle.CB}js/MainClass.js`,
	`${hustle.CB}js/stuff/ResizeManagerClass.js`,
	`${hustle.CB}js/stuff/MainMenuManagerClass.js`,
	`${hustle.CB}js/stuff/ScrollArrowManagerClass.js`
];
hustle.moduleJS = [
	`${hustle.CB}js/moduleLoader.js`
];
//----------------------------------------------------------------
// LOAD JAVASCRIPT FILES
for(let ps of hustle.registJS) {
	hustle.tmp = document.createElement('script');
	hustle.tmp.type = 'text/javascript';
	hustle.tmp.src = ps;
	document.head.insertAdjacentElement('beforeend', hustle.tmp);
}
for(let ps of hustle.moduleJS) {
	hustle.tmp = document.createElement('script');
	hustle.tmp.type = 'module';
	hustle.tmp.src = ps;
	document.head.insertAdjacentElement('beforeend', hustle.tmp);
}
//----------------------------------------------------------------
// CREATE PROGRESS BORDS
hustle.WHITE_BORD = document.createElement('div');
hustle.WHITE_BORD.id = 'whiteBoard';
hustle.WORKING_ANIM = document.createElement('div');
hustle.WORKING_ANIM.id = 'workingAnim';
hustle.letScroll = function() {
	document.getElementById('whiteBoard').style['top'] = window.scrollY+'px';
	document.getElementById('workingAnim').style['top'] = window.scrollY+'px';
};
hustle.onWindowScroll = function(e) {hustle.letScroll();};
hustle.fn = e => hustle.onWindowScroll(e);
document.addEventListener('DOMContentLoaded', (e)=>{
	document.body.insertAdjacentElement('afterbegin', hustle.WORKING_ANIM);
	document.body.insertAdjacentElement('afterbegin', hustle.WHITE_BORD);
	window.addEventListener('scroll',hustle.fn, false);
	hustle.letScroll();
}, false);
//----------------------------------------------------------------
// GOOGLE MAPS CONFIG
try {
	hustle.GooglMapsKEY = GoogleParams.GooglMapsKEY;
	hustle.GooglMapsID = GoogleParams.GooglMapsID;
} catch(e) {
	console.error(`CATCH_ERROR_>${e.message}_>>>'Google Maps' are not in order, may be.`);
}
// REGIST GOOGLE MAPS
function registGoogleMaps() {hustle.MAIN.letGoogleMaps();}
//----------------------------------------------------------------
// hustleの初期化メソッド
//Syntax:objectName.init();
//Parameter:なし
//Return:なし
//Reference:hustleの初期化メソッド
hustle.init = function() {
	window.removeEventListener('scroll', hustle.fn, false);
	hustle.RG = new RegistrationClass();
	hustle.RG.init();
	window.name = hustle.windowName;
	window.focus();
};
//----------------------------------------------------------------
// ログ出力
//----------------------------------------------------------------
//Syntax:objectName.echo(label, ...arg);
//Parameter:'label'はラベルの文字列
////コンソールにカウント出力するラベル名として利用される。
////console.clearの操作には「CLEAR, CLR」のいずれかの文字列を指定する。
////console.errorの出力には「ERROR, ERR」のいずれかの文字列を指定する。
////console.dirの出力には「DIR」の文字列を指定する。
////console.logの出力には「LOG」の文字列を指定する。
////任意の文字列や数値を指定できるが、全て「LOG」と同じ出力が行われる。
//Parameter:'arg'は可変長変引数を受け取った配列
//Return:なし
//Reference:新開発の「echo」メソッド（2025.4.25）。
hustle.echo = function(label, ...args) {
	hustle.SU.echo({lbl:label, args});
};
//Syntax:objectName.echoReset(label);
//Parameter:'label'はラベルの文字列
//Return:なし
//Reference:コンソールのラベル出力のカウンターをリセットする。
hustle.echoReset = function(label) {
	hustle.SU.echoReset({lbl:label});
};
//----------------------------------------------------------------
// TYPEOF
//----------------------------------------------------------------
//Syntax:objectName.typeof(obj);
hustle.typeof = function(obj) {hustle.SU.typeof({obj});};
//----------------------------------------------------------------
// hustleの初期化実装メソッド
//Syntax:objectName.addLoadEvent(init);
//Parameter:"init"は初期化メソッド
//Return:なし
//Reference:ページのonloadイベントを損なうことなく、hustleオブジェクトの初期化メソッドを実装するためのメソッド
hustle.addLoadEvent = function(init) {
	if(typeof(window.onload) !== 'function') window.onload = init;
	else {
		const fn = window.onload;
		window.onload = function() {
			fn;
			init;
		};
	}
};
//----------------------------------------------------------------
// EVENT INCREMENT
//onloadイベントにhustleオブジェクトの初期化メソッドを実装する。
//なお、onloadの指定がない場合（あさま）のため、bodyより先に処理される以下の記述は生かしておく。
if(document.getElementById)hustle.addLoadEvent(hustle.init);
