/****************************************************************
studio hustlemouse
JavaScript Code 'hustleSillyUtilityModule'
Author MARUHIRO
Create:2021.8.29
Modify:2023.12.26
(c)maruhiro. All rights reserved.
****************************************************************/
export default class hustleSillyUtilityModule {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//----------------------------------------------------------------
	constructor() {}
//----------------------------------------------------------------
// ITERATOR TOOLS
//----------------------------------------------------------------
	//Syntax:objectName.itrKeys({obj}});
	//Parameter:'obj'は対象のイテレーターオブジェクト
	//Return:配列
	//Reference:イテレーターオブジェクトの値を配列に開いて返す。
	static itrKeys({obj}) {
		const keys = new Array();
		let n;
		while(n = obj.next()) {
			if(n.done) break;
			else keys.push(n.value);
		}
		return keys;
	}
//----------------------------------------------------------------
// DOM OBJECT TOOLS
//----------------------------------------------------------------
	//Syntax:objectName.traceDomList({obj}});
	//Parameter:'obj'は対象のDOMStringListオブジェクト
	//Return:配列
	//Reference:DOMStringListの値を配列に開いて返す。
	static traceDomList({obj}) {
		const r = new Array();
		for(let i=0; i<obj.length; i++) {
			r.push(obj.item(i));
		}
		return r;
	}
//----------------------------------------------------------------
// ARRAY TOOLS
//----------------------------------------------------------------
	//Syntax:objectName.ridArray({a, b}));
	//Parameter:'a'と'b'は配列、比較元がaで比較先がb
	//Return:配列
	//Reference:a配列内でb配列内に無い要素を比較して（a-bの概念にて）返す。
	static ridArray({a, b}) {return a.filter((vc,id,ar)=>(b.indexOf(vc)===-1))}
	//Syntax:objectName.andArray({a, b}));
	//Parameter:'a'と'b'は配列、比較元がaで比較先がb
	//Return:配列
	//Reference:a配列内でb配列内に共通の要素を比較して（a&&bの概念にて）且つ重複を排除して返す。
	static andArray({a, b}) {
		//return a.filter((vc,id,ar)=>(b.indexOf(vc)!==-1));
		const c = a.filter((vc,id,ar)=>(b.indexOf(vc)!==-1));
		return c.filter((vc,id,ar)=>(c.indexOf(vc)===id));
	}
	//Syntax:objectName.isFillArray({a}));
	//Parameter:'a'は配列
	//Return:真偽値
	//Reference:何らかのデータが揃った配列であるかを確認する。この場合はsomeとeveryは利用できない。空だとスキップちゃうんだよ。びっくり。
	static isFillArray({a}) {
		//hustle.echo('SILLY_UTL', `IS_FILL_ARRAY_>>>${a}_>>>${a.length}`, a);
		if(Array.isArray(a) && a.length>0) {
			//return !a.some((vc, id, ar)=>(vc!==0 && (typeof(vc)==='undefined' || !vc)));
			//return a.every((vc, id, ar)=>(typeof(vc)!=='undefined' || vc!==null || vc!==''));
			//return a.findIndex((vc, id, ar)=>(vc!==0 && (typeof(vc)==='undefined' || !vc)))===-1;
			return a.findIndex((vc, id, ar)=>!this.isValue({v:vc}))===-1;
			/* for(let i of a) {
				if(i!==0 && (typeof(i)==='undefined' || !i)) return false; 
			}
			return true;  */
		} else return false;
	}
//----------------------------------------------------------------
// STRING TOOLS
//----------------------------------------------------------------
	//Syntax:objectName.letFull2Half({str})
	//Parameter:'str'は文字列
	//Return:文字列
	//Reference:文字列内の英数字を半角にして返す。10進数の場合（65248）、16進数の場合（0xFEE0）
	static letFull2Half({str}) {
		return str.replace(/[Ａ-Ｚａ-ｚ０-９]/g, (s)=>String.fromCharCode(s.charCodeAt(0)-0xFEE0));
		/* const re = new RegExp('[Ａ-Ｚａ-ｚ０-９]', 'g');
		return hustle.PU.RegReplace({s:(s)=>String.fromCharCode(s.charCodeAt(0)-65248), re, str}); */
	}
	//Syntax:objectName.letHalf2Full({str})
	//Parameter:'str'は文字列
	//Return:文字列
	//Reference:文字列内の英数字を全角にして返す。10進数の場合（65248）、16進数の場合（0xFEE0）
	static letHalf2Full({str}) {
		return str.replace(/[A-Za-z0-9]/g, (s)=>String.fromCharCode(s.charCodeAt(0)+65248));
	}
	//Syntax:objectName.letFullComma2Half({str})
	//Parameter:'str'は文字列
	//Return:文字列
	//Reference:文字列内の全角カンマを半角にして返す。
	static letFullComma2Half({str}) {return str.replace(/、|，/g, ',');}
	//Syntax:objectName.letFullPeriod2Half({str})
	//Parameter:'str'は文字列
	//Return:文字列
	//Reference:文字列内の全角ピリオドを半角にして返す。
	static letFullPeriod2Half({str}) {return str.replace(/。|．/g, '.');}
	//Syntax:objectName.isNaN({str});
	//Parameter:'str'は文字列
	//Return:真偽値
	//Reference:グローバルのisNaNは空文字（''）やnullでも偽を返してしまうので、必ず数値文字列でないことを確認できる。
	//Reference:Number.isNaN()はNaNしか判定できない。
	static isNaN({str}) {
		//hustle.echo('SILLY_UTL', `IS_NOT_A_NUMBER_STRING_>>>>${str}`);
		return !(/^[0-9]+(\.[0-9]+)?$/g).test(str);
	}
	//Syntax:objectName.isPeriod({str});
	//Parameter:'str'は文字列
	//Return:真偽値
	//Reference:数値にキャストする予定の文字列にピリオドが一つあるかどうかを判定する。最初と途中にあれば真を返す。
	static isPeriod({str}) {
		let r = false;
		if((/^[^.]*\.[^.]*$/g).test(str)) {
			if((/^[^.]*\.$/g).test(str)) r = false;
			else r = true;
		}
		return r;
	}
//----------------------------------------------------------------
// PARAMETER TOOLS
//----------------------------------------------------------------
	//Syntax:objectName.isNoV({v});
	//Parameter:'v'は任意の値
	//Return:真偽値
	//Reference:任意の値が、undefinedもしくはnull、NaN、空文字「''」、数値「0」など、ボリュームがない値であることを判定する。
	static isNoV({v}) {
		return typeof(v)==='undefined' || !v;
	}
	//Syntax:objectName.anyNoV({v});
	//Parameter:'v'は任意の値による配列
	//Return:真偽値
	//Reference:任意の値による配列にボリュームのないisNoV()が含まれることを判定する。
	static anyNoV({v}) {
		if(Array.isArray(v)) {
			return v.findIndex((vc, id, ar)=>this.isNoV({v}))>=0;
		} else return this.isNoV({v});
	}
	//Syntax:objectName.isValue({v, c=[0]});
	//Parameter:'v'は任意の値
	//Parameter:'c'は強制的に整合させる値（null、NaN、空文字「''」、数値「0」など）の配列で初期値は[0]。
	//Return:真偽値
	//Reference:任意に除外指定がなければバリューがあるとして真を、undefinedもしくはnull、NaN、空文字「''」には偽を返す。
	static isValue({v, c=[0]}) {
		let b = c.findIndex((vc, id, ar)=>vc===v)>=0;
		if(!b) b = c.findIndex((vc, id, ar)=>Number.isNaN(vc))>=0;
		return !this.isNoV({v}) || b;
	}
//----------------------------------------------------------------
// DATE TOOLS
//----------------------------------------------------------------
	//Syntax:objectName.isDate({obj});
	//Parameter:'obj'は任意のオブジェクト
	//Return:真偽値
	//Reference:オブジェクトがDateオブジェクトであるかの真偽を返す。
	static isDate({obj}) {return obj instanceof Date;}
	//Syntax:objectName.typeOfDateString({str});
	//Parameter:'str'は任意の文字列
	//Return:文字列
	//Reference:文字列の日付フォーマットを確認してそのフォーマットを返す。
	static typeOfDateString({str}) {
		//そもそもこのメソッドって必要なのだろうか？
		//なんなら「new Date(str)」そしてDateオブジェクトが得られなかったら偽でいいんでないの？
		let r = false;
		//ISO 8601形式（例：2024-08-03T14:30:15.123Z）
		//^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d{1,3})?(?:Z|[+-]\d{2}:\d{2})$
		//YYYY-MM-DD HH:MM.sss形式（例：2024-08-03 14:30:15.123）
		//^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}(?:\.\d{1,3})?$
		//YYYY/MM/DD HH:MM.sss形式（例：2024/08/03 14:30:15.123）
		//^\d{4}/\d{2}/\d{2} \d{2}:\d{2}:\d{2}(?:\.\d{1,3})?$
		if((/^\d{4}\/\d{2}\/\d{2} \d{2}:\d{2}:\d{2}(?:\.\d{1,3})?$/).test(str)) r = 'YYYY/MM/DD HH:MM.sss';
		else if((/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}(?:\.\d{1,3})?$/).test(str)) r = 'YYYY-MM-DD HH:MM.sss';
		//else if((/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d{1,3})?(?:Z|[+-]\d{2}:\d{2})$/).test(str)) r = 'RFC 7231';
		else if((/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d{1,3})?(?:Z|[+-]\d{2}:\d{2})$/).test(str)) r = 'ISO 8601';
		return r;
	}
	//Syntax:objectName.letDate({str});
	//Parameter:'str'は任意の文字列
	//Return:文字列
	//Reference:確認した日付フォーマットを返す。
	/* static letDate({str}) {
		const r = this.typeOfDateString({str});
		switch(r) {
			case 'ISO 8601':
				break;
			case 'YYYY-MM-DD HH:MM.sss':
				break;
			case 'YYYY/MM/DD HH:MM.sss':
				break;
			default:
		}
		return r;
	} */
	//Syntax:objectName.getNowDate();
	//Return:文字列
	//Reference:現在の日時を日付フォーマットに変換して返す。
	static getNowDate() {
		return this.milliSec2Date({ms:Date.now()});
	}
	//Syntax:objectName.getMilliseconds({str});
	//Parameter:'str'は日付フォーマットの文字列
	//Return:整数値
	//Reference:日付フォーマットの文字列をミリ秒に変換して返す。
	static getMilliseconds({str}) {
		const r = this.typeOfDateString({str});
		let d;
		switch(r) {
			case 'ISO 8601':
				d = new Date(str);
				break;
			case 'YYYY-MM-DD HH:MM.sss':
				d = new Date(str.replace(/-/g, '/'));
				break;
			case 'YYYY/MM/DD HH:MM.sss':
				d = new Date(str);
				break;
			default:
		}
		return d.getTime();
	}
	//Syntax:objectName.milliSec2Date({ms});
	//Parameter:'ms'はミリ秒
	//Return:文字列
	//Reference:ミリ秒を日付フォーマットに変換して返す。
	static milliSec2Date({ms}) {
		const d = new Date(ms);
		return `${d.getFullYear()}/${d.getMonth()+1}/${d.getDate()} ${d.getHours()}:${d.getMinutes()}:${d.getSeconds()}.${d.getMilliseconds()}`;
	}
	//----------------------------------------------------------------
	// ULID
	//----------------------------------------------------------------
	//Syntax:objectName.hustleULID({scl, crp, nom, int});
	//Parameter:'scl'は進数のスケール
	//Parameter:'crp'はランダム進数の桁数
	//Parameter:'nom'はノンブル進数の桁数
	//Parameter:'int'はノンブル進数のカウント
	//Return:文字列
	//Reference:独自ULIDを生成して返す。
	//static hustleULID({scl=36, crp=8, nom=4, int=0}) {
	static hustleULID() {
		//scl = scl>=2&&scl<=36?scl:36;
		//const scl = 36;
		//const crp = 18;
		//const time = Date.now().toString(scl); //タイムスタンプを初期値36進数文字列に変換
		//const crop = this.password({lng:crp, scl}); //ランダムな36進数文字列を生成
		//int = int<scl**nom?int:int-scl**nom; //ノンブル進数のカウントを調整
		//const nombre = this.hustleNOMBRE({lng:nom, scl, int});
		//return time + crop + nombre;
		return Date.now().toString(36) + this.password({lng:18, scl:36});
	}
	//Syntax:objectName.hustleNOMBRE({lng, scl, int});
	//Parameter:'lng'はノンブル進数の桁数
	//Parameter:'scl'は進数のスケール
	//Parameter:'int'はノンブル進数のカウント（36進数で4桁なら0から1,679,615まで）
	//Return:文字列
	//Reference:独自ノンブルを生成して返す。
	/* static hustleNOMBRE({lng, scl=36, int=0}) {
		if(lng<1) return '';
		let n = Math.abs(scl**lng-1-int).toString(scl>=2&&scl<=36?scl:36);
		n = n.length>lng?n.slice(-lng):n;
		return n.padStart(lng, '0');
	} */
	//Syntax:objectName.getULIDsTime({ulid, scl, crp, nom});
	//Parameter:'ulid'は独自ULID文字列
	//Parameter:'scl'は進数のスケール
	//Parameter:'crp'はランダム進数の桁数
	//Parameter:'nom'はノンブル進数の桁数
	//Return:整数値
	//Reference:独自ULID生成された時間を取得して返す。
	//static getULIDsTime({ulid, scl=36, crp=8, nom=4}) {
	static getULIDsTime({ulid}) {
		//const scl = 36;
		//const crp = 18;
		//return parseInt(ulid.substring(0, ulid.length-(crp+nom), scl));
		return parseInt(ulid.substring(0, ulid.length-18, 36));
	}
	//----------------------------------------------------------------
	// PASSWORD
	//----------------------------------------------------------------
	//Syntax:objectName.password({lng, scl});
	//Parameter:'lng'は桁数
	//Parameter:'scl'は進数のスケール（数字対応10まで小文字対応36まで大文字対応62まで記号対応89まで）
	//Return:文字列
	//Reference:ランダム文字列を生成して返す。
	static password({lng, scl=36}) {
		if(lng<1) return '';
		scl = scl>=2&&scl<=89?scl:36;
		const chars = `0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!#$%&()*+,-./:;<=>?@[]^_{}~`;
		//クォート三種とバックスラッシュ、バーティカルバーは除外する。
		//0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!A#$%&A()*+,-./:;<=>?@[A]^_A{A}~
		//0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~
		/* const a32 = new Uint32Array(lng);
		crypto.getRandomValues(a32);
		const a = Array.from(a32);
		return a.map((vc, id, ar)=>chars[vc%scl]).join(''); */
		const a32 = crypto.getRandomValues(new Uint32Array(lng));
		return Array.from(a32).map((vc, id, ar)=>chars[vc%scl]).join('');
	}
	//----------------------------------------------------------------
	// BASE32 ENCODE & DECODE
	//----------------------------------------------------------------

	//----------------------------------------------------------------
	// CONSOLE
	//----------------------------------------------------------------
	//Syntax:objectName.echo({lbl, args});
	//Parameter:'lbl'はラベルの文字列
	//Parameter:'args'は配列
	//Return:なし
	//Reference:コンソールへの基本的な出力を司る。
	static echo = function({lbl='LOG', args}) {
		//自分が間違えそうなので安全のためにラベルが真偽値あるケースにも対応する。
		if(typeof(lbl)==='boolean') lbl = lbl?'ERROR':'LOG';
		//数値は文字列として扱う。
		if(typeof(lbl)==='number') lbl = lbl.toString();
		if(typeof(lbl)!=='string' || lbl===null || lbl.length<1) {
			console.error('ラベルの文字列が必要です。');
			return;
		}
		//ラベルは大文字で扱う。
		lbl = lbl.toUpperCase();
		//コンソールの出力をクリアする。
		if(lbl==='CLEAR' || lbl==='CLR') {
			console.clear();
			return;
		}
		if(args.length<1) {
			console.error(`引数が不足してます。`);
			return;
		}
		console.count(`ECHO_${lbl}`);
		switch(lbl) {
		case 'ERROR':
		case 'ERR':
			this.echoLog({e:true, args});
			break;
		case 'DIR':
			this.echoDir({args});
			break;
		case 'LOG':
		default:
			this.echoLog({e:false, args});
		}
	}
	//Syntax:objectName.echo({args});
	//Parameter:'args'は配列
	//Return:なし
	//Reference:配列に渡される全オブジェクトをconsole.dirで個別に出力する。
	static echoDir({args}) {
		let str = '>>ECHO_DIR';
		//出力タイトルに出力する各オブジェクトタイプを追記する。
		for(let v of args) str+=`_TYPE_>'${typeof(v)}'`;
		console.log(str);
		args.forEach((vc,id,ar)=>console.dir(vc));
	}
	//Syntax:objectName.echo({e, args});
	//Parameter:'e'は真偽値
	//Parameter:'args'は配列
	//Return:なし
	//Reference:推測できる状況に対処して、ログもしくはエラー出力する。
	static echoLog({e, args}) {
		let str = '';
		let smpl = false;
		let args2 = [];
		//配列のどこか文字列に文字列置換機能の利用があれば、そのアドレスを取得する。
		const re = new RegExp('%(o|O|d|i|s|f|c)', 'g');
		const i = args.findIndex((vc, id, ar)=>{if(typeof(vc)==='string') return vc.match(re);});
		if(i>=0) {
			//文字列置換機能がある場合
			//配列の先頭になければ、強制的に先頭に移動させる。（console.logは先頭文字列だけ利用できる。）
			if(i>0) {
				args2 = args.slice(0, i);
				args = args.slice(i, args.length);
				if(args2.length>0) {
					str+='>>ECHO_LOG';
					//出力タイトルに出力する各オブジェクトタイプを追記する。
					for(let v of args2) str+=`_TYPE_>'${typeof(v)}'`;
				}
			}
			smpl = true;
		} else {
			//文字列置換機能がない場合
			if(typeof(args[0])==='string') {
				//最初が文字列であれば通常の文字出力を模索する。
				//配列内が全て文字列で構成されている場合もシンプル出力モードにする。
				smpl = !args.find((vc, id, ar)=>typeof(vc)!=='string');
				if(!smpl) {
					//シンプル出力モードでないばあいは、最初の文字列後に改行を付けて、出力タイトルを追記する。
					str =`${args[0]}\n`;
					//配列の冒頭を削除する。
					args = args.slice(1);
					if(args.length>0) {
						str+='>>ECHO_LOG';
						//出力タイトルに出力する各オブジェクトタイプを追記する。
						for(let v of args) str+=`_TYPE_>'${typeof(v)}'`;
					}
				}
			} else {
				//最初が文字列でない場合は、オブジェクトをログ出力する。
				str = '>>ECHO_LOG';
				//出力タイトルに出力する各オブジェクトタイプを追記する。
				for(let v of args) str+=`_TYPE_>'${typeof(v)}'`;
			}
		}
		if(smpl) {
			if(e) console.error(...args);
			else console.log(...args);
			if(args2.length>0) {
				if(e) console.error(str);
				else console.log(str);
				args2.forEach((vc,id,ar)=>console.log(vc));
			}
		} else {
			if(e) console.error(str);
			else console.log(str);
			//配列に項目があればconsole.logで個別に出力する。
			if(args.length>0) args.forEach((vc,id,ar)=>console.log(vc));
		}
	}
	//Syntax:objectName.echoReset({lbl});
	//Parameter:'lbl'はラベルの文字列
	//Return:なし
	//Reference:
	static echoReset({lbl}) {
		lbl = lbl.toUpperCase();
		console.countReset(`ECHO_${lbl}`);
	}
	//----------------------------------------------------------------
	// CHECK INSTANCE
	//----------------------------------------------------------------
	//Syntax:objectName.typeof({obj});
	//Parameter:'obj'は調査対象のオブジェクト
	//Return:なし
	//Reference:コンストラクト名を調査してそのコンストラクタ名を返す。
	static typeof({obj}) {
		let r = '%c_%cINST%c';
		const l = r.length;
		const clss = [
			'Object',
			'Array',
			'Function',
			'RegExp',
			'Date',
			'String',
			'Number',
			'Boolean',
			'HTMLCollection',
			'NodeList',
			'HTMLDocument',
			'HTMLHtmlElement',
			'DOMStringList',
			'None'//必ず最後尾。
		];
		for(let i=0; i<clss.length; i++) {
			if(clss[i]==='None') {
				if(r.length===l) r += `_'${clss[i]}'`;
				break;
			} else if(obj instanceof eval(clss[i])) {
				r += `_'${clss[i]}'`;
			}
		}
		r += `_%cCNST%c_'${obj.constructor.name}'`;
		r += `_%cTYPE%c_'${typeof(obj)}'`;
		const t = 'color:blue; font-weight:bolder';
		const s = 'color:green';
		this.echo({lbl:'TYPEOF', args:[r,s,t,s,t,s,t,s]});
	}
}