/****************************************************************
studio hustlemouse
JavaScript Code 'MainMenuManagerClass'
Author MARUHIRO
Create:2020.10.21
Modify:2025.1.13
(c)maruhiro all rights reserved.
****************************************************************/
//----------------------------------------------------------------
// OUTLINE
// CSS指定は「__design.scss」の「section[name='StickyMainMenu'] {}」
//----------------------------------------------------------------
// [FIELDS]
// *MAIN
// *ISUE
// *opnMenu
// *upNav
// *lwNav
// *uMnuTgglBtn
// *uMnuTgglName
// *menuTgglClass
// *fnTgglMnMnu
// *fnEndTgglMmAnm
// *onOpnSmmAnim
// *onClsSmmAnim
// *fnOpnSubMN
// *fnClsSubMN
// *fnEndOpnSmmAnm
// *fnEndClsSmmAnm
// *fnChkClsSubMN
// *opnSubMnus
// *wpHasChildren
// *wpSubMenu
// [METHODS]
// *constructor()
// *init()
// *reset()
// *setContent()
// *initMenuToggle()
// *doTgglMainMenu()
// *endToggleMmAnim()
// *initSubMenuOPNnCLS()
// *pickUnfoldSubMN()
// *checkFoldSubMN()
// *checkUnfoldUnderSubMN()
// *letCloseUnderSubMN()
// *letCloseUnderChildSubMN()
// *letCloseAllSubMN()
// *letOpenSubMN()
// *endOpenSubMN()
// *letCloseSubMN()
// *letCloseOneSubMN()
// *endCloseSubMN()
// *restoreClass()
//----------------------------------------------------------------
class MainMenuManagerClass {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//----------------------------------------------------------------
	//Syntax:objectName = new MainMenuManagerClass(obj);
	//Parameter:'obj'はMainClassオブジェクト
	//Return:なし
	//Reference:クラスプロパティの準備
	constructor(obj) {
		this.MAIN = obj;
		//メインオブジェクトのインターバル指定と加速度指定
		//本コンテンツ特有の描画処理を呼び出す間隔（1ms = 1/1000秒）
		//this.DILAY = 40;//整数'40'であれば'40/1000秒'で25fps（フレームパーセコンド）になる。
		//"scrollA"は速度指定で、0から1までの数値を指定する。
		//"scrollA"を1にすると通常のジャンプと同じになる。
		//this.scrollA = 0.25;//0.5*0.5
		//----------------------------------------------------------------
		this.ISUE;
		//this.breadCrumbs;
		//this.bcZidx = '55';
		//----------------------------------------------------------------
		this.opnMenu;
		this.upNav;
		this.lwNav;
		//----------------------------------------------------------------
		this.uMnuTgglBtn;
		this.uMnuTgglName
		this.menuTgglClass = ['webIcon-Close','webIcon-Menu'];
		this.fnTgglMnMnu = e => this.doTgglMainMenu(e);
		this.fnEndTgglMmAnm = e => this.endToggleMmAnim(e);
		//----------------------------------------------------------------
		this.onOpnSmmAnim;
		this.onClsSmmAnim;
		this.fnOpnSubMN = e => this.letOpenSubMN(e);
		this.fnClsSubMN = e => this.letCloseSubMN(e);
		this.fnEndOpnSmmAnm = e => this.endOpenSubMN(e);
		this.fnEndClsSmmAnm = e => this.endCloseSubMN(e);
		this.fnChkClsSubMN = e => this.checkFoldSubMN(e);
		this.opnSubMnus;
		this.wpHasChildren = 'menu-item-has-children';
		this.wpSubMenu = 'sub-menu';
	}
	//----------------------------------------------------------------
	// INIT
	//----------------------------------------------------------------
	//Syntax:objectName.init();
	//Parameter:なし
	//Return:なし
	//Reference:運用エレメントの取得
	init() {
		this.ISUE = hustle.PU.QSELECT({slc:`section[name='StickyMainMenu']`});
		if((this.ISUE!==null)) {this.reset();}
	}
	//----------------------------------------------------------------
	// RESET
	//----------------------------------------------------------------
	//Syntax:objectName.reset(b);
	//Parameter:'b'は真偽値で初期値はfalse
	//Return:なし
	//Reference:運用エレメントの隠蔽とメニュートグルアニメの初動作
	//Reference:パラメータ'b'が真であれば、つぎのsetContent()と同様に動作する。
	reset(b=false) {
		//this.bcZidx = (Number.parseInt(hustle.PU.STYLEprp({prp:'z-index', obj:this.ISUE}))+1).toString();
		//ISSUEが'z-index:50'に固定であることに対してbreadCrumbsの'z-index:'を'auto'と'55'に動的に変更している。
		//メニューが閉じた時にパンくずリストが使えるようになる。
		//this.breadCrumbs = hustle.PU.ID({id:'breadcrumbs'});
		this.upNav = hustle.PU.ID({id:'upperNavBlock'});
		this.lwNav = hustle.PU.ID({id:'lowerNavBlock'});
		this.uMnuTgglBtn = hustle.PU.ID({id:'mainMenuTgglBtn'});
		this.initMenuToggle();
		this.initSubMenuOPNnCLS();
		hustle.PU.VIZ({b,obj:this.ISUE});
		if(b) this.doTgglMainMenu(this);
	}
	//----------------------------------------------------------------
	// SET CONTENT
	//----------------------------------------------------------------
	//Syntax:objectName.setContent();
	//Parameter:なし
	//Return:なし
	//Reference:なし
	setContent(XM) {
		if((this.ISUE===null)) {
			this.ISUE = hustle.PU.QSELECT({slc:`section[name='StickyMainMenu']`});
			this.reset();
		}
		hustle.PU.VIZ({b:true,obj:this.ISUE});
		this.doTgglMainMenu(this);
	}
//----------------------------------------------------------------
// MENU TOGGLE MANAGMENT
//----------------------------------------------------------------
	//Syntax:objectName.initMenuToggle();
	//Parameter:なし
	//Return:なし
	//Reference:メニュートグルアニメの初期化
	initMenuToggle() {
		this.opnMenu = true;
		if(hustle.RG.VISA.TOUCHPAD) {
			this.uMnuTgglBtn.addEventListener(hustle.RG.PEV.end, this.fnTgglMnMnu, false);
		} else {
			this.uMnuTgglBtn.addEventListener(hustle.RG.PEV.start, this.fnTgglMnMnu, false);
		}
		hustle.PU.delClass({obj:this.upNav});
		hustle.PU.delClass({obj:this.lwNav});
	}
	//----------------------------------------------------------------
	//Syntax:objectName.doTgglMainMenu(e);
	//Parameter:'e'はイベントリスナーオブジェクト
	//Return:なし
	//Reference:メニュートグルアニメを動作する。
	doTgglMainMenu(e) {
		if(this.opnMenu) {
			this.letCloseAllSubMN();
			hustle.PU.setClass({vlu:'shrnkDwGpuAnm', obj:this.upNav});
			hustle.PU.setClass({vlu:'shrnkGpuAnm', obj:this.lwNav});
		} else {
			hustle.PU.setClass({vlu:'xpndUpGpuAnm', obj:this.upNav});
			hustle.PU.setClass({vlu:'xpndGpuAnm', obj:this.lwNav});
			hustle.PU.VIZ({b:true, obj:this.upNav});
			hustle.PU.VIZ({b:true, obj:this.lwNav});
			//this.breadCrumbs.style['z-index'] = 'auto';
		}
		hustle.PU.setAnimEndLstnr({fn:this.fnEndTgglMmAnm, obj:this.upNav});
		this.opnMenu = !this.opnMenu;
	}
	//----------------------------------------------------------------
	//Syntax:objectName.endToggleMmAnim(e);
	//Parameter:'e'はイベントリスナーオブジェクト
	//Return:なし
	//Reference:メニュートグルアニメの終了処理をする。
	endToggleMmAnim(e) {
		hustle.PU.delClass({obj:this.upNav});
		hustle.PU.delClass({obj:this.lwNav});
		if(!this.opnMenu) {
			hustle.PU.VIZ({b:false, obj:this.upNav});
			hustle.PU.VIZ({b:false, obj:this.lwNav});
			hustle.PU.setClass({vlu:`${this.menuTgglClass[1]}`, obj:this.uMnuTgglBtn})
			//this.breadCrumbs.style['z-index'] = this.bcZidx;
		} else {
			hustle.PU.setClass({vlu:`${this.menuTgglClass[0]}`, obj:this.uMnuTgglBtn})
		}
		hustle.PU.delAnimEndLstnr({fn:this.fnEndTgglMmAnm, obj:this.upNav});
	}
//----------------------------------------------------------------
// SUBMENU OPEN and CLOSE MANAGMENT
//----------------------------------------------------------------
	//Syntax:objectName.initSubMenuOPNnCLS(cls);
	//Parameter:'cls'はエレメントのclass属性の値
	//Return:なし
	//Reference:
	initSubMenuOPNnCLS(cls=this.wpHasChildren) {
		if(hustle.RG.VISA.TOUCHPAD) {
			//メニュー全体にイベントリスナーを実装して、イベントバブリングを利用して閉じたサブメニュー有無を審査するメソッドを参照する。
			hustle.PU.CLASS({cls:'menus', obj:this.lwNav})[0].addEventListener(hustle.RG.PEV.start, this.fnChkClsSubMN, false);
		}
		//サブメニューのある項目には「サブメニューを開く」ボタンのエレメントを付加する。
		const hasList = hustle.PU.CLASS({cls, obj:this.lwNav});
		for(let lie of hasList) {
			const dv = document.createElement('div');
			hustle.PU.setATBT({vlu:'hasSubMenu', atr:'class', obj:dv});
			lie.prepend(dv);
			const sp = document.createElement('span');
			hustle.PU.setATBT({vlu:'webIcon-ExpandMore', atr:'class', obj:sp});
			const ankr = hustle.PU.TAG({tag:'a', obj:lie})[0];
			dv.append(ankr);//アンカータグをDIVの中に移動
			dv.appendChild(sp);//その後ろにアイコンエレメントを追加
			if(hustle.RG.VISA.TOUCHPAD) {
				sp.addEventListener(hustle.RG.PEV.end, this.fnOpnSubMN, false);
			} else {
				sp.addEventListener(hustle.RG.PEV.enter, this.fnOpnSubMN, false);
				lie.addEventListener(hustle.RG.PEV.leave, this.fnClsSubMN, false);
			}
			const ule = hustle.PU.TAG({tag:'ul', obj:lie})[0];
			if(ule!==undefined) {
				this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), ule);
				hustle.PU.VIZ({b:false, obj:ule});
			}
		}
		this.onOpnSmmAnim = false;
		this.onClsSmmAnim = false;
		if(hustle.RG.VISA.TOUCHPAD) this.opnSubMnus = this.pickUnfoldSubMN();
	}
	//----------------------------------------------------------------
	//Syntax:objectName.pickUnfoldSubMN(cls);
	//Parameter:'cls'はエレメントのclass属性の値
	//Return:なし
	//Reference:【タッチパネル対応】展開しているサブメニューエレメント配列を取得する。
	pickUnfoldSubMN(cls=this.wpSubMenu) {
		const subMenus = hustle.PU.CLASS({cls, obj:this.lwNav});
		//this.opnSubMnus = new Array();
		let r = new Array();
		for(let ule of subMenus) {
			if(hustle.PU.VIZ({obj:ule})) r.unshift(ule);
		}
		return r;
	}
	//----------------------------------------------------------------
	//Syntax:objectName.checkFoldSubMN(e);
	//Parameter:'e'はイベントリスナーオブジェクト
	//Return:なし
	//Reference:【タッチパネル対応】閉じたサブメニューの有無を審査する。
	checkFoldSubMN(e) {
		//ベンチマークエレメント
		let BMEL = e.target;
		switch(e.target.tagName) {
			case 'A':
				if(hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode})) {
					if(BMEL.parentNode.tagName==='DIV' && hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf('hasSubMenu')!==-1) {
						BMEL = BMEL.parentNode.parentNode.parentNode;
					} else if(BMEL.parentNode.tagName==='LI' && hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf('menu-item')!==-1) {
						BMEL = BMEL.parentNode.parentNode;
					}
				}
				if(hustle.PU.ATBT({atr:'class', obj:BMEL})) {
					if(BMEL.tagName==='UL' && hustle.PU.ATBT({atr:'class', obj:BMEL}).indexOf('menus')!==-1) this.letCloseAllSubMN();
				}
				break;
			case 'LI':
				if(BMEL.id) {
					for(let ule of this.opnSubMnus) {
						if(ule.parentNode.id!==BMEL.id) {
							if(hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf(this.wpSubMenu)!==-1) {
								if(ule.parentNode.parentNode.parentNode.id===BMEL.parentNode.parentNode.id) {
									this.letCloseUnderSubMN(ule);
									this.letCloseOneSubMN(ule);
								}
							} else this.letCloseAllSubMN();
						}
					}
				} else this.letCloseAllSubMN();
				break;
			case 'UL':
				if(hustle.PU.ATBT({atr:'class', obj:BMEL})) {
					if(hustle.PU.ATBT({atr:'class', obj:BMEL}).indexOf('menus')!==-1) this.letCloseAllSubMN();
				}
				break;
			case 'DIV':
				if(hustle.PU.ATBT({atr:'class', obj:BMEL})) {
					if(hustle.PU.ATBT({atr:'class', obj:BMEL}).indexOf('hasSubMenu')!==-1) {
						for(let ule of this.opnSubMnus) {
							if(ule.parentNode.id===BMEL.parentNode.id) {
								this.letCloseUnderSubMN(ule);
								this.letCloseOneSubMN(ule);
							}
						}
					};
				}
				break;
			case 'SPAN':
				if(hustle.PU.ATBT({atr:'class', obj:BMEL})) {
					if(hustle.PU.ATBT({atr:'class', obj:BMEL}).indexOf('webIcon')!==-1) {
						BMEL.style['background-color']='var(--overClr)';
					 	if(this.checkUnfoldUnderSubMN(hustle.PU.TAG({tag:'ul', obj:BMEL.parentNode.parentNode})[0])) {
							this.letCloseUnderChildSubMN(hustle.PU.TAG({tag:'ul', obj:BMEL.parentNode.parentNode})[0]);
						} else if(hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode})) {
							if(BMEL.parentNode.tagName==='DIV' && hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf('hasSubMenu')!==-1) {
								BMEL = BMEL.parentNode.parentNode;
							}
							if(hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode})) {
								if(BMEL.parentNode.tagName==='UL' && hustle.PU.ATBT({atr:'class', obj:BMEL.parentNode}).indexOf('menus')!==-1) {
									if(!this.checkUnfoldUnderSubMN(BMEL) && this.opnSubMnus.length>0) this.letCloseAllSubMN();
								}
							}
						}
						break;
					}
				}
			default:
		}
	}
	//----------------------------------------------------------------
	//Syntax:objectName.checkUnfoldUnderSubMN(obj, cls);
	//Parameter:'obj'はulタグのエレメント
	//Parameter:'cls'はエレメントのclass属性の値
	//Return:真偽値
	//Reference:【タッチパネル対応】下位のサブメニューに展開しているか確認する。基本的に偽が返る。
	checkUnfoldUnderSubMN(obj, cls=this.wpSubMenu) {
		const subMenus = hustle.PU.CLASS({cls, obj});
		for(let ule of subMenus) {
			if(hustle.PU.VIZ({obj:ule})) {return true;}
		}
		return false;
	}
	//----------------------------------------------------------------
	//Syntax:objectName.letCloseUnderSubMN(obj, cls);
	//Parameter:'obj'はulタグのエレメント
	//Parameter:'cls'はエレメントのclass属性の値
	//Return:なし
	//Reference:【タッチパネル対応】対象エレメント下位にてサブメニューを持つエレメント内の全サブメニューをクローズ開始する。
	letCloseUnderSubMN(obj, cls=this.wpHasChildren) {
		const hasList = hustle.PU.CLASS({cls, obj});
		if(Array.isArray(hasList)) hasList.reverse();
		for(let lie of hasList){
			const ule = hustle.PU.TAG({tag:'ul', obj:lie})[0];
			if(hustle.PU.VIZ({obj:ule})) this.letCloseOneSubMN(ule);
		}
	}
	//----------------------------------------------------------------
	//Syntax:objectName.letCloseUnderChildSubMN(obj, cls);
	//Parameter:'obj'はulタグのエレメント
	//Parameter:'cls'はエレメントのclass属性の値
	//Return:なし
	//Reference:【タッチパネル対応】対象エレメント下位の全サブメニューをクローズ開始する。
	letCloseUnderChildSubMN(obj, cls=this.wpSubMenu) {
		const subMenus = hustle.PU.CLASS({cls, obj});
		if(Array.isArray(subMenus)) hasList.reverse();
		for(let ule of subMenus){
			if(hustle.PU.VIZ({obj:ule})) this.letCloseOneSubMN(ule);
		}
	}
	//----------------------------------------------------------------
	//Syntax:objectName.letCloseAllSubMN(cls);
	//Parameter:'cls'はエレメントのclass属性の値
	//Return:なし
	//Reference:メニュー内の全サブメニューをクローズ開始する。
	letCloseAllSubMN(cls=this.wpSubMenu) {
		const subMenus = hustle.PU.CLASS({cls, obj:this.lwNav});
		for(let ule of subMenus) {
			if(hustle.PU.VIZ({obj:ule})) this.letCloseOneSubMN(ule);
		}
	}
	//----------------------------------------------------------------
	//Syntax:objectName.letOpenSubMN(e);
	//Parameter:'e'はイベントリスナーオブジェクト
	//Return:なし
	//Reference:サブメニューをオープン開始する。
	letOpenSubMN(e) {
		const obj = hustle.PU.TAG({tag:'ul', obj:e.target.parentNode.parentNode})[0];
		if(!hustle.PU.VIZ({obj})) {
			if(this.onClsSmmAnim) {
				hustle.PU.delAnimEndLstnr({fn:this.fnEndClsSmmAnm, obj});
				this.onClsSmmAnim = false;
			}
			hustle.PU.VIZ({b:true, obj});
			hustle.PU.replaceAnimKey({prp:`height:${obj.clientHeight}px`, key:'100%', anim:'xpndCpuAnm', srs:hustle.animRules, visa:hustle.RG.VISA});
			this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), obj);
			const cls = hustle.PU.getClass({obj});
			hustle.PU.setClass({vlu:`${cls} xpndCpuAnm`, obj});
			hustle.PU.setAnimEndLstnr({fn:this.fnEndOpnSmmAnm, obj});
			this.onOpnSmmAnim = true;
		} else if(hustle.RG.VISA.TOUCHPAD) {
			e.target.style['background-color']='var(--ankrClr)';
		}
	}
	//----------------------------------------------------------------
	//Syntax:objectName.endOpenSubMN(e);
	//Parameter:'e'はイベントリスナーオブジェクト
	//Return:なし
	//Reference:サブメニューオープン終了を処理する。
	endOpenSubMN(e) {
		const obj = (e.target.tagName==='A')? e.target.parentNode.parentNode : e.target;
		this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), obj);
		hustle.PU.delAnimEndLstnr({fn:this.fnEndOpnSmmAnm, obj});
		this.onOpnSmmAnim = false;
		if(hustle.RG.VISA.TOUCHPAD) {
			this.opnSubMnus = this.pickUnfoldSubMN();
			e.target.parentNode.firstChild.lastChild.style['background-color']='var(--ankrClr)';
		}
	}
	//----------------------------------------------------------------
	//Syntax:objectName.letCloseSubMN(e);
	//Parameter:'e'はイベントリスナーオブジェクト
	//Return:なし
	//Reference:サブメニューをクローズ開始する。
	letCloseSubMN(e) {
		const obj = hustle.PU.TAG({tag:'ul', obj:e.target})[0];
		if(this.onOpnSmmAnim) {
			hustle.PU.VIZ({b:true, obj});
			hustle.PU.delAnimEndLstnr({fn:this.fnEndOpnSmmAnm, obj});
			this.onOpnSmmAnim = false;
		}
		this.letCloseOneSubMN(obj);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.letCloseOneSubMN(obj);
	//Parameter:'obj'はulタグのエレメント
	//Return:なし
	//Reference:ひとつのサブメニューをクローズ開始する。
	letCloseOneSubMN(obj) {
		hustle.PU.replaceAnimKey({prp:`height:${obj.clientHeight}px`, key:'0%', anim:'shrnkCpuAnm', srs:hustle.animRules, visa:hustle.RG.VISA});
		this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), obj);
		const cls = hustle.PU.getClass({obj});
		hustle.PU.setClass({vlu:`${cls} shrnkCpuAnm`, obj});
		hustle.PU.setAnimEndLstnr({fn:this.fnEndClsSmmAnm, obj});
		this.onClsSmmAnim = true;
	}
	//----------------------------------------------------------------
	//Syntax:objectName.endCloseSubMN(e);
	//Parameter:'e'はイベントリスナーオブジェクト
	//Return:なし
	//Reference:サブメニュークローズ終了を処理する。
	endCloseSubMN(e) {
		const obj = (e.target.tagName==='A')? e.target.parentNode.parentNode : e.target;
		hustle.PU.VIZ({b:false, obj});
		this.restoreClass(new RegExp('(xpnd|shrnk)CpuAnm', 'g'), obj);
		hustle.PU.delAnimEndLstnr({fn:this.fnEndClsSmmAnm, obj});
		this.onClsSmmAnim = false;
		if(hustle.RG.VISA.TOUCHPAD) this.pickUnfoldSubMN();
	}
	//----------------------------------------------------------------
	//Syntax:objectName.restoreClass(re, obj);
	//Parameter:'re'は正規表現
	//Parameter:'obj'はulタグのエレメント
	//Return:なし
	//Reference:'re'の正規表現に該当するアニメーションCSSのクラス指定を削除する。
	restoreClass(re, obj) {
		let str = hustle.PU.getClass({obj});
		str = hustle.PU.CV({str:hustle.PU.RegReplace({s:'', re, str})});
		hustle.PU.setClass({vlu:`${str}`, obj});
	}
}