/****************************************************************
studio hustlemouse
JavaScript Code "ResizeManagerClass"
Author MARUHIRO
Create:2019.10.18
Modify:2024.11.9
(c)maruhiro all rights reserved.
****************************************************************/
//----------------------------------------------------------------
// OUTLINE
//----------------------------------------------------------------
// [FIELDS]
// *MAIN
// *BXSZ
// [METHODS]
// *constructor()
// *init()
// *reset()
// *letResize()
// *letScroll()
// *getStcHsH()
// *getPageSize()
// *getElmtArea()
// *calElmtsArea()
//----------------------------------------------------------------
class ResizeManagerClass {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//----------------------------------------------------------------
	//Syntax:this.objectName = new ResizeManagerClass();
	//Parameter:obj'はMainClassオブジェクト
	//Return:なし
	constructor(obj) {
		//----------------------------------------------------------------
		// CONFIGURATION
		//----------------------------------------------------------------
		//MainClassオブジェクトの参照を指定
		this.MAIN = obj;
		//this.PhsMng;
		//this.mWH = [0, 0];
		//----------------------------------------------------------------
		//bodyの'box-sizing:border-box'指定
		this.BXSZ = false;
	}
	//----------------------------------------------------------------
	// INITIALISE
	//----------------------------------------------------------------
	//Syntax:objectName.init(obj);
	//Parameter:"obj"はPhaseManagerClassオブジェクト
	//Return:なし
	//Reference:クラスの初期化メソッド
	//init(obj) {
	init() {
		//----------------------------------------------------------------
		// CONFIGURATION
		//----------------------------------------------------------------
		this.BXSZ = hustle.PU.STYLEprp({prp:'box-sizing', obj:this.MAIN.BODY}) === 'border-box';
	}
	reset(){
		//this.tgglMainMenu(this);
		this.letResize();
		this.letScroll();
	}
	//----------------------------------------------------------------
	// RESIZE
	//----------------------------------------------------------------
	//Syntax:objectName.letResize(e);
	//Parameter:'e'はイベントオブジェクト
	//Return:なし
	//Reference:ウインドウサイズ変更に合わせてデザインのサイズとロケーションを変更する
	letResize(e) {
		this.MAIN.letDoupImg();
	}
	//----------------------------------------------------------------
	// SCHLOOL
	//----------------------------------------------------------------
	//Syntax:objectName.letScroll(e);
	//Parameter:'e'はイベントオブジェクト
	//Return:なし
	//Reference:ウインドウスクロールに合わせてデザインを移動する
	letScroll(e) {
		switch(this.MAIN.ScrlArwMng.TYPE) {
			case 'UP2TOP':
				hustle.PU.VIZ({b:(window.scrollY > 0), obj:hustle.PU.ID({id:'ArrowPageTop'})});
				break;
			case 'UPnDOWN':
			default:
				hustle.PU.VIZ({b:(window.scrollY > 0), obj:hustle.PU.ID({id:'ArrowPageTop'})});
				hustle.PU.VIZ({b:(Math.floor(this.getElmtArea(hustle.MAIN.BODY).wh[1]-hustle.BU.getInnerSize({obj:window})[1]-window.scrollY) > 1), obj:hustle.PU.ID({id:'ArrowPageBttm'})});
		}
		if(this.MAIN.MnMnMng.opnMenu) this.MAIN.MnMnMng.doTgglMainMenu(this);
		this.MAIN.letDoupImg();
	}
	//----------------------------------------------------------------
	// GET ELEMENTS SIZS
	//----------------------------------------------------------------
	//静的ヘッダ2点の高さを合算して返す。
	getStcHsH(es) {
		let r = 0;
		for(let e of es) {
			r += this.getElmtArea(e).wh[1];
		}
		return r;
	}
	//全ての静的ページエレメントによる表示サイズを取得する。
	getPageSize(pages, body) {
		const BWH = this.getElmtArea(body).wh;
		//まずは「class='page'」指定のエレメントのマージンにはマイナス値のないようにする。
		let eas = new Array();
		for(let p of pages) {
			eas.push(this.getElmtArea(p));
		}
		const wh = this.calElmtsArea(eas);
		return [wh[0],wh[1]];
	}
	//エレメントの表示領域のサイズ（単位px）を取得する。
	//'r.wh'は取得情報を全て合算した幅と高さの配列[幅,高さ]
	//'r.cntWH'は表示矩形の幅と高さの配列[幅,高さ]
	//'r.mrgn'はマージンサイズの配列[上,右,下,左]
	//'r.pdng'はパディングサイズの配列[上,右,下,左]
	//'r.brdr'はボーダーサイズの配列[上,右,下,左]
	getElmtArea(obj) {
		const r = new Object();
		const re = new RegExp('^-?\\d*\\.?\\d*', 'g');
		/* r.clntWH = new Array();r.clntWH = [obj.clientWidth, obj.clientHeight]; */
		r.cntWH = new Array();
		r.cntWH[0] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'width', obj})})[0]);
		r.cntWH[1] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'height', obj})})[0]);
		r.mrgn = new Array();
		r.mrgn[0] = r.mrgnTop = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'margin-top', obj})})[0]);
		r.mrgn[1] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'margin-right', obj})})[0]);
		r.mrgn[2] = r.mrgnBtm = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'margin-bottom', obj})})[0]);
		r.mrgn[3] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'margin-left', obj})})[0]);
		r.pdng = new Array();
		r.pdng[0] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'padding-top', obj})})[0]);
		r.pdng[1] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'padding-right', obj})})[0]);
		r.pdng[2] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'padding-bottom', obj})})[0]);
		r.pdng[3] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'padding-left', obj})})[0]);
		r.brdr = new Array();
		r.brdr[0] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'border-top-width', obj})})[0]);
		r.brdr[1] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'border-right-width', obj})})[0]);
		r.brdr[2] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'border-bottom-width', obj})})[0]);
		r.brdr[3] = Number.parseFloat(hustle.PU.RegMatch({re, str:hustle.PU.STYLEprp({prp:'border-left-width', obj})})[0]);
		r.wh = new Array();
		if(this.BXSZ) {
			//bodyが'box-sizing:border-box'指定であった場合
			r.wh[0] = r.cntWH[0] + r.mrgn[1] + r.mrgn[3];
			r.wh[1] = r.cntWH[1] + r.mrgn[0] + r.mrgn[2];
		} else {
			r.wh[0] = r.cntWH[0] + r.mrgn[1] + r.mrgn[3] + r.pdng[1] + r.pdng[3] + r.brdr[1] + r.brdr[3];
			r.wh[1] = r.cntWH[1] + r.mrgn[0] + r.mrgn[2] + r.pdng[0] + r.pdng[2] + r.brdr[0] + r.brdr[2];
		}
		return r;
	}
	//表示エレメント群のマージンの相殺処理をして各エレメントの実際の高さを算出して合算する。
	calElmtsArea(eas) {
		let r = new Array();
		for(let i=0; i<eas.length; i++) {
			let h = 0;
			if(i===0 || eas[i].mrgn[0]<0) h += eas[i].mrgn[0];
			if(i === eas.length-1 || eas[i].mrgn[2]<0) h += eas[i].mrgn[2];
			else h += (eas[i].mrgn[2] >= eas[i+1].mrgn[0])? eas[i].mrgn[2] : eas[i+1].mrgn[0];
			if(this.BXSZ) h += eas[i].cntWH[1];
			else h += eas[i].cntWH[1] + eas[i].pdng[0] + eas[i].pdng[2] + eas[i].brdr[0] + eas[i].brdr[2];
			r.push([eas[i].wh[0], h]);
		}
		r = [r.map((cv,id,ar)=>cv[0]), r.map((cv,id,ar)=>cv[1])];
		//配列に最初と最後のエレメントに指定されたマージンのそれぞれトップとボトムの値を追加する。
		return [r[0].reduce((pv,cv,id,ar)=>(pv>cv)?pv:cv), r[1].reduce((pv,cv,id,ar)=>pv+cv), eas[0].mrgnTop, eas[eas.length-1].mrgnBtm];
	}
}
