/****************************************************************
studio hustlemouse
JavaScript Code 'ScrollArrowManagerClass'
Author MARUHIRO
Create:2020.10.21
Modify:2025.1.13
(c)maruhiro all rights reserved.
****************************************************************/
//----------------------------------------------------------------
// OUTLINE
// CSS指定は「__design.scss」の「section[name='StickyScrollArrow'] {}」
//----------------------------------------------------------------
// [FIELDS]
// *MAIN
// *ISUE
// *curX
// *curY
// *trgX
// *trgY
// *TYPE
// *scrlInterval
// *fnScrlTop
// *fnScrlBttm
// *onScrlIntr
// [METHODS]
// *constructor()
// *init()
// *reset()
// *setContent()
// *initScrollToPageTop()
// *letScrolltoPagetop()
// *initScrollToPageBttm()
// *letScrolltoPagebttm()
// *doScrolltoPageSide()
// *resetScrollto()
//----------------------------------------------------------------
class ScrollArrowManagerClass {
	//----------------------------------------------------------------
	// CONSTRACTOR
	//----------------------------------------------------------------
	//Syntax:objectName = new ScrollArrowManagerClass(obj);
	//Parameter:'obj'はMainClassオブジェクト
	//Return:なし
	//Reference:クラスプロパティの準備
	constructor(obj) {
		//----------------------------------------------------------------
		// CONFIGURATION
		//----------------------------------------------------------------
		this.MAIN = obj;
		//メインオブジェクトのインターバル指定と加速度指定
		//本コンテンツ特有の描画処理を呼び出す間隔（1ms = 1/1000秒）
		//this.DILAY = 40;//整数'40'であれば'40/1000秒'で25fps（フレームパーセコンド）になる。
		//"scrollA"は速度指定で、0から1までの数値を指定する。
		//"scrollA"を1にすると通常のジャンプと同じになる。
		//this.scrollA = 0.25;//0.5*0.5
		//----------------------------------------------------------------
		this.ISUE = null;
		this.curX;
		this.curY;
		this.trgX;
		this.trgY;
		this.TYPE;//PAGE SCROLL TYPE
		//----------------------------------------------------------------
		this.scrlInterval;
		this.fnScrlTop = e => this.letScrolltoPagetop(e);
		this.fnScrlBttm = e => this.letScrolltoPagebttm(e);
		this.onScrlIntr = false;
	}
	//----------------------------------------------------------------
	// INIT
	//----------------------------------------------------------------
	//Syntax:objectName.init();
	//Parameter:なし
	//Return:なし
	//Reference:なし
	init() {
		this.ISUE = hustle.PU.QSELECT({slc:`section[name='StickyScrollArrow']`});
		if(this.ISUE!==null) {
			switch(hustle.PU.getID({obj:this.ISUE})) {
				case 'UP2TOP_PAGE_ARROW':
					this.TYPE = 'UP2TOP';
					break;
				case 'UPnDOWN_PAGE_ARROW':
				default:
					this.TYPE = 'UPnDOWN';
			}
			this.reset();
		}
	}
	//----------------------------------------------------------------
	// RESET
	//----------------------------------------------------------------
	//Syntax:objectName.reset(b);
	//Parameter:'b'は真偽値で初期値はfalse
	//Return:なし
	//Reference:運用エレメントの初期化
	reset(b=false) {
		switch(this.TYPE) {
			case 'UP2TOP':
				this.initScrollToPageTop();
				break;
			case 'UPnDOWN':
			default:
				this.initScrollToPageTop();
				this.initScrollToPageBttm();
		}
		hustle.PU.VIZ({b,obj:this.ISUE});
	}
	//----------------------------------------------------------------
	// SET CONTENT
	//----------------------------------------------------------------
	//Syntax:objectName.setContent(XM);
	//Parameter:'XM'はXmlManagerClassオブジェクト
	//Return:なし
	//Reference:運用エレメントの実装
	setContent(XM) {
		if((this.ISUE===null)) {
			/************************
			<section class='sticky' name='StickyScrollArrow' role='pageSticky' id='UP2TOP_PAGE_ARROW'>
			<nav class='content' id='ArrowPageTop' role='navigation'><span class='webIcon-ArrowUp'></span></nav>
			</section>
			<div class="joint"></div>
			もしくは、
			<section class='sticky' name='StickyScrollArrow' role='pageSticky' id='UPnDOWN_PAGE_ARROW'>
				<nav class='content' id='ArrowPageTop' role='navigation'><span class='webIcon-KeyArrowUp'></span></nav>
				<nav class='content' id='ArrowPageBttm' role='navigation'><span class='webIcon-KeyArrowDwn'></span></nav>
			</section>
			<div class="joint"></div>
			************************/
			let tmp;
			let lng = 'en';
			for(let obj of XM.registData['design']) {
				if(hustle.PU.ATBT({atr:'title', obj})==='STICKYSCROLLARROW') {
					tmp = obj;
					break;
				};
			}
			tmp = XM.refineNL(XM.digXML(tmp.childNodes));
			for(let obj of tmp) {
				if(hustle.PU.ATBT({atr:'id', obj})===lng) {
					tmp = obj;
					break;
				}
			}
			const pf = hustle.PU.QSELECT({slc:`footer[class='page']`});
			pf.insertAdjacentHTML('beforebegin', tmp.innerHTML);
			this.init();
		}
		hustle.PU.VIZ({b:true,obj:this.ISUE});
	}
	//----------------------------------------------------------------
	// SCROLL TO PAGETOP & PAGEBOTTOM
	//----------------------------------------------------------------
	//Syntax:objectName.initScrollToPageTop();
	//Parameter:なし
	//Return:なし
	//Reference:エレメント取得とイベントリスナー実装をする。
	initScrollToPageTop() {
		const a = hustle.PU.ID({id:'ArrowPageTop'});
		a.addEventListener(hustle.RG.PEV.start, this.fnScrlTop, false);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.letScrolltoPagetop(e);
	//Parameter:'e'はイベントリスナーオブジェクト
	//Return:なし
	//Reference:エレメントの運用を初期化する。
	letScrolltoPagetop(e) {
		this.resetScrollto();
		this.curX = window.scrollX;
		this.curY = window.scrollY;
		this.trgX = 0;
		this.trgY = 0;
		//インターバルイベントを起動する。
		this.scrlInterval =  window.setInterval(()=>this.doScrolltoPageSide(1/this.MAIN.scrollA), this.MAIN.DILAY);
		this.onScrlIntr = true;
	}
	//----------------------------------------------------------------
	//Syntax:objectName.initScrollToPageBttm();
	//Parameter:なし
	//Return:なし
	//Reference:エレメント取得とイベントリスナー実装をする。
	initScrollToPageBttm() {
		const a = hustle.PU.ID({id:'ArrowPageBttm'});
		a.addEventListener(hustle.RG.PEV.start, this.fnScrlBttm, false);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.letScrolltoPagebttm(e);
	//Parameter:'e'はイベントリスナーオブジェクト
	//Return:なし
	//Reference:エレメントの運用を初期化する。
	letScrolltoPagebttm(e) {
		this.resetScrollto();
		this.curX = window.scrollX;
		this.curY = window.scrollY;
		const inWH = hustle.BU.getInnerSize({obj:window});
		//ページサイズの取得方法は実装によって異なる。
		//const pgWH = this.MAIN.RszMng.getPageSize(hustle.MAIN.PAGES, hustle.MAIN.BODY);
		const pgWH = this.MAIN.RszMng.getElmtArea(hustle.MAIN.BODY).wh;
		this.trgX = pgWH[0] - inWH[0];
		this.trgY = pgWH[1] - inWH[1];
		//インターバルイベントを起動する。
		this.scrlInterval =  window.setInterval(()=>this.doScrolltoPageSide(1/this.MAIN.scrollA), this.MAIN.DILAY);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.doScrolltoPageSide(spd);
	//Parameter:'spd'は加速度の指数
	//Return:なし
	//Reference:エレメントの運用を遂行する。
	doScrolltoPageSide(spd) {
		if(this.trgX - this.curX > 1 || this.trgX - this.curX < -1) this.curX += (this.trgX - this.curX)/spd;
		else this.curX = this.trgX;
		if(this.trgY - this.curY > 1 || this.trgY - this.curY < -1) this.curY += (this.trgY - this.curY)/spd;
		else this.curY = this.trgY;
		if(this.curX === this.trgX && this.curY === this.trgY) this.resetScrollto();
		scrollTo(this.curX, this.curY);
	}
	//----------------------------------------------------------------
	//Syntax:objectName.resetScrollto();
	//Parameter:なし
	//Return:なし
	//Reference:エレメントの運用を収束させる。
	resetScrollto() {
		this.onScrlIntr = false;
		//インターバルイベントを解除する。
		window.clearInterval(this.scrlInterval);
	}
}